/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.php.internal.core.ast.match.ASTMatcher;
import org.eclipse.php.internal.core.ast.nodes.AST;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.Block;
import org.eclipse.php.internal.core.ast.nodes.ChildPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.Statement;
import org.eclipse.php.internal.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.Variable;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CatchClause
extends Statement {
    private Identifier className;
    private Variable variable;
    private Block body;
    public static final ChildPropertyDescriptor CLASS_NAME_PROPERTY = new ChildPropertyDescriptor(CatchClause.class, "className", Identifier.class, true, true);
    public static final ChildPropertyDescriptor VARIABLE_PROPERTY = new ChildPropertyDescriptor(CatchClause.class, "variable", Variable.class, true, true);
    public static final ChildPropertyDescriptor BODY_PROPERTY = new ChildPropertyDescriptor(CatchClause.class, "statement", Block.class, true, true);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<ChildPropertyDescriptor> properyList = new ArrayList<ChildPropertyDescriptor>(3);
        properyList.add(CLASS_NAME_PROPERTY);
        properyList.add(VARIABLE_PROPERTY);
        properyList.add(BODY_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(properyList);
    }

    public CatchClause(int start, int end, AST ast, Identifier className, Variable variable, Block statement) {
        super(start, end, ast);
        assert (className != null && variable != null && statement != null);
        this.className = className;
        this.variable = variable;
        this.body = statement;
        className.setParent(this, CLASS_NAME_PROPERTY);
        variable.setParent(this, VARIABLE_PROPERTY);
        statement.setParent(this, BODY_PROPERTY);
    }

    public CatchClause(AST ast) {
        super(ast);
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        this.className.accept(visitor);
        this.variable.accept(visitor);
        this.body.accept(visitor);
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.className.traverseTopDown(visitor);
        this.variable.traverseTopDown(visitor);
        this.body.traverseTopDown(visitor);
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        this.className.traverseBottomUp(visitor);
        this.variable.traverseBottomUp(visitor);
        this.body.traverseBottomUp(visitor);
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<CatchClause");
        this.appendInterval(buffer);
        buffer.append(">\n");
        buffer.append("\t").append(tab).append("<ClassName>\n");
        this.className.toString(buffer, "\t\t" + tab);
        buffer.append("\n");
        buffer.append("\t").append(tab).append("</ClassName>\n");
        this.variable.toString(buffer, "\t" + tab);
        buffer.append("\n");
        this.body.toString(buffer, "\t" + tab);
        buffer.append("\n");
        buffer.append(tab).append("</CatchClause>");
    }

    @Override
    public int getType() {
        return 9;
    }

    public Block getStatement() {
        return this.body;
    }

    public Identifier getClassName() {
        return this.className;
    }

    public void setClassName(Identifier className) {
        if (className == null) {
            throw new IllegalArgumentException();
        }
        Identifier oldChild = this.className;
        this.preReplaceChild(oldChild, className, CLASS_NAME_PROPERTY);
        this.className = className;
        this.postReplaceChild(oldChild, className, CLASS_NAME_PROPERTY);
    }

    public Variable getVariable() {
        return this.variable;
    }

    public void setVariable(Variable variable) {
        if (variable == null) {
            throw new IllegalArgumentException();
        }
        Variable oldChild = this.variable;
        this.preReplaceChild(oldChild, variable, VARIABLE_PROPERTY);
        this.variable = variable;
        this.postReplaceChild(oldChild, variable, VARIABLE_PROPERTY);
    }

    public Block getBody() {
        return this.body;
    }

    public void setBody(Block body) {
        if (body == null) {
            throw new IllegalArgumentException();
        }
        Block oldChild = this.body;
        this.preReplaceChild(oldChild, body, BODY_PROPERTY);
        this.body = body;
        this.postReplaceChild(oldChild, body, BODY_PROPERTY);
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        Block body = ASTNode.copySubtree(target, this.getBody());
        Identifier identifier = ASTNode.copySubtree(target, this.getClassName());
        Variable variable = ASTNode.copySubtree(target, this.getVariable());
        CatchClause result = new CatchClause(this.getStart(), this.getEnd(), target, identifier, variable, body);
        return result;
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(String apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == CLASS_NAME_PROPERTY) {
            if (get) {
                return this.getClassName();
            }
            this.setClassName((Identifier)child);
            return null;
        }
        if (property == VARIABLE_PROPERTY) {
            if (get) {
                return this.getVariable();
            }
            this.setVariable((Variable)child);
            return null;
        }
        if (property == BODY_PROPERTY) {
            if (get) {
                return this.getBody();
            }
            this.setBody((Block)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }
}

