/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.BindingResolver;
import org.eclipse.php.internal.core.ast.nodes.Bindings;
import org.eclipse.php.internal.core.ast.nodes.ClassInstanceCreation;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.FieldAccess;
import org.eclipse.php.internal.core.ast.nodes.FieldsDeclaration;
import org.eclipse.php.internal.core.ast.nodes.FormalParameter;
import org.eclipse.php.internal.core.ast.nodes.FunctionDeclaration;
import org.eclipse.php.internal.core.ast.nodes.FunctionInvocation;
import org.eclipse.php.internal.core.ast.nodes.IBinding;
import org.eclipse.php.internal.core.ast.nodes.IFunctionBinding;
import org.eclipse.php.internal.core.ast.nodes.IMethodBinding;
import org.eclipse.php.internal.core.ast.nodes.ITypeBinding;
import org.eclipse.php.internal.core.ast.nodes.IVariableBinding;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.Include;
import org.eclipse.php.internal.core.ast.nodes.IncludeBinding;
import org.eclipse.php.internal.core.ast.nodes.MethodBinding;
import org.eclipse.php.internal.core.ast.nodes.MethodDeclaration;
import org.eclipse.php.internal.core.ast.nodes.MethodInvocation;
import org.eclipse.php.internal.core.ast.nodes.SingleFieldDeclaration;
import org.eclipse.php.internal.core.ast.nodes.StaticConstantAccess;
import org.eclipse.php.internal.core.ast.nodes.StaticFieldAccess;
import org.eclipse.php.internal.core.ast.nodes.StaticMethodInvocation;
import org.eclipse.php.internal.core.ast.nodes.TypeBinding;
import org.eclipse.php.internal.core.ast.nodes.TypeDeclaration;
import org.eclipse.php.internal.core.ast.nodes.Variable;
import org.eclipse.php.internal.core.ast.nodes.VariableBase;
import org.eclipse.php.internal.core.ast.nodes.VariableBinding;
import org.eclipse.php.internal.core.typeinference.BindingUtility;
import org.eclipse.php.internal.core.typeinference.PHPClassType;

public class DefaultBindingResolver
extends BindingResolver {
    BindingTables bindingTables;
    private final ISourceModule sourceModule;
    WorkingCopyOwner workingCopyOwner;
    private BindingUtility bindingUtil;

    public DefaultBindingResolver(ISourceModule sourceModule, WorkingCopyOwner owner) {
        this.sourceModule = sourceModule;
        this.workingCopyOwner = owner;
        this.bindingUtil = new BindingUtility(this.sourceModule);
        this.bindingTables = new BindingTables();
    }

    ITypeBinding getTypeBinding(IType type) {
        if (type != null) {
            return new TypeBinding((BindingResolver)this, (IEvaluatedType)new PHPClassType(type.getElementName()), (IModelElement)type);
        }
        return null;
    }

    ITypeBinding getTypeBinding(IType[] types) {
        if (types != null && types.length > 0) {
            return new TypeBinding((BindingResolver)this, (IEvaluatedType)new PHPClassType(types[0].getElementName()), (IModelElement[])types);
        }
        return null;
    }

    IVariableBinding getVariableBinding(IField field) {
        if (field != null) {
            return new VariableBinding(this, field);
        }
        return null;
    }

    public IMethodBinding getMethodBinding(IMethod method) {
        if (method != null) {
            return new MethodBinding(this, method);
        }
        return null;
    }

    protected IEvaluatedType getEvaluatedType(int offset, int length) {
        try {
            return this.bindingUtil.getType(offset, length);
        }
        catch (ModelException e) {
            Logger.log(4, e.toString());
            return null;
        }
    }

    public IModelElement[] getModelElements(int offset, int length) {
        return this.getModelElements(offset, length, true);
    }

    public IModelElement[] getModelElements(int offset, int length, boolean filter) {
        try {
            return this.bindingUtil.getModelElement(offset, length, filter);
        }
        catch (ModelException e) {
            Logger.log(4, e.toString());
            return null;
        }
    }

    IBinding resolveName(Identifier name) {
        return this.resolveExpressionType(name);
    }

    IMethodBinding resolveMethod(MethodDeclaration method) {
        if (method == null || method.getFunction() == null) {
            throw new IllegalArgumentException("Can not resolve null expression");
        }
        try {
            return this.getMethodBinding((IMethod)this.sourceModule.getElementAt(method.getStart()));
        }
        catch (ModelException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            return null;
        }
    }

    ITypeBinding resolveExpressionType(Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("Can not resolve null expression");
        }
        int start = expression.getStart();
        int length = expression.getLength();
        IEvaluatedType type = this.getEvaluatedType(start, length);
        IModelElement[] modelElement = this.getModelElements(start, length, false);
        return new TypeBinding((BindingResolver)this, type, modelElement);
    }

    IBinding resolveInclude(Include includeDeclaration) {
        return new IncludeBinding(this.sourceModule, includeDeclaration);
    }

    ASTNode findDeclaringNode(IBinding binding) {
        return super.findDeclaringNode(binding);
    }

    ASTNode findDeclaringNode(String bindingKey) {
        return super.findDeclaringNode(bindingKey);
    }

    ITypeBinding getTypeBinding(SingleFieldDeclaration fieldDeclaration) {
        IModelElement[] modelElements;
        try {
            modelElements = this.bindingUtil.getModelElement(fieldDeclaration.getStart(), fieldDeclaration.getLength());
        }
        catch (ModelException e) {
            Logger.log(4, e.toString());
            return null;
        }
        if (modelElements.length > 0) {
            IModelElement[] iModelElementArray = modelElements;
            int n = modelElements.length;
            int n2 = 0;
            while (n2 < n) {
                IModelElement type = iModelElementArray[n2];
                if (type.getElementType() == 7) {
                    return new TypeBinding((BindingResolver)this, (IEvaluatedType)new PHPClassType(type.getElementName()), modelElements);
                }
                ++n2;
            }
        }
        return super.getTypeBinding(fieldDeclaration);
    }

    ITypeBinding getTypeBinding(IEvaluatedType referenceBinding) {
        return super.getTypeBinding(referenceBinding);
    }

    Object resolveConstantExpressionValue(Expression expression) {
        return super.resolveConstantExpressionValue(expression);
    }

    IMethodBinding resolveConstructor(ClassInstanceCreation expression) {
        return super.resolveConstructor(expression);
    }

    IMethodBinding resolveConstructor(MethodInvocation expression) {
        return super.resolveConstructor(expression);
    }

    IVariableBinding resolveField(FieldAccess fieldAccess) {
        Variable var;
        VariableBase member = fieldAccess.getMember();
        if (member.getType() == 60 && !(var = (Variable)member).isDollared() && var.getName().getType() == 33) {
            Identifier id = (Identifier)var.getName();
            String fieldName = "$" + id.getName();
            ITypeBinding type = fieldAccess.getDispatcher().resolveTypeBinding();
            return Bindings.findFieldInHierarchy(type, fieldName);
        }
        return null;
    }

    IVariableBinding resolveField(StaticConstantAccess constantAccess) {
        Identifier constName = constantAccess.getConstant();
        ITypeBinding type = constantAccess.getClassName().resolveTypeBinding();
        return Bindings.findFieldInHierarchy(type, constName.getName());
    }

    IVariableBinding resolveField(StaticFieldAccess fieldAccess) {
        Variable var;
        Variable member = fieldAccess.getField();
        if (((ASTNode)member).getType() == 60 && (var = member).isDollared() && var.getName().getType() == 33) {
            Identifier id = (Identifier)var.getName();
            String fieldName = "$" + id.getName();
            ITypeBinding type = fieldAccess.getClassName().resolveTypeBinding();
            return Bindings.findFieldInHierarchy(type, fieldName);
        }
        return null;
    }

    IFunctionBinding resolveFunction(FunctionDeclaration function) {
        return super.resolveFunction(function);
    }

    IFunctionBinding resolveFunction(FunctionInvocation function) {
        return super.resolveFunction(function);
    }

    IMethodBinding resolveMethod(MethodInvocation method) {
        return super.resolveMethod(method);
    }

    IMethodBinding resolveMethod(StaticMethodInvocation method) {
        return super.resolveMethod(method);
    }

    ITypeBinding resolveType(TypeDeclaration type) {
        return super.resolveType(type);
    }

    ITypeBinding resolveTypeParameter(FormalParameter typeParameter) {
        return super.resolveTypeParameter(typeParameter);
    }

    IVariableBinding resolveVariable(FieldsDeclaration variable) {
        return super.resolveVariable(variable);
    }

    IVariableBinding resolveVariable(Variable variable) {
        return super.resolveVariable(variable);
    }

    ITypeBinding resolveWellKnownType(String name) {
        return super.resolveWellKnownType(name);
    }

    protected static class BindingTables {
        Map<String, IBinding> bindingKeysToBindings;
        Map<Integer, org.eclipse.dltk.ast.ASTNode> compilerNodeToASTNode = new HashMap<Integer, org.eclipse.dltk.ast.ASTNode>();

        BindingTables() {
            this.bindingKeysToBindings = new HashMap<String, IBinding>();
        }
    }
}

