/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ITypeHierarchy;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.core.search.SearchMatch;
import org.eclipse.dltk.core.search.SearchParticipant;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.SearchRequestor;
import org.eclipse.dltk.evaluation.types.MultiTypeType;
import org.eclipse.dltk.evaluation.types.SimpleType;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.internal.core.PHPLanguageToolkit;
import org.eclipse.php.internal.core.ast.nodes.BindingResolver;
import org.eclipse.php.internal.core.ast.nodes.IMethodBinding;
import org.eclipse.php.internal.core.ast.nodes.ITypeBinding;
import org.eclipse.php.internal.core.ast.nodes.IVariableBinding;
import org.eclipse.php.internal.core.typeinference.PHPClassType;

public class TypeBinding
implements ITypeBinding {
    private IEvaluatedType type;
    private IModelElement[] elements;
    private BindingResolver resolver;

    public TypeBinding(BindingResolver resolver, IEvaluatedType type, IModelElement[] elements) {
        this.resolver = resolver;
        this.type = type;
        if (elements != null && elements.length > 0) {
            int length = elements.length;
            this.elements = new IModelElement[length];
            System.arraycopy(elements, 0, this.elements, 0, length);
        }
    }

    public TypeBinding(BindingResolver resolver, IEvaluatedType type, IModelElement element) {
        this.resolver = resolver;
        this.type = type;
        if (element != null) {
            this.elements = new IModelElement[]{element};
        }
    }

    public ITypeBinding createArrayType(int dimension) {
        return null;
    }

    public String getBinaryName() {
        if (this.isUnknown() || this.isAmbiguous()) {
            return null;
        }
        return this.elements[0].getHandleIdentifier();
    }

    public ITypeBinding getComponentType() {
        if (!this.isArray()) {
            return null;
        }
        return null;
    }

    public IVariableBinding[] getDeclaredFields() {
        if (this.isUnknown()) {
            return new IVariableBinding[0];
        }
        if (this.isClass()) {
            ArrayList<IVariableBinding> variableBindings = new ArrayList<IVariableBinding>();
            IModelElement[] iModelElementArray = this.elements;
            int n = this.elements.length;
            int n2 = 0;
            while (n2 < n) {
                block7: {
                    IModelElement element = iModelElementArray[n2];
                    IType type = (IType)element;
                    try {
                        IField[] fields = type.getFields();
                        int i = 0;
                        while (i < fields.length) {
                            IVariableBinding variableBinding = this.resolver.getVariableBinding(fields[i]);
                            if (variableBinding != null) {
                                variableBindings.add(variableBinding);
                            }
                            ++i;
                        }
                    }
                    catch (ModelException e) {
                        if (!DLTKCore.DEBUG) break block7;
                        e.printStackTrace();
                    }
                }
                ++n2;
            }
            return variableBindings.toArray(new IVariableBinding[variableBindings.size()]);
        }
        return new IVariableBinding[0];
    }

    public IMethodBinding[] getDeclaredMethods() {
        if (this.isUnknown()) {
            return new IMethodBinding[0];
        }
        if (this.isClass()) {
            ArrayList<IMethodBinding> methodBindings = new ArrayList<IMethodBinding>();
            IModelElement[] iModelElementArray = this.elements;
            int n = this.elements.length;
            int n2 = 0;
            while (n2 < n) {
                block7: {
                    IModelElement element = iModelElementArray[n2];
                    IType type = (IType)element;
                    try {
                        IMethod[] methods = type.getMethods();
                        if (methods != null) {
                            int i = 0;
                            while (i < methods.length) {
                                IMethodBinding methodBinding = this.resolver.getMethodBinding(methods[i]);
                                methodBindings.add(methodBinding);
                                ++i;
                            }
                        }
                    }
                    catch (ModelException e) {
                        if (!DLTKCore.DEBUG) break block7;
                        e.printStackTrace();
                    }
                }
                ++n2;
            }
            return methodBindings.toArray(new IMethodBinding[methodBindings.size()]);
        }
        return new IMethodBinding[0];
    }

    public int getModifiers() {
        this.isClass();
        return -1;
    }

    public int getDimensions() {
        return 0;
    }

    public ITypeBinding getElementType() {
        if (this.elements == null || this.elements.length != 1) {
            return null;
        }
        return null;
    }

    public ITypeBinding[] getInterfaces() {
        if (this.isUnknown()) {
            return new ITypeBinding[0];
        }
        final ArrayList interfaces = new ArrayList();
        IModelElement[] iModelElementArray = this.elements;
        int n = this.elements.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                IModelElement element = iModelElementArray[n2];
                IType type = (IType)element;
                try {
                    SearchEngine searchEngine = new SearchEngine();
                    IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)type.getScriptProject());
                    String[] superClassNames = type.getSuperClasses();
                    if (superClassNames != null) {
                        String[] stringArray = superClassNames;
                        int n3 = superClassNames.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String superClass = stringArray[n4];
                            int matchRule = 0;
                            SearchPattern pattern = SearchPattern.createPattern((String)superClass, (int)0, (int)0, (int)matchRule, (IDLTKLanguageToolkit)PHPLanguageToolkit.getDefault());
                            searchEngine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, new SearchRequestor(){

                                public void acceptSearchMatch(SearchMatch match) throws CoreException {
                                    IType t = (IType)match.getElement();
                                    if ((t.getFlags() & 0x10) != 0) {
                                        interfaces.add(TypeBinding.this.resolver.getTypeBinding(t));
                                    }
                                }
                            }, null);
                            ++n4;
                        }
                    }
                }
                catch (CoreException e) {
                    if (!DLTKCore.DEBUG) break block6;
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        return interfaces.toArray(new ITypeBinding[interfaces.size()]);
    }

    public String getName() {
        return this.isUnknown() ? null : this.type.getTypeName();
    }

    public ITypeBinding getSuperclass() {
        if (this.isUnknown()) {
            return null;
        }
        final ArrayList superClasses = new ArrayList(this.elements.length);
        IModelElement[] iModelElementArray = this.elements;
        int n = this.elements.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                IModelElement element = iModelElementArray[n2];
                IType type = (IType)element;
                try {
                    SearchEngine searchEngine = new SearchEngine();
                    IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)type.getScriptProject());
                    String[] superClassNames = type.getSuperClasses();
                    if (superClassNames != null) {
                        String[] stringArray = superClassNames;
                        int n3 = superClassNames.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String superClass = stringArray[n4];
                            int matchRule = 0;
                            SearchPattern pattern = SearchPattern.createPattern((String)superClass, (int)0, (int)0, (int)matchRule, (IDLTKLanguageToolkit)PHPLanguageToolkit.getDefault());
                            searchEngine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, new SearchRequestor(){

                                public void acceptSearchMatch(SearchMatch match) throws CoreException {
                                    IType t = (IType)match.getElement();
                                    if ((t.getFlags() & 0x10) == 0) {
                                        superClasses.add(t);
                                    }
                                }
                            }, null);
                            ++n4;
                        }
                    }
                }
                catch (CoreException e) {
                    if (!DLTKCore.DEBUG) break block6;
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        return this.resolver.getTypeBinding(superClasses.toArray(new IType[superClasses.size()]));
    }

    public ITypeBinding getTypeDeclaration() {
        return null;
    }

    public boolean isArray() {
        return this.type.getClass() == MultiTypeType.class;
    }

    public boolean isClass() {
        if (this.isUnknown()) {
            return false;
        }
        return this.type.getClass() == PHPClassType.class;
    }

    public boolean isInterface() {
        if (this.isUnknown()) {
            return false;
        }
        boolean result = true;
        IModelElement[] iModelElementArray = this.elements;
        int n = this.elements.length;
        int n2 = 0;
        while (n2 < n) {
            block4: {
                IModelElement element = iModelElementArray[n2];
                IType member = (IType)element;
                try {
                    result &= (member.getFlags() & 0x10) != 0;
                }
                catch (ModelException e) {
                    if (!DLTKCore.DEBUG) break block4;
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        return result;
    }

    public boolean isNullType() {
        if (this.type instanceof SimpleType) {
            return ((SimpleType)this.type).getType() == 8;
        }
        return false;
    }

    public boolean isPrimitive() {
        return this.type.getClass() == SimpleType.class && !this.isNullType();
    }

    public boolean isSubTypeCompatible(ITypeBinding otherType) {
        if (otherType == null) {
            return false;
        }
        boolean result = true;
        IModelElement[] iModelElementArray = this.elements;
        int n = this.elements.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                IModelElement element = iModelElementArray[n2];
                try {
                    IModelElement[] otherElements;
                    ITypeHierarchy supertypeHierarchy = ((IType)element).newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
                    IModelElement[] iModelElementArray2 = otherElements = ((TypeBinding)otherType).elements;
                    int n3 = otherElements.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IModelElement modelElement = iModelElementArray2[n4];
                        if (modelElement instanceof IType) {
                            result &= supertypeHierarchy.contains((IType)modelElement);
                        }
                        ++n4;
                    }
                }
                catch (ModelException e) {
                    if (!DLTKCore.DEBUG) break block6;
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        return result;
    }

    public String getKey() {
        if (this.isUnknown() || this.isAmbiguous()) {
            return null;
        }
        return this.elements[0].getHandleIdentifier();
    }

    public int getKind() {
        return 2;
    }

    public IModelElement getPHPElement() {
        if (this.isUnknown() || this.isAmbiguous()) {
            return null;
        }
        return this.elements[0];
    }

    public boolean isDeprecated() {
        return false;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof TypeBinding)) {
            return false;
        }
        TypeBinding otherBinding = (TypeBinding)other;
        if (!this.type.equals(otherBinding.type)) {
            return false;
        }
        if (this.elements == null) {
            return otherBinding.elements == null;
        }
        return this.elements.equals(otherBinding.elements);
    }

    public boolean isAmbiguous() {
        return !this.isUnknown() && this.elements.length > 1;
    }

    public boolean isUnknown() {
        return this.elements == null;
    }
}

