/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.php.internal.core.ast.nodes.BindingResolver;
import org.eclipse.php.internal.core.ast.nodes.IFunctionBinding;
import org.eclipse.php.internal.core.ast.nodes.ITypeBinding;
import org.eclipse.php.internal.core.ast.nodes.IVariableBinding;
import org.eclipse.php.internal.core.typeinference.FakeField;

public class VariableBinding
implements IVariableBinding {
    private static final int VALID_MODIFIERS = 17888;
    private final BindingResolver resolver;
    private final IField modelElement;
    private boolean isFakeField;
    private ITypeBinding declaringClassTypeBinding;

    public VariableBinding(BindingResolver resolver, IField modelElement) {
        this.resolver = resolver;
        this.modelElement = modelElement;
        this.isFakeField = modelElement instanceof FakeField;
    }

    public Object getConstantValue() {
        return null;
    }

    public ITypeBinding getDeclaringClass() {
        IType parent;
        if (this.declaringClassTypeBinding == null && (parent = this.modelElement.getDeclaringType()) instanceof IType) {
            this.declaringClassTypeBinding = this.resolver.getTypeBinding(parent);
        }
        return this.declaringClassTypeBinding;
    }

    public IFunctionBinding getDeclaringFunction() {
        return null;
    }

    public String getName() {
        return this.modelElement.getElementName();
    }

    public ITypeBinding getType() {
        return null;
    }

    public int getVariableId() {
        return 0;
    }

    public boolean isField() {
        return 8 == this.modelElement.getElementType() && !this.isFakeField;
    }

    public boolean isGlobal() {
        return false;
    }

    public boolean isLocal() {
        return false;
    }

    public boolean isParameter() {
        return false;
    }

    public String getKey() {
        return this.modelElement.getHandleIdentifier();
    }

    public int getKind() {
        return 3;
    }

    public int getModifiers() {
        block3: {
            if (this.isField()) {
                try {
                    return this.modelElement.getFlags() & 0x45E0;
                }
                catch (ModelException e) {
                    if (!DLTKCore.DEBUG) break block3;
                    e.printStackTrace();
                }
            }
        }
        return 0;
    }

    public IModelElement getPHPElement() {
        return this.modelElement;
    }

    public boolean isDeprecated() {
        return false;
    }
}

