/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.compiler.ast.nodes;

import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.utils.CorePrinter;
import org.eclipse.php.internal.core.compiler.ast.nodes.ArrayElement;
import org.eclipse.php.internal.core.compiler.ast.visitor.ASTPrintVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayCreation
extends Expression {
    private final ArrayElement[] elements;

    private ArrayCreation(int start, int end, ArrayElement[] elements) {
        super(start, end);
        assert (elements != null);
        this.elements = elements;
    }

    public ArrayCreation(int start, int end, List<ArrayElement> elements) {
        this(start, end, elements == null ? null : elements.toArray(new ArrayElement[elements.size()]));
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        boolean visit = visitor.visit((Expression)this);
        if (visit) {
            ArrayElement[] arrayElementArray = this.elements;
            int n = this.elements.length;
            int n2 = 0;
            while (n2 < n) {
                ArrayElement element = arrayElementArray[n2];
                element.traverse(visitor);
                ++n2;
            }
        }
        visitor.endvisit((Expression)this);
    }

    public int getKind() {
        return 1;
    }

    public ArrayElement[] getElements() {
        return this.elements;
    }

    public final void printNode(CorePrinter output) {
    }

    public String toString() {
        return ASTPrintVisitor.toXMLString((ASTNode)this);
    }
}

