/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.compiler.ast.nodes;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.utils.CorePrinter;
import org.eclipse.php.internal.core.compiler.ast.nodes.VarComment;
import org.eclipse.php.internal.core.compiler.ast.visitor.ASTPrintVisitor;

public class Assignment
extends Expression {
    public static final int OP_EQUAL = 0;
    public static final int OP_PLUS_EQUAL = 1;
    public static final int OP_MINUS_EQUAL = 2;
    public static final int OP_MUL_EQUAL = 3;
    public static final int OP_DIV_EQUAL = 4;
    public static final int OP_CONCAT_EQUAL = 5;
    public static final int OP_MOD_EQUAL = 6;
    public static final int OP_AND_EQUAL = 7;
    public static final int OP_OR_EQUAL = 8;
    public static final int OP_XOR_EQUAL = 9;
    public static final int OP_SL_EQUAL = 10;
    public static final int OP_SR_EQUAL = 11;
    public static final int OP_REF_EQUAL = 12;
    private final Expression variable;
    private final int operator;
    private final Expression value;
    private final VarComment varComment;

    public Assignment(int start, int end, Expression variable, int operator, Expression value) {
        this(start, end, variable, operator, value, null);
    }

    public Assignment(int start, int end, Expression variable, int operator, Expression value, VarComment varComment) {
        super(start, end);
        assert (variable != null && value != null);
        this.variable = variable;
        this.operator = operator;
        this.value = value;
        this.varComment = varComment;
    }

    public VarComment getVarComment() {
        return this.varComment;
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        boolean visit = visitor.visit((Expression)this);
        if (visit) {
            this.variable.traverse(visitor);
            this.value.traverse(visitor);
        }
        visitor.endvisit((Expression)this);
    }

    public String getOperator() {
        switch (this.getOperatorType()) {
            case 0: {
                return "=";
            }
            case 1: {
                return "+=";
            }
            case 2: {
                return "-=";
            }
            case 3: {
                return "*=";
            }
            case 4: {
                return "/=";
            }
            case 6: {
                return "%=";
            }
            case 5: {
                return ".=";
            }
            case 7: {
                return "&=";
            }
            case 8: {
                return "|=";
            }
            case 9: {
                return "^=";
            }
            case 10: {
                return "<<=";
            }
            case 11: {
                return ">>=";
            }
            case 12: {
                return "=&";
            }
        }
        throw new IllegalArgumentException();
    }

    public int getKind() {
        return 3;
    }

    public int getOperatorType() {
        return this.operator;
    }

    public Expression getValue() {
        return this.value;
    }

    public Expression getVariable() {
        return this.variable;
    }

    public final void printNode(CorePrinter output) {
    }

    public String toString() {
        return ASTPrintVisitor.toXMLString((ASTNode)this);
    }
}

