/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.compiler.ast.nodes;

import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.utils.CorePrinter;
import org.eclipse.php.internal.core.compiler.ast.visitor.ASTPrintVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeclareStatement
extends Statement {
    private final String[] directiveNames;
    private final Expression[] directiveValues;
    private final Statement action;

    private DeclareStatement(int start, int end, String[] directiveNames, Expression[] directiveValues, Statement action) {
        super(start, end);
        assert (directiveNames != null && directiveValues != null && directiveNames.length == directiveValues.length);
        this.directiveNames = directiveNames;
        this.directiveValues = directiveValues;
        this.action = action;
    }

    public DeclareStatement(int start, int end, List<String> directiveNames, List<? extends Expression> directiveValues, Statement action) {
        this(start, end, directiveNames == null ? null : directiveNames.toArray(new String[directiveNames.size()]), directiveValues == null ? null : directiveValues.toArray(new Expression[directiveValues.size()]), action);
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        boolean visit = visitor.visit((Statement)this);
        if (visit) {
            int i = 0;
            while (i < this.directiveNames.length) {
                this.directiveValues[i].traverse(visitor);
                ++i;
            }
            this.action.traverse(visitor);
        }
        visitor.endvisit((Statement)this);
    }

    public int getKind() {
        return 19;
    }

    public Statement getAction() {
        return this.action;
    }

    public String[] getDirectiveNames() {
        return this.directiveNames;
    }

    public Expression[] getDirectiveValues() {
        return this.directiveValues;
    }

    public final void printNode(CorePrinter output) {
    }

    public String toString() {
        return ASTPrintVisitor.toXMLString((ASTNode)this);
    }
}

