/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.compiler.ast.nodes;

import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.utils.CorePrinter;
import org.eclipse.php.internal.core.compiler.ast.visitor.ASTPrintVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForStatement
extends Statement {
    private final Expression[] initializations;
    private final Expression[] conditions;
    private final Expression[] increasements;
    private final Statement action;

    private ForStatement(int start, int end, Expression[] initializations, Expression[] conditions, Expression[] increasements, Statement action) {
        super(start, end);
        assert (initializations != null && conditions != null && increasements != null && action != null);
        this.initializations = initializations;
        this.conditions = conditions;
        this.increasements = increasements;
        this.action = action;
    }

    public ForStatement(int start, int end, List<? extends Expression> initializations, List<? extends Expression> conditions, List<? extends Expression> increasements, Statement action) {
        this(start, end, initializations == null ? null : initializations.toArray(new Expression[initializations.size()]), conditions == null ? null : conditions.toArray(new Expression[conditions.size()]), increasements == null ? null : increasements.toArray(new Expression[increasements.size()]), action);
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        boolean visit = visitor.visit((Statement)this);
        if (visit) {
            Expression[] expressionArray = this.initializations;
            int n = this.initializations.length;
            int n2 = 0;
            while (n2 < n) {
                Expression initialization = expressionArray[n2];
                initialization.traverse(visitor);
                ++n2;
            }
            expressionArray = this.conditions;
            n = this.conditions.length;
            n2 = 0;
            while (n2 < n) {
                Expression condition = expressionArray[n2];
                condition.traverse(visitor);
                ++n2;
            }
            expressionArray = this.increasements;
            n = this.increasements.length;
            n2 = 0;
            while (n2 < n) {
                Expression increasement = expressionArray[n2];
                increasement.traverse(visitor);
                ++n2;
            }
            this.action.traverse(visitor);
        }
        visitor.endvisit((Statement)this);
    }

    public int getKind() {
        return 28;
    }

    public Statement getAction() {
        return this.action;
    }

    public Expression[] getConditions() {
        return this.conditions;
    }

    public Expression[] getIncreasements() {
        return this.increasements;
    }

    public Expression[] getInitializations() {
        return this.initializations;
    }

    public final void printNode(CorePrinter output) {
    }

    public String toString() {
        return ASTPrintVisitor.toXMLString((ASTNode)this);
    }
}

