/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.compiler.ast.nodes;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.FieldDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.utils.CorePrinter;
import org.eclipse.php.internal.core.compiler.ast.nodes.IPHPDocAwareDeclaration;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.internal.core.compiler.ast.visitor.ASTPrintVisitor;

public class PHPFieldDeclaration
extends FieldDeclaration
implements IPHPDocAwareDeclaration {
    private int declStart;
    private Expression initializer;
    private PHPDocBlock phpDoc;

    public PHPFieldDeclaration(VariableReference variable, Expression initializer, int start, int end, int modifiers, int declStart, PHPDocBlock phpDoc) {
        super(variable.getName(), variable.sourceStart(), variable.sourceEnd(), start, end);
        if ((modifiers & 0x20) == 0 && (modifiers & 0x40) == 0) {
            modifiers |= 0x80;
        }
        this.setModifiers(modifiers);
        this.declStart = declStart;
        this.initializer = initializer;
        this.phpDoc = phpDoc;
    }

    public PHPDocBlock getPHPDoc() {
        return this.phpDoc;
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        boolean visit = visitor.visit((Statement)this);
        if (visit) {
            this.getRef().traverse(visitor);
            if (this.initializer != null) {
                this.initializer.traverse(visitor);
            }
        }
        visitor.endvisit((Statement)this);
    }

    public int getKind() {
        return 25;
    }

    public Expression getVariableValue() {
        return this.initializer;
    }

    public int getDeclarationStart() {
        return this.declStart;
    }

    public final void printNode(CorePrinter output) {
    }

    public String toString() {
        return ASTPrintVisitor.toXMLString((ASTNode)this);
    }
}

