/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.compiler.ast.nodes;

import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.utils.CorePrinter;
import org.eclipse.php.internal.core.compiler.ast.nodes.CatchClause;
import org.eclipse.php.internal.core.compiler.ast.visitor.ASTPrintVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TryStatement
extends Statement {
    private final Block tryStatement;
    private final CatchClause[] catchClauses;

    private TryStatement(int start, int end, Block tryStatement, CatchClause[] catchClauses) {
        super(start, end);
        assert (tryStatement != null && catchClauses != null);
        this.tryStatement = tryStatement;
        this.catchClauses = catchClauses;
    }

    public TryStatement(int start, int end, Block tryStatement, List<CatchClause> catchClauses) {
        this(start, end, tryStatement, catchClauses == null ? null : catchClauses.toArray(new CatchClause[catchClauses.size()]));
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        boolean visit = visitor.visit((Statement)this);
        if (visit) {
            this.tryStatement.traverse(visitor);
            CatchClause[] catchClauseArray = this.catchClauses;
            int n = this.catchClauses.length;
            int n2 = 0;
            while (n2 < n) {
                CatchClause catchClause = catchClauseArray[n2];
                catchClause.traverse(visitor);
                ++n2;
            }
        }
        visitor.endvisit((Statement)this);
    }

    public int getKind() {
        return 58;
    }

    public CatchClause[] getCatchClauses() {
        return this.catchClauses;
    }

    public Block getTryStatement() {
        return this.tryStatement;
    }

    public final void printNode(CorePrinter output) {
    }

    public String toString() {
        return ASTPrintVisitor.toXMLString((ASTNode)this);
    }
}

