/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.compiler.ast.parser;

import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.Argument;
import org.eclipse.dltk.ast.declarations.Declaration;
import org.eclipse.dltk.ast.declarations.FieldDeclaration;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.CallArgumentsList;
import org.eclipse.dltk.ast.expressions.CallExpression;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.evaluation.types.UnknownType;
import org.eclipse.dltk.ti.BasicContext;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.ISourceModuleContext;
import org.eclipse.dltk.ti.InstanceContext;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.compiler.ast.nodes.ASTError;
import org.eclipse.php.internal.core.compiler.ast.nodes.Scalar;
import org.eclipse.php.internal.core.typeinference.MethodContext;
import org.eclipse.php.internal.core.typeinference.PHPClassType;

public class ASTUtils {
    public static String stripQuotes(String name) {
        int len = name.length();
        if (len > 1 && (name.charAt(0) == '\'' && name.charAt(len - 1) == '\'' || name.charAt(0) == '\"' && name.charAt(len - 1) == '\"')) {
            name = name.substring(1, len - 1);
        }
        return name;
    }

    public static ASTNode findMinimalNode(ModuleDeclaration unit, int start, int end) {
        class Visitor
        extends ASTVisitor {
            ASTNode result = null;
            int start;
            int end;

            public Visitor(int start, int end) {
                this.start = start;
                this.end = end;
            }

            public ASTNode getResult() {
                return this.result;
            }

            public boolean visitGeneral(ASTNode s) throws Exception {
                int realStart = s.sourceStart();
                int realEnd = s.sourceEnd();
                if (s instanceof Block) {
                    realEnd = -42;
                    realStart = -42;
                } else if (s instanceof TypeDeclaration) {
                    TypeDeclaration declaration = (TypeDeclaration)s;
                    realStart = declaration.sourceStart();
                    realEnd = declaration.sourceEnd();
                } else if (s instanceof MethodDeclaration) {
                    MethodDeclaration declaration = (MethodDeclaration)s;
                    realStart = declaration.sourceStart();
                    realEnd = declaration.sourceEnd();
                }
                if (realStart <= this.start && realEnd >= this.end) {
                    if (this.result != null) {
                        if (s.sourceStart() >= this.result.sourceStart() && s.sourceEnd() <= this.result.sourceEnd()) {
                            this.result = s;
                        }
                    } else {
                        this.result = s;
                    }
                    if (DLTKCore.DEBUG_SELECTION) {
                        System.out.println("Found " + s.getClass().getName());
                    }
                }
                return true;
            }
        }
        Visitor visitor = new Visitor(start, end);
        try {
            unit.traverse((ASTVisitor)visitor);
        }
        catch (Exception e) {
            Logger.logException(e);
        }
        return visitor.getResult();
    }

    public static ASTNode findMaximalNodeEndingAt(ModuleDeclaration unit, int boundaryOffset) {
        class Visitor
        extends ASTVisitor {
            ASTNode result = null;
            private final /* synthetic */ int val$boundaryOffset;

            Visitor(int n) {
                this.val$boundaryOffset = n;
            }

            public ASTNode getResult() {
                return this.result;
            }

            public boolean visitGeneral(ASTNode s) throws Exception {
                if (s.sourceStart() < 0 || s.sourceEnd() < 0) {
                    return true;
                }
                int sourceEnd = s.sourceEnd();
                if (Math.abs(sourceEnd - this.val$boundaryOffset) <= 0) {
                    this.result = s;
                }
                return true;
            }
        }
        Visitor visitor = new Visitor(boundaryOffset);
        try {
            unit.traverse((ASTVisitor)visitor);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return visitor.getResult();
    }

    public static ASTNode[] restoreWayToNode(ModuleDeclaration module, final ASTNode node) {
        final Stack stack = new Stack();
        ASTVisitor visitor = new ASTVisitor(){
            boolean found = false;

            public boolean visitGeneral(ASTNode n) throws Exception {
                if (this.found) {
                    return super.visitGeneral(n);
                }
                stack.push(n);
                if (n.equals(node)) {
                    this.found = true;
                }
                return super.visitGeneral(n);
            }

            public void endvisitGeneral(ASTNode n) throws Exception {
                super.endvisitGeneral(n);
                if (this.found) {
                    return;
                }
                stack.pop();
            }
        };
        try {
            module.traverse(visitor);
        }
        catch (Exception e) {
            Logger.logException(e);
        }
        return stack.toArray(new ASTNode[stack.size()]);
    }

    public static IContext findContext(ISourceModule sourceModule, ModuleDeclaration unit, ASTNode target) {
        class Visitor
        extends ASTVisitor {
            private IContext context;
            private Stack<IContext> contextStack = new Stack();
            private final /* synthetic */ ASTNode val$target;
            private final /* synthetic */ ISourceModule val$sourceModule;

            Visitor(ASTNode aSTNode, ISourceModule iSourceModule) {
                this.val$target = aSTNode;
                this.val$sourceModule = iSourceModule;
            }

            public IContext getContext() {
                return this.context;
            }

            public boolean visitGeneral(ASTNode node) throws Exception {
                if (node == this.val$target) {
                    this.context = this.contextStack.peek();
                    return false;
                }
                return this.context == null;
            }

            public boolean visit(ModuleDeclaration node) throws Exception {
                this.contextStack.push((IContext)new BasicContext(this.val$sourceModule, node));
                return this.visitGeneral((ASTNode)node);
            }

            public boolean visit(TypeDeclaration node) throws Exception {
                this.contextStack.push((IContext)new InstanceContext((ISourceModuleContext)this.contextStack.peek(), (IEvaluatedType)new PHPClassType(node.getName())));
                return this.visitGeneral((ASTNode)node);
            }

            public boolean visit(MethodDeclaration node) throws Exception {
                LinkedList<String> argumentsList = new LinkedList<String>();
                LinkedList<IEvaluatedType> argTypes = new LinkedList<IEvaluatedType>();
                List args = node.getArguments();
                for (Argument a : args) {
                    argumentsList.add(a.getName());
                    argTypes.add(UnknownType.INSTANCE);
                }
                IContext parent = this.contextStack.peek();
                ModuleDeclaration rootNode = ((ISourceModuleContext)parent).getRootNode();
                this.contextStack.push(new MethodContext(parent, this.val$sourceModule, rootNode, node, argumentsList.toArray(new String[argumentsList.size()]), argTypes.toArray(new IEvaluatedType[argTypes.size()])));
                return this.visitGeneral((ASTNode)node);
            }

            public boolean endvisit(ModuleDeclaration node) throws Exception {
                this.contextStack.pop();
                this.endvisitGeneral((ASTNode)node);
                return true;
            }

            public boolean endvisit(TypeDeclaration node) throws Exception {
                this.contextStack.pop();
                this.endvisitGeneral((ASTNode)node);
                return true;
            }

            public boolean endvisit(MethodDeclaration node) throws Exception {
                this.contextStack.pop();
                this.endvisitGeneral((ASTNode)node);
                return true;
            }
        }
        Visitor visitor = new Visitor(target, sourceModule);
        try {
            unit.traverse((ASTVisitor)visitor);
        }
        catch (Exception e) {
            Logger.logException(e);
        }
        return visitor.getContext();
    }

    public static IContext findContext(ISourceModule sourceModule, ModuleDeclaration unit, int offset) {
        class Visitor
        extends ASTVisitor {
            private IContext context;
            private Stack<IContext> contextStack = new Stack();
            private final /* synthetic */ int val$offset;
            private final /* synthetic */ ISourceModule val$sourceModule;

            Visitor(int n, ISourceModule iSourceModule) {
                this.val$offset = n;
                this.val$sourceModule = iSourceModule;
            }

            public IContext getContext() {
                return this.context;
            }

            public boolean visitGeneral(ASTNode node) throws Exception {
                if (!(node instanceof ASTError) && node.sourceStart() <= this.val$offset && node.sourceEnd() >= this.val$offset && !this.contextStack.isEmpty()) {
                    this.context = this.contextStack.peek();
                }
                return true;
            }

            public boolean visit(ModuleDeclaration node) throws Exception {
                this.contextStack.push((IContext)new BasicContext(this.val$sourceModule, node));
                return this.visitGeneral((ASTNode)node);
            }

            public boolean visit(TypeDeclaration node) throws Exception {
                this.contextStack.push((IContext)new InstanceContext((ISourceModuleContext)this.contextStack.peek(), (IEvaluatedType)new PHPClassType(node.getName())));
                return this.visitGeneral((ASTNode)node);
            }

            public boolean visit(MethodDeclaration node) throws Exception {
                LinkedList<String> argumentsList = new LinkedList<String>();
                LinkedList<IEvaluatedType> argTypes = new LinkedList<IEvaluatedType>();
                List args = node.getArguments();
                for (Argument a : args) {
                    argumentsList.add(a.getName());
                    argTypes.add(UnknownType.INSTANCE);
                }
                IContext parent = this.contextStack.peek();
                ModuleDeclaration rootNode = ((ISourceModuleContext)parent).getRootNode();
                this.contextStack.push(new MethodContext(parent, this.val$sourceModule, rootNode, node, argumentsList.toArray(new String[argumentsList.size()]), argTypes.toArray(new IEvaluatedType[argTypes.size()])));
                return this.visitGeneral((ASTNode)node);
            }

            public boolean endvisit(ModuleDeclaration node) throws Exception {
                this.contextStack.pop();
                this.endvisitGeneral((ASTNode)node);
                return true;
            }

            public boolean endvisit(TypeDeclaration node) throws Exception {
                this.contextStack.pop();
                this.endvisitGeneral((ASTNode)node);
                return true;
            }

            public boolean endvisit(MethodDeclaration node) throws Exception {
                this.contextStack.pop();
                this.endvisitGeneral((ASTNode)node);
                return true;
            }
        }
        Visitor visitor = new Visitor(offset, sourceModule);
        try {
            unit.traverse((ASTVisitor)visitor);
        }
        catch (Exception e) {
            Logger.logException(e);
        }
        return visitor.getContext();
    }

    public static Declaration findDeclarationAfterPHPdoc(ModuleDeclaration moduleDeclaration, final int offset) {
        final Declaration[] decl = new Declaration[1];
        ASTVisitor visitor = new ASTVisitor(){
            boolean found = false;

            public boolean visit(MethodDeclaration m) {
                if (!this.found && m.sourceStart() > offset) {
                    decl[0] = m;
                    this.found = true;
                    return false;
                }
                return !this.found;
            }

            public boolean visit(TypeDeclaration t) {
                if (!this.found && t.sourceStart() > offset) {
                    decl[0] = t;
                    this.found = true;
                    return false;
                }
                return !this.found;
            }

            public boolean visitGeneral(ASTNode n) {
                if (!this.found && n.sourceStart() > offset) {
                    this.found = true;
                    return false;
                }
                return !this.found;
            }
        };
        try {
            moduleDeclaration.traverse(visitor);
        }
        catch (Exception e) {
            Logger.logException(e);
        }
        return decl[0];
    }

    public static FieldDeclaration getConstantDeclaration(CallExpression callExpression) {
        ASTNode argument;
        CallArgumentsList args;
        String name = callExpression.getName();
        if ("define".equalsIgnoreCase(name) && (args = callExpression.getArgs()) != null && args.getChilds() != null && (argument = (ASTNode)args.getChilds().get(0)) instanceof Scalar) {
            String constant = ASTUtils.stripQuotes(((Scalar)argument).getValue());
            return new FieldDeclaration(constant, argument.sourceStart(), argument.sourceEnd(), callExpression.sourceStart(), callExpression.sourceEnd());
        }
        return null;
    }
}

