/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.compiler.ast.parser;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.Argument;
import org.eclipse.dltk.ast.declarations.Declaration;
import org.eclipse.dltk.ast.declarations.FieldDeclaration;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.CallArgumentsList;
import org.eclipse.dltk.ast.expressions.CallExpression;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.ConstantReference;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.references.TypeReference;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.compiler.ISourceElementRequestor;
import org.eclipse.dltk.compiler.SourceElementRequestVisitor;
import org.eclipse.dltk.compiler.env.ISourceModule;
import org.eclipse.php.core.PHPSourceElementRequestorExtension;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.compiler.ast.nodes.Assignment;
import org.eclipse.php.internal.core.compiler.ast.nodes.CatchClause;
import org.eclipse.php.internal.core.compiler.ast.nodes.ClassConstantDeclaration;
import org.eclipse.php.internal.core.compiler.ast.nodes.ClassDeclaration;
import org.eclipse.php.internal.core.compiler.ast.nodes.FieldAccess;
import org.eclipse.php.internal.core.compiler.ast.nodes.ForEachStatement;
import org.eclipse.php.internal.core.compiler.ast.nodes.IPHPDocAwareDeclaration;
import org.eclipse.php.internal.core.compiler.ast.nodes.Include;
import org.eclipse.php.internal.core.compiler.ast.nodes.InterfaceDeclaration;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPCallExpression;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocTag;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPFieldDeclaration;
import org.eclipse.php.internal.core.compiler.ast.nodes.Scalar;
import org.eclipse.php.internal.core.compiler.ast.parser.ASTUtils;

public class PHPSourceElementRequestor
extends SourceElementRequestVisitor {
    private static final String CONSTRUCTOR_NAME = "__construct";
    protected Stack<Declaration> declarations = new Stack();
    private PHPSourceElementRequestorExtension[] extensions;
    protected List<Declaration> deferredDeclarations = new LinkedList<Declaration>();
    private static final Pattern WHITESPACE_SEPERATOR = Pattern.compile("\\s+");

    public PHPSourceElementRequestor(ISourceElementRequestor requestor, ISourceModule sourceModule) {
        super(requestor);
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.php.core", "phpSourceElementRequestors");
        ArrayList<PHPSourceElementRequestorExtension> requestors = new ArrayList<PHPSourceElementRequestorExtension>(elements.length);
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                PHPSourceElementRequestorExtension extension = (PHPSourceElementRequestorExtension)((Object)element.createExecutableExtension("class"));
                extension.setRequestor(this.fRequestor);
                extension.setSourceModule(sourceModule);
                requestors.add(extension);
            }
            catch (CoreException e) {
                Logger.logException(e);
            }
            ++n2;
        }
        this.extensions = requestors.toArray(new PHPSourceElementRequestorExtension[requestors.size()]);
    }

    public MethodDeclaration getCurrentMethod() {
        Declaration currDecleration = this.declarations.peek();
        if (currDecleration instanceof MethodDeclaration) {
            return (MethodDeclaration)currDecleration;
        }
        return null;
    }

    public boolean endvisit(MethodDeclaration method) throws Exception {
        this.declarations.pop();
        PHPSourceElementRequestorExtension[] pHPSourceElementRequestorExtensionArray = this.extensions;
        int n = this.extensions.length;
        int n2 = 0;
        while (n2 < n) {
            PHPSourceElementRequestorExtension visitor = pHPSourceElementRequestorExtensionArray[n2];
            visitor.endvisit(method);
            ++n2;
        }
        return super.endvisit(method);
    }

    public boolean endvisit(TypeDeclaration type) throws Exception {
        this.declarations.pop();
        this.resolveMagicMembers(type);
        PHPSourceElementRequestorExtension[] pHPSourceElementRequestorExtensionArray = this.extensions;
        int n = this.extensions.length;
        int n2 = 0;
        while (n2 < n) {
            PHPSourceElementRequestorExtension visitor = pHPSourceElementRequestorExtensionArray[n2];
            visitor.endvisit(type);
            ++n2;
        }
        return super.endvisit(type);
    }

    public boolean visit(MethodDeclaration method) throws Exception {
        Declaration parentDeclaration = null;
        if (!this.declarations.empty()) {
            parentDeclaration = this.declarations.peek();
        }
        if (parentDeclaration instanceof MethodDeclaration) {
            this.deferredDeclarations.add((Declaration)method);
            return false;
        }
        if (parentDeclaration instanceof InterfaceDeclaration) {
            method.setModifier(1);
        }
        this.declarations.push((Declaration)method);
        PHPSourceElementRequestorExtension[] pHPSourceElementRequestorExtensionArray = this.extensions;
        int n = this.extensions.length;
        int n2 = 0;
        while (n2 < n) {
            PHPSourceElementRequestorExtension visitor = pHPSourceElementRequestorExtensionArray[n2];
            visitor.visit(method);
            ++n2;
        }
        boolean visit = super.visit(method);
        if (visit) {
            List arguments = method.getArguments();
            for (Argument arg : arguments) {
                ISourceElementRequestor.FieldInfo info = new ISourceElementRequestor.FieldInfo();
                info.name = arg.getName();
                info.modifiers = 128;
                info.nameSourceStart = arg.getNameStart();
                info.nameSourceEnd = arg.getNameEnd() - 1;
                info.declarationStart = arg.sourceStart();
                this.fRequestor.enterField(info);
                this.fRequestor.exitField(arg.sourceEnd() - 1);
            }
        }
        return visit;
    }

    protected void modifyMethodInfo(MethodDeclaration methodDeclaration, ISourceElementRequestor.MethodInfo mi) {
        IPHPDocAwareDeclaration phpDocAwareDeclaration;
        PHPDocBlock phpDoc;
        Declaration parentDeclaration = null;
        this.declarations.pop();
        if (!this.declarations.empty()) {
            parentDeclaration = this.declarations.peek();
        }
        this.declarations.push((Declaration)methodDeclaration);
        boolean bl = mi.isConstructor = mi.name.equalsIgnoreCase(CONSTRUCTOR_NAME) || parentDeclaration instanceof ClassDeclaration && mi.name.equalsIgnoreCase(((ClassDeclaration)parentDeclaration).getName());
        if (methodDeclaration instanceof IPHPDocAwareDeclaration && (phpDoc = (phpDocAwareDeclaration = (IPHPDocAwareDeclaration)methodDeclaration).getPHPDoc()) != null && phpDoc.getTags(21).length > 0) {
            mi.modifiers |= 0x80000;
        }
    }

    public boolean visit(TypeDeclaration type) throws Exception {
        if (!this.declarations.empty() && this.declarations.peek() instanceof MethodDeclaration) {
            this.deferredDeclarations.add((Declaration)type);
            return false;
        }
        this.declarations.push((Declaration)type);
        PHPSourceElementRequestorExtension[] pHPSourceElementRequestorExtensionArray = this.extensions;
        int n = this.extensions.length;
        int n2 = 0;
        while (n2 < n) {
            PHPSourceElementRequestorExtension visitor = pHPSourceElementRequestorExtensionArray[n2];
            visitor.visit(type);
            ++n2;
        }
        return super.visit(type);
    }

    protected void modifyClassInfo(TypeDeclaration typeDeclaration, ISourceElementRequestor.TypeInfo ti) {
        IPHPDocAwareDeclaration phpDocAwareDeclaration;
        PHPDocBlock phpDoc;
        if (typeDeclaration instanceof IPHPDocAwareDeclaration && (phpDoc = (phpDocAwareDeclaration = (IPHPDocAwareDeclaration)typeDeclaration).getPHPDoc()) != null && phpDoc.getTags(21).length > 0) {
            ti.modifiers |= 0x80000;
        }
    }

    private void resolveMagicMembers(TypeDeclaration type) {
        IPHPDocAwareDeclaration declaration;
        PHPDocBlock doc;
        if (type instanceof IPHPDocAwareDeclaration && (doc = (declaration = (IPHPDocAwareDeclaration)type).getPHPDoc()) != null) {
            PHPDocTag[] tags;
            PHPDocTag[] pHPDocTagArray = tags = doc.getTags();
            int n = tags.length;
            int n2 = 0;
            while (n2 < n) {
                SimpleReference var;
                String[] split;
                PHPDocTag docTag = pHPDocTagArray[n2];
                int tagKind = docTag.getTagKind();
                if (tagKind == 30 || tagKind == 31 || tagKind == 32) {
                    split = WHITESPACE_SEPERATOR.split(docTag.getValue().trim());
                    if (split.length < 2) break;
                    ISourceElementRequestor.FieldInfo info = new ISourceElementRequestor.FieldInfo();
                    info.modifiers = 128;
                    info.name = split[1];
                    var = new SimpleReference(docTag.sourceStart(), docTag.sourceStart() + 9, this.removeParenthesis(split));
                    info.nameSourceStart = var.sourceStart();
                    info.nameSourceEnd = var.sourceEnd() - 1;
                    info.declarationStart = info.nameSourceStart;
                    this.fRequestor.enterField(info);
                    this.fRequestor.exitField(info.nameSourceEnd);
                } else if (tagKind == 33) {
                    split = WHITESPACE_SEPERATOR.split(docTag.getValue().trim());
                    if (split.length < 2) break;
                    ISourceElementRequestor.MethodInfo mi = new ISourceElementRequestor.MethodInfo();
                    mi.parameterNames = null;
                    mi.name = this.removeParenthesis(split);
                    var = new SimpleReference(docTag.sourceStart(), docTag.sourceStart() + 5, this.removeParenthesis(split));
                    mi.modifiers = 128;
                    mi.nameSourceStart = var.sourceStart();
                    mi.nameSourceEnd = var.sourceEnd() - 1;
                    mi.declarationStart = mi.nameSourceStart;
                    mi.isConstructor = false;
                    this.fRequestor.enterMethod(mi);
                    this.fRequestor.exitMethod(mi.nameSourceEnd);
                }
                ++n2;
            }
        }
    }

    private String removeParenthesis(String[] split) {
        String name = split[1];
        return name.endsWith("()") ? name.substring(0, name.length() - 2) : name;
    }

    public boolean visit(FieldDeclaration declaration) throws Exception {
        ISourceElementRequestor.FieldInfo info = new ISourceElementRequestor.FieldInfo();
        info.modifiers = 140;
        info.name = declaration.getName();
        info.nameSourceStart = declaration.getNameStart();
        info.nameSourceEnd = declaration.getNameEnd() - 1;
        info.declarationStart = declaration.sourceStart();
        this.fRequestor.enterField(info);
        this.fRequestor.exitField(declaration.sourceEnd() - 1);
        return true;
    }

    public boolean endvisit(FieldDeclaration declaration) throws Exception {
        return true;
    }

    public boolean visit(PHPFieldDeclaration declaration) throws Exception {
        ISourceElementRequestor.FieldInfo info = new ISourceElementRequestor.FieldInfo();
        info.modifiers = declaration.getModifiers();
        info.name = declaration.getName();
        SimpleReference var = declaration.getRef();
        info.nameSourceEnd = var.sourceEnd() - 1;
        info.nameSourceStart = var.sourceStart();
        info.declarationStart = declaration.getDeclarationStart();
        this.fRequestor.enterField(info);
        return true;
    }

    public boolean visit(CatchClause catchClause) throws Exception {
        ISourceElementRequestor.FieldInfo info = new ISourceElementRequestor.FieldInfo();
        info.modifiers = 128;
        VariableReference var = catchClause.getVariable();
        info.name = var.getName();
        info.nameSourceEnd = var.sourceEnd() - 1;
        info.nameSourceStart = var.sourceStart();
        info.declarationStart = catchClause.sourceStart();
        this.fRequestor.enterField(info);
        return true;
    }

    public boolean endvisit(CatchClause catchClause) throws Exception {
        this.fRequestor.exitField(catchClause.sourceEnd() - 1);
        return true;
    }

    public boolean visit(ForEachStatement foreachStatement) throws Exception {
        ISourceElementRequestor.FieldInfo info;
        SimpleReference var;
        if (foreachStatement.getKey() instanceof VariableReference) {
            var = (SimpleReference)foreachStatement.getKey();
            info = new ISourceElementRequestor.FieldInfo();
            info.modifiers = 128;
            info.name = var.getName();
            info.nameSourceEnd = var.sourceEnd() - 1;
            info.nameSourceStart = var.sourceStart();
            info.declarationStart = var.sourceStart();
            this.fRequestor.enterField(info);
            this.fRequestor.exitField(var.sourceEnd() - 1);
        }
        if (foreachStatement.getValue() instanceof VariableReference) {
            var = (SimpleReference)foreachStatement.getValue();
            info = new ISourceElementRequestor.FieldInfo();
            info.modifiers = 128;
            info.name = var.getName();
            info.nameSourceEnd = var.sourceEnd() - 1;
            info.nameSourceStart = var.sourceStart();
            info.declarationStart = var.sourceStart();
            this.fRequestor.enterField(info);
            this.fRequestor.exitField(var.sourceEnd() - 1);
        }
        return true;
    }

    public boolean endvisit(ForEachStatement foreachStatement) throws Exception {
        return true;
    }

    public boolean endvisit(PHPFieldDeclaration declaration) throws Exception {
        this.fRequestor.exitField(declaration.sourceEnd() - 1);
        return true;
    }

    public boolean visit(CallExpression call) throws Exception {
        FieldDeclaration constantDecl = ASTUtils.getConstantDeclaration(call);
        if (constantDecl != null) {
            if (!this.declarations.empty() && this.declarations.peek() instanceof MethodDeclaration) {
                this.deferredDeclarations.add((Declaration)constantDecl);
                return false;
            }
            this.visit(constantDecl);
        } else {
            int argsCount = 0;
            CallArgumentsList args = call.getArgs();
            if (args != null && args.getChilds() != null) {
                argsCount = args.getChilds().size();
            }
            this.fRequestor.acceptMethodReference(call.getName().toCharArray(), argsCount, call.sourceStart(), call.sourceEnd());
        }
        return true;
    }

    public boolean visit(Include include) throws Exception {
        if (include.getExpr() instanceof Scalar) {
            Scalar filePath = (Scalar)include.getExpr();
            this.fRequestor.acceptMethodReference("include".toCharArray(), 0, filePath.sourceStart(), filePath.sourceEnd());
        }
        return true;
    }

    public boolean visit(ClassConstantDeclaration declaration) throws Exception {
        ISourceElementRequestor.FieldInfo info = new ISourceElementRequestor.FieldInfo();
        info.modifiers = 140;
        ConstantReference constantName = declaration.getConstantName();
        info.name = ASTUtils.stripQuotes(constantName.getName());
        info.nameSourceEnd = constantName.sourceEnd() - 1;
        info.nameSourceStart = constantName.sourceStart();
        info.declarationStart = declaration.sourceStart();
        this.fRequestor.enterField(info);
        return true;
    }

    public boolean endvisit(ClassConstantDeclaration declaration) throws Exception {
        this.fRequestor.exitField(declaration.sourceEnd() - 1);
        return true;
    }

    public boolean visit(Assignment assignment) throws Exception {
        Expression left = assignment.getVariable();
        if (left instanceof FieldAccess) {
            Expression field;
            FieldAccess fieldAccess = (FieldAccess)left;
            Expression dispatcher = fieldAccess.getDispatcher();
            if (dispatcher instanceof VariableReference && "$this".equals(((VariableReference)dispatcher).getName()) && (field = fieldAccess.getField()) instanceof SimpleReference) {
                SimpleReference ref = (SimpleReference)field;
                ISourceElementRequestor.FieldInfo info = new ISourceElementRequestor.FieldInfo();
                info.modifiers = 128;
                info.name = String.valueOf('$') + ref.getName();
                info.nameSourceEnd = ref.sourceEnd() - 1;
                info.nameSourceStart = ref.sourceStart();
                info.declarationStart = assignment.sourceStart();
                this.fRequestor.enterField(info);
                this.fNodes.push(assignment);
            }
        } else if (left instanceof VariableReference) {
            ISourceElementRequestor.FieldInfo info = new ISourceElementRequestor.FieldInfo();
            info.modifiers = 128;
            info.name = ((VariableReference)left).getName();
            info.nameSourceEnd = left.sourceEnd() - 1;
            info.nameSourceStart = left.sourceStart();
            info.declarationStart = assignment.sourceStart();
            this.fRequestor.enterField(info);
            this.fNodes.push(assignment);
        }
        return true;
    }

    public boolean endvisit(Assignment assignment) throws Exception {
        if (!this.fNodes.isEmpty() && this.fNodes.peek() == assignment) {
            this.fRequestor.exitField(assignment.sourceEnd() - 1);
            this.fNodes.pop();
        }
        return true;
    }

    public boolean visit(TypeReference reference) throws Exception {
        this.fRequestor.acceptTypeReference(reference.getName().toCharArray(), reference.sourceStart());
        return true;
    }

    public boolean visit(Statement node) throws Exception {
        PHPSourceElementRequestorExtension[] pHPSourceElementRequestorExtensionArray = this.extensions;
        int n = this.extensions.length;
        int n2 = 0;
        while (n2 < n) {
            PHPSourceElementRequestorExtension visitor = pHPSourceElementRequestorExtensionArray[n2];
            visitor.visit(node);
            ++n2;
        }
        String clasName = node.getClass().getName();
        if (clasName.equals(PHPFieldDeclaration.class.getName())) {
            return this.visit((PHPFieldDeclaration)node);
        }
        if (clasName.equals(FieldDeclaration.class.getName())) {
            return this.visit((FieldDeclaration)node);
        }
        if (clasName.equals(ClassConstantDeclaration.class.getName())) {
            return this.visit((ClassConstantDeclaration)node);
        }
        if (clasName.equals(CatchClause.class.getName())) {
            return this.visit((CatchClause)node);
        }
        if (clasName.equals(ForEachStatement.class.getName())) {
            return this.visit((ForEachStatement)node);
        }
        return true;
    }

    public boolean endvisit(Statement node) throws Exception {
        PHPSourceElementRequestorExtension[] pHPSourceElementRequestorExtensionArray = this.extensions;
        int n = this.extensions.length;
        int n2 = 0;
        while (n2 < n) {
            PHPSourceElementRequestorExtension visitor = pHPSourceElementRequestorExtensionArray[n2];
            visitor.endvisit(node);
            ++n2;
        }
        String clasName = node.getClass().getName();
        if (clasName.equals(PHPFieldDeclaration.class.getName())) {
            return this.endvisit((PHPFieldDeclaration)node);
        }
        if (clasName.equals(FieldDeclaration.class.getName())) {
            return this.endvisit((FieldDeclaration)node);
        }
        if (clasName.equals(ClassConstantDeclaration.class.getName())) {
            return this.endvisit((ClassConstantDeclaration)node);
        }
        if (clasName.equals(CatchClause.class.getName())) {
            return this.endvisit((CatchClause)node);
        }
        if (clasName.equals(ForEachStatement.class.getName())) {
            return this.endvisit((ForEachStatement)node);
        }
        return true;
    }

    public boolean visit(Expression node) throws Exception {
        PHPSourceElementRequestorExtension[] pHPSourceElementRequestorExtensionArray = this.extensions;
        int n = this.extensions.length;
        int n2 = 0;
        while (n2 < n) {
            PHPSourceElementRequestorExtension visitor = pHPSourceElementRequestorExtensionArray[n2];
            visitor.visit(node);
            ++n2;
        }
        String clasName = node.getClass().getName();
        if (clasName.equals(Assignment.class.getName())) {
            return this.visit((Assignment)node);
        }
        if (clasName.equals(TypeReference.class.getName())) {
            return this.visit((TypeReference)node);
        }
        if (clasName.equals(Include.class.getName())) {
            return this.visit((Include)node);
        }
        if (clasName.equals(PHPCallExpression.class.getName())) {
            return this.visit((PHPCallExpression)node);
        }
        return true;
    }

    public boolean endvisit(Expression node) throws Exception {
        PHPSourceElementRequestorExtension[] pHPSourceElementRequestorExtensionArray = this.extensions;
        int n = this.extensions.length;
        int n2 = 0;
        while (n2 < n) {
            PHPSourceElementRequestorExtension visitor = pHPSourceElementRequestorExtensionArray[n2];
            visitor.endvisit(node);
            ++n2;
        }
        String clasName = node.getClass().getName();
        if (clasName.equals(Assignment.class.getName())) {
            return this.endvisit((Assignment)node);
        }
        return true;
    }

    public boolean endvisit(ModuleDeclaration declaration) throws Exception {
        while (this.deferredDeclarations != null && !this.deferredDeclarations.isEmpty()) {
            Declaration[] declarations = this.deferredDeclarations.toArray(new Declaration[this.deferredDeclarations.size()]);
            this.deferredDeclarations.clear();
            Declaration[] declarationArray = declarations;
            int n = declarations.length;
            int n2 = 0;
            while (n2 < n) {
                Declaration deferred = declarationArray[n2];
                deferred.traverse((ASTVisitor)this);
                ++n2;
            }
        }
        return super.endvisit(declaration);
    }
}

