/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.compiler.ast.parser.php5;

import java.io.InputStream;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java_cup.runtime.Symbol;
import org.eclipse.dltk.ast.references.TypeReference;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.php.internal.core.ast.nodes.IDocumentorLexer;
import org.eclipse.php.internal.core.ast.scanner.PhpAstLexer5;
import org.eclipse.php.internal.core.compiler.ast.nodes.Comment;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.internal.core.compiler.ast.nodes.VarComment;
import org.eclipse.php.internal.core.compiler.ast.parser.DocumentorLexer;

public class Php5AstLexer
extends PhpAstLexer5 {
    private static final Pattern VAR_COMMENT_PATTERN = Pattern.compile("(.*)(\\$[^\\s]+)(\\s+)([^\\s]+).*");
    private PHPDocBlock latestDocBlock;
    private VarComment latestVarComment;

    public Php5AstLexer(InputStream in) {
        super(in);
    }

    public Php5AstLexer(Reader in) {
        super(in);
    }

    protected void handleVarComment() {
        String content = this.yytext();
        Matcher m = VAR_COMMENT_PATTERN.matcher(content);
        if (m.matches()) {
            int start = this.getTokenStartPosition();
            int end = start + this.getTokenLength();
            int varStart = start + m.group(1).length();
            String varName = m.group(2);
            int varEnd = varStart + varName.length();
            int typeStart = varEnd + m.group(3).length();
            String typeName = m.group(4);
            int typeEnd = typeStart + typeName.length();
            VariableReference varReference = new VariableReference(varStart, varEnd, varName);
            TypeReference typeReference = new TypeReference(typeStart, typeEnd, typeName);
            VarComment varComment = new VarComment(start, end, varReference, typeReference);
            this.getCommentList().add(varComment);
            this.latestVarComment = varComment;
        }
    }

    protected void addComment(int type) {
        int leftPosition = this.getTokenStartPosition();
        Comment comment = new Comment(this.commentStartPosition, leftPosition + this.getTokenLength(), type);
        this.getCommentList().add(comment);
    }

    protected void addVarComment() {
    }

    protected IDocumentorLexer getDocumentorLexer(Reader reader) {
        DocumentorLexer lexer = new DocumentorLexer(reader);
        return lexer;
    }

    protected boolean parsePHPDoc() {
        boolean result = super.parsePHPDoc();
        if (result) {
            this.latestDocBlock = (PHPDocBlock)((Object)this.getCommentList().getLast());
        }
        return result;
    }

    protected Symbol createSymbol(int symbolNumber) {
        Symbol symbol = super.createSymbol(symbolNumber);
        switch (symbolNumber) {
            case 32: 
            case 33: 
            case 40: 
            case 45: 
            case 46: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: {
                symbol.value = this.latestDocBlock;
                break;
            }
            case 77: {
                symbol.value = this.latestVarComment;
                this.latestVarComment = null;
            }
        }
        this.latestDocBlock = null;
        return symbol;
    }
}

