/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.documentModel.partitioner;

import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.wst.html.core.internal.text.StructuredTextPartitionerForHTML;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

public class PHPStructuredTextPartitioner
extends StructuredTextPartitionerForHTML {
    private static final String[] configuredContentTypes = new String[]{"org.eclipse.php.PHP_DEFAULT", "org.eclipse.php.PHP_SINGLE_LINE_COMMENT", "org.eclipse.php.PHP_MULTI_LINE_COMMENT", "org.eclipse.php.PHP_DOC", "org.eclipse.php.PHP_QUOTED_STRING"};

    public String getContentType(int offset, boolean preferOpenPartitions) {
        ITypedRegion partition = this.getPartition(offset);
        return partition == null ? null : partition.getType();
    }

    public String getPartitionType(ITextRegion region, int offset) {
        if (PHPStructuredTextPartitioner.isPhpRegion(region.getType())) {
            return "org.eclipse.php.PHP_DEFAULT";
        }
        return super.getPartitionType(region, offset);
    }

    private static final boolean isPhpRegion(String regionType) {
        return regionType == "PHP_OPEN" || regionType == "PHP_CLOSE" || regionType == "PHP_CONTENT";
    }

    public static String[] getConfiguredContentTypes() {
        return configuredContentTypes;
    }

    public static boolean isPHPPartitionType(String type) {
        int i = 0;
        while (i < configuredContentTypes.length) {
            if (configuredContentTypes[i].equals(type)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public IDocumentPartitioner newInstance() {
        return new PHPStructuredTextPartitioner();
    }

    public ITypedRegion getPartition(int offset) {
        int docLength = this.fStructuredDocument.getLength();
        if (offset == docLength && offset > 0) {
            return super.getPartition(offset - 1);
        }
        return super.getPartition(offset);
    }
}

