/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.filenetwork;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.compiler.ast.nodes.Include;
import org.eclipse.php.internal.core.compiler.ast.nodes.Scalar;
import org.eclipse.php.internal.core.compiler.ast.parser.ASTUtils;
import org.eclipse.php.internal.core.filenetwork.ReferenceTree;
import org.eclipse.php.internal.core.mixin.IncludeField;
import org.eclipse.php.internal.core.mixin.PHPMixinModel;
import org.eclipse.php.internal.core.util.PHPSearchEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileNetworkUtility {
    public static ReferenceTree buildReferencingFilesTree(ISourceModule file, IProgressMonitor monitor) {
        HashSet<ISourceModule> processedFiles = new HashSet<ISourceModule>();
        processedFiles.add(file);
        ReferenceTree.Node root = new ReferenceTree.Node(file);
        FileNetworkUtility.internalBuildReferencingFilesTree(root, processedFiles, monitor);
        return new ReferenceTree(root);
    }

    private static void internalBuildReferencingFilesTree(ReferenceTree.Node root, Set<ISourceModule> processedFiles, IProgressMonitor monitor) {
        ArrayList<PHPMixinModel> mixinModelInstances;
        ISourceModule file = root.getFile();
        IScriptProject scriptProject = file.getScriptProject();
        if (scriptProject != null) {
            IProject[] referencingProjects = scriptProject.getProject().getReferencingProjects();
            mixinModelInstances = new ArrayList(referencingProjects.length + 1);
            mixinModelInstances.add(PHPMixinModel.getInstance(scriptProject));
            IProject[] iProjectArray = referencingProjects;
            int n = referencingProjects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject referencingProject = iProjectArray[n2];
                mixinModelInstances.add(PHPMixinModel.getInstance(DLTKCore.create((IProject)referencingProject)));
                ++n2;
            }
        } else {
            mixinModelInstances = new ArrayList<PHPMixinModel>(1);
            mixinModelInstances.add(PHPMixinModel.getWorkspaceInstance());
        }
        for (PHPMixinModel mixinModel : mixinModelInstances) {
            IModelElement[] includes;
            IModelElement[] iModelElementArray = includes = mixinModel.getInclude(file.getPath().lastSegment());
            int n = includes.length;
            int n3 = 0;
            while (n3 < n) {
                IModelElement e = iModelElementArray[n3];
                IncludeField include = (IncludeField)e;
                ISourceModule referencingFile = include.getSourceModule();
                ISourceModule testFile = FileNetworkUtility.findSourceModule(referencingFile, include.getFilePath());
                if (file.equals(testFile) && !processedFiles.contains(referencingFile)) {
                    processedFiles.add(referencingFile);
                    root.addChild(new ReferenceTree.Node(referencingFile));
                }
                ++n3;
            }
        }
        Collection<ReferenceTree.Node> children = root.getChildren();
        if (children != null) {
            for (ReferenceTree.Node child : children) {
                FileNetworkUtility.internalBuildReferencingFilesTree(child, processedFiles, monitor);
            }
        }
    }

    public static ReferenceTree buildReferencedFilesTree(ISourceModule file, IProgressMonitor monitor) {
        HashSet<ISourceModule> processedFiles = new HashSet<ISourceModule>();
        processedFiles.add(file);
        ReferenceTree.Node root = new ReferenceTree.Node(file);
        try {
            FileNetworkUtility.internalBuildReferencedFilesTree(root, processedFiles, monitor);
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
        return new ReferenceTree(root);
    }

    private static void internalBuildReferencedFilesTree(ReferenceTree.Node root, Set<ISourceModule> processedFiles, IProgressMonitor monitor) throws CoreException {
        ISourceModule sourceModule = root.getFile();
        final LinkedList includes = new LinkedList();
        ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
        ASTVisitor visitor = new ASTVisitor(){

            public boolean visit(Expression expr) throws ModelException {
                Expression fileExpr;
                if (expr instanceof Include && (fileExpr = ((Include)expr).getExpr()) instanceof Scalar) {
                    String fileName = ASTUtils.stripQuotes(((Scalar)fileExpr).getValue());
                    includes.add(fileName);
                }
                return true;
            }
        };
        try {
            moduleDeclaration.traverse(visitor);
        }
        catch (Exception e) {
            Logger.logException(e);
        }
        for (String filePath : includes) {
            ISourceModule testFile = FileNetworkUtility.findSourceModule(sourceModule, filePath);
            if (testFile == null || processedFiles.contains(testFile)) continue;
            processedFiles.add(testFile);
            root.addChild(new ReferenceTree.Node(testFile));
        }
        Collection<ReferenceTree.Node> children = root.getChildren();
        if (children != null) {
            for (ReferenceTree.Node child : children) {
                FileNetworkUtility.internalBuildReferencedFilesTree(child, processedFiles, monitor);
            }
        }
    }

    public static ISourceModule findSourceModule(ISourceModule from, String path) {
        ISourceModule sourceModule = null;
        IProject currentProject = from.getScriptProject().getProject();
        String currentScriptDir = from.getParent().getPath().toString();
        String currentWorkingDir = currentProject.getFullPath().toString();
        PHPSearchEngine.Result<?, ?> result = PHPSearchEngine.find(path, currentWorkingDir, currentScriptDir, currentProject);
        if (result instanceof PHPSearchEngine.ResourceResult) {
            PHPSearchEngine.ResourceResult resResult = (PHPSearchEngine.ResourceResult)result;
            IResource resource = (IResource)resResult.getFile();
            sourceModule = (ISourceModule)DLTKCore.create((IResource)resource);
        }
        return sourceModule;
    }
}

