/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.filenetwork;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.dltk.core.IFileHierarchyInfo;
import org.eclipse.dltk.core.ISourceModule;

public class ReferenceTree
implements IFileHierarchyInfo {
    private final Node root;

    public ReferenceTree(Node root) {
        assert (root != null);
        this.root = root;
    }

    public Node getRoot() {
        return this.root;
    }

    public String toString() {
        return this.root.toString();
    }

    public boolean find(ISourceModule sourceModule) {
        return this.root.find(sourceModule);
    }

    public boolean exists(ISourceModule file) {
        return this.find(file);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Node {
        private final ISourceModule file;
        private Set<Node> children;

        public Node(ISourceModule file) {
            assert (file != null);
            this.file = file;
        }

        public void addChild(Node child) {
            if (this.children == null) {
                this.children = new LinkedHashSet<Node>();
            }
            this.children.add(child);
        }

        public Collection<Node> getChildren() {
            return this.children;
        }

        public ISourceModule getFile() {
            return this.file;
        }

        public boolean find(ISourceModule sourceModule) {
            if (sourceModule == null) {
                return false;
            }
            if (this.file.equals(sourceModule)) {
                return true;
            }
            if (this.children != null) {
                for (Node child : this.children) {
                    if (!child.find(sourceModule)) continue;
                    return true;
                }
            }
            return false;
        }

        private void toString(StringBuilder buf, int tabs) {
            String fileName = this.file.getPath().toString();
            if (tabs > 0) {
                int i = 0;
                while (i < tabs) {
                    buf.append('\t');
                    ++i;
                }
                buf.append("|\n");
                i = 0;
                while (i < tabs) {
                    buf.append('\t');
                    ++i;
                }
                buf.append("+-> ");
            }
            buf.append(fileName).append('\n');
            if (this.children != null) {
                for (Node child : this.children) {
                    child.toString(buf, tabs + 1);
                }
            }
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            this.toString(buf, 0);
            return buf.toString();
        }
    }
}

