/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.filesystem;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.filesystem.provider.FileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.php.internal.core.CoreMessages;

public class ExternalFileStore
extends FileStore {
    private File file;
    private String filePath;

    protected ExternalFileStore(File file) throws IllegalArgumentException {
        if (file.exists()) {
            throw new IllegalArgumentException(CoreMessages.getString("ExternalFileStore_0"));
        }
        this.file = file;
        this.filePath = file.getPath();
    }

    public String[] childNames(int options, IProgressMonitor monitor) throws CoreException {
        return EMPTY_STRING_ARRAY;
    }

    public IFileInfo fetchInfo(int options, IProgressMonitor monitor) throws CoreException {
        FileInfo info = new FileInfo(this.file.getName());
        info.setExists(false);
        return info;
    }

    public IFileStore getChild(String name) {
        return new ExternalFileStore(new File(this.file, name));
    }

    public String getName() {
        return this.file.getName();
    }

    public IFileStore getParent() {
        File parent = this.file.getParentFile();
        return parent == null ? null : new ExternalFileStore(parent);
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public InputStream openInputStream(int options, IProgressMonitor monitor) throws CoreException {
        return new ByteArrayInputStream(new byte[0]);
    }

    public URI toURI() {
        return URIUtil.toURI((String)this.filePath);
    }

    public String toString() {
        return this.filePath;
    }
}

