/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.format;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.documentModel.DOMModelForPHP;
import org.eclipse.php.internal.core.preferences.IPreferencesPropagatorListener;
import org.eclipse.php.internal.core.preferences.PreferencePropagatorFactory;
import org.eclipse.php.internal.core.preferences.PreferencesPropagator;
import org.eclipse.php.internal.core.preferences.PreferencesPropagatorEvent;
import org.eclipse.php.internal.core.preferences.PreferencesSupport;
import org.eclipse.wst.sse.core.StructuredModelManager;

public class FormatPreferencesSupport {
    private IDocument fLastDocument = null;
    private IProject fLastProject = null;
    private char indentationChar;
    private int indentationSize;
    private PreferencesSupport preferencesSupport = null;
    private PreferencesPropagatorListener listener = null;
    private boolean preferencesChanged = false;
    private PreferencesPropagator preferencesPropagator;
    private static final String NODES_QUALIFIER = "org.eclipse.php.core";
    private static final Preferences store = PHPCorePlugin.getDefault().getPluginPreferences();
    private static FormatPreferencesSupport instance = null;

    private FormatPreferencesSupport() {
        PreferencePropagatorFactory.getInstance();
        this.preferencesPropagator = PreferencePropagatorFactory.getPreferencePropagator(NODES_QUALIFIER, store);
        this.preferencesSupport = new PreferencesSupport(NODES_QUALIFIER, store);
    }

    public static FormatPreferencesSupport getInstance() {
        if (instance == null) {
            instance = new FormatPreferencesSupport();
        }
        return instance;
    }

    public int getIndentationSize(IDocument document) {
        if (document == null) {
            String indentSize = this.preferencesSupport.getWorkspacePreferencesValue("org.eclipse.php.core.phpForamtterIndentationSize");
            if (indentSize == null) {
                return 1;
            }
            return Integer.valueOf(indentSize);
        }
        this.verifyValidity(document);
        return this.indentationSize;
    }

    public char getIndentationChar(IDocument document) {
        if (document == null) {
            String useTab = this.preferencesSupport.getWorkspacePreferencesValue("org.eclipse.php.core.phpForamtterUseTabs");
            if (useTab == null) {
                return '\t';
            }
            return Boolean.valueOf(useTab) != false ? (char)'\t' : ' ';
        }
        this.verifyValidity(document);
        return this.indentationChar;
    }

    private void verifyValidity(IDocument document) {
        if (this.fLastDocument != document) {
            DOMModelForPHP editorModel = null;
            try {
                editorModel = (DOMModelForPHP)StructuredModelManager.getModelManager().getExistingModelForRead(document);
                String baseLocation = editorModel.getBaseLocation();
                Path basePath = new Path(baseLocation);
                IFile file = null;
                if (basePath.segmentCount() > 1 && !(file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)basePath)).exists()) {
                    file = null;
                }
                if (file == null) {
                    return;
                }
                IProject project = file.getProject();
                if (this.fLastProject != project) {
                    this.fLastProject = project;
                    this.verifyListening();
                }
            }
            finally {
                if (editorModel != null) {
                    editorModel.releaseFromRead();
                }
            }
        }
        if (this.fLastDocument != document || this.preferencesChanged) {
            String useTab = this.preferencesSupport.getPreferencesValue("org.eclipse.php.core.phpForamtterUseTabs", null, this.fLastProject);
            String indentSize = this.preferencesSupport.getPreferencesValue("org.eclipse.php.core.phpForamtterIndentationSize", null, this.fLastProject);
            this.indentationChar = (char)(Boolean.valueOf(useTab) != false ? 9 : 32);
            this.indentationSize = Integer.valueOf(indentSize);
            this.preferencesChanged = false;
            this.fLastDocument = document;
        }
    }

    private void verifyListening() {
        if (this.listener != null) {
            this.preferencesPropagator.removePropagatorListener(this.listener, "org.eclipse.php.core.phpForamtterUseTabs");
            this.preferencesPropagator.removePropagatorListener(this.listener, "org.eclipse.php.core.phpForamtterIndentationSize");
        }
        this.listener = new PreferencesPropagatorListener(this.fLastProject);
        this.preferencesPropagator.addPropagatorListener(this.listener, "org.eclipse.php.core.phpForamtterUseTabs");
        this.preferencesPropagator.addPropagatorListener(this.listener, "org.eclipse.php.core.phpForamtterIndentationSize");
    }

    private class PreferencesPropagatorListener
    implements IPreferencesPropagatorListener {
        private IProject project;

        public PreferencesPropagatorListener(IProject project) {
            this.project = project;
        }

        public void preferencesEventOccured(PreferencesPropagatorEvent event) {
            FormatPreferencesSupport.this.preferencesChanged = true;
        }

        public IProject getProject() {
            return this.project;
        }
    }
}

