/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.language;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.BuildpathContainerInitializer;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IAccessRule;
import org.eclipse.dltk.core.IBuildpathAttribute;
import org.eclipse.dltk.core.IBuildpathContainer;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IBuiltinModuleProvider;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.internal.core.BuildpathEntry;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.preferences.IPreferencesPropagatorListener;
import org.eclipse.php.internal.core.preferences.PreferencesPropagatorEvent;
import org.eclipse.php.internal.core.project.properties.handlers.PhpVersionChangedHandler;
import org.eclipse.php.internal.core.project.properties.handlers.PhpVersionProjectPropertyHandler;
import org.eclipse.php.internal.core.util.project.observer.IProjectClosedObserver;
import org.eclipse.php.internal.core.util.project.observer.ProjectRemovedObserversAttacher;
import org.osgi.framework.Bundle;

public class LanguageModelInitializer
extends BuildpathContainerInitializer {
    public static final String PHP_LANGUAGE_LIBRARY = "PHP Language Library";
    public static final String CONTAINER_PATH = "org.eclipse.php.core.LANGUAGE";
    private static final String LANGUAGE_LIBRARY_PATH = "Resources/language/php%d";
    private Map<IProject, IPreferencesPropagatorListener> project2PhpVerListener = new HashMap<IProject, IPreferencesPropagatorListener>();
    private Map<IProject, String> project2PhpVersion = new HashMap<IProject, String>();

    private void initializeListener(final IPath containerPath, final IScriptProject scriptProject) {
        final IProject project = scriptProject.getProject();
        if (this.project2PhpVerListener.containsKey(project)) {
            return;
        }
        IPreferencesPropagatorListener versionChangeListener = new IPreferencesPropagatorListener(){

            public void preferencesEventOccured(PreferencesPropagatorEvent event) {
                LanguageModelInitializer.this.project2PhpVersion.put(project, (String)event.getNewValue());
                try {
                    LanguageModelInitializer.this.initialize(containerPath, scriptProject);
                }
                catch (CoreException e) {
                    Logger.logException(e);
                }
            }

            public IProject getProject() {
                return project;
            }
        };
        this.project2PhpVerListener.put(project, versionChangeListener);
        PhpVersionChangedHandler.getInstance().addPhpVersionChangedListener(versionChangeListener);
        ProjectRemovedObserversAttacher.getInstance().addProjectClosedObserver(project, new IProjectClosedObserver(){

            public void closed() {
                PhpVersionChangedHandler.getInstance().removePhpVersionChangedListener((IPreferencesPropagatorListener)LanguageModelInitializer.this.project2PhpVerListener.remove(project));
            }
        });
    }

    public void initialize(IPath containerPath, IScriptProject scriptProject) throws CoreException {
        if (containerPath.segmentCount() > 0 && containerPath.segment(0).equals(CONTAINER_PATH)) {
            try {
                if (LanguageModelInitializer.isPHPProject(scriptProject)) {
                    IProject project = scriptProject.getProject();
                    this.project2PhpVersion.put(project, PhpVersionProjectPropertyHandler.getVersion(project));
                    DLTKCore.setBuildpathContainer((IPath)containerPath, (IScriptProject[])new IScriptProject[]{scriptProject}, (IBuildpathContainer[])new IBuildpathContainer[]{new LanguageModelContainer(containerPath)}, null);
                    this.initializeListener(containerPath, scriptProject);
                }
            }
            catch (Exception e) {
                Logger.logException(e);
            }
        }
    }

    private static IPath getContainerPath(IScriptProject project, String phpVersion) throws IOException {
        String libraryPath = LanguageModelInitializer.getLanguageLibraryPath(project, phpVersion);
        URL url = FileLocator.find((Bundle)PHPCorePlugin.getDefault().getBundle(), (IPath)new Path(libraryPath), null);
        URL resolved = FileLocator.resolve((URL)url);
        IPath path = Path.fromOSString((String)resolved.getFile());
        return path;
    }

    private static String getLanguageLibraryPath(IScriptProject project, String phpVersion) {
        return String.format(LANGUAGE_LIBRARY_PATH, "php4".equals(phpVersion) ? 4 : 5);
    }

    private static boolean isPHPProject(IScriptProject project) {
        String nature = LanguageModelInitializer.getNatureFromProject(project);
        return "org.eclipse.php.core.PHPNature".equals(nature);
    }

    private static String getNatureFromProject(IScriptProject project) {
        IDLTKLanguageToolkit languageToolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)project);
        if (languageToolkit != null) {
            return languageToolkit.getNatureId();
        }
        return null;
    }

    public static boolean isLanguageModelElement(IModelElement element) {
        IScriptProject project;
        IProjectFragment fragment = (IProjectFragment)element.getAncestor(3);
        if (fragment != null && (project = element.getScriptProject()) != null) {
            String phpVersion = PhpVersionProjectPropertyHandler.getVersion(project.getProject());
            try {
                IPath containerPath = LanguageModelInitializer.getContainerPath(project, phpVersion);
                return EnvironmentPathUtils.getLocalPath((IPath)fragment.getPath()).equals((Object)containerPath);
            }
            catch (IOException e) {
                Logger.logException(e);
            }
        }
        return false;
    }

    public static void enableLanguageModelFor(IScriptProject project) throws ModelException {
        IBuildpathEntry[] rawBuildpath;
        if (!LanguageModelInitializer.isPHPProject(project)) {
            return;
        }
        Path containerPath = new Path(CONTAINER_PATH);
        boolean found = false;
        IBuildpathEntry[] iBuildpathEntryArray = rawBuildpath = project.getRawBuildpath();
        int n = rawBuildpath.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildpathEntry entry = iBuildpathEntryArray[n2];
            if (entry.isContainerEntry() && entry.getPath().equals((Object)containerPath)) {
                found = true;
                break;
            }
            ++n2;
        }
        if (!found) {
            IBuildpathEntry containerEntry = DLTKCore.newContainerEntry((IPath)containerPath);
            int newSize = rawBuildpath.length + 1;
            ArrayList<IBuildpathEntry> newRawBuildpath = new ArrayList<IBuildpathEntry>(newSize);
            newRawBuildpath.addAll((Collection)Arrays.asList(rawBuildpath));
            newRawBuildpath.add(containerEntry);
            project.setRawBuildpath(newRawBuildpath.toArray(new IBuildpathEntry[newSize]), null);
        }
    }

    class LanguageModelContainer
    implements IBuildpathContainer {
        private IPath containerPath;
        private IBuildpathEntry[] buildPathEntries;

        public LanguageModelContainer(IPath containerPath) {
            this.containerPath = containerPath;
        }

        public IBuildpathEntry[] getBuildpathEntries(IScriptProject project) {
            if (this.buildPathEntries == null) {
                IEnvironment environment = EnvironmentManager.getEnvironment((IModelElement)project);
                try {
                    IPath path = LanguageModelInitializer.getContainerPath(project, (String)LanguageModelInitializer.this.project2PhpVersion.get(project.getProject()));
                    if (environment != null) {
                        path = EnvironmentPathUtils.getFullPath((IEnvironment)environment, (IPath)path);
                    }
                    this.buildPathEntries = new IBuildpathEntry[]{DLTKCore.newLibraryEntry((IPath)path, (IAccessRule[])BuildpathEntry.NO_ACCESS_RULES, (IBuildpathAttribute[])BuildpathEntry.NO_EXTRA_ATTRIBUTES, (IPath[])BuildpathEntry.INCLUDE_ALL, (IPath[])BuildpathEntry.EXCLUDE_NONE, (boolean)false, (boolean)true)};
                }
                catch (Exception e) {
                    Logger.logException(e);
                }
            }
            return this.buildPathEntries;
        }

        public IBuiltinModuleProvider getBuiltinProvider(IScriptProject project) {
            return null;
        }

        public String getDescription(IScriptProject project) {
            return LanguageModelInitializer.PHP_LANGUAGE_LIBRARY;
        }

        public int getKind() {
            return 2;
        }

        public IPath getPath() {
            return this.containerPath;
        }
    }
}

