/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.mixin;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.CallExpression;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.mixin.IMixinRequestor;
import org.eclipse.dltk.core.mixin.MixinModel;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.compiler.ast.nodes.Assignment;
import org.eclipse.php.internal.core.compiler.ast.nodes.CatchClause;
import org.eclipse.php.internal.core.compiler.ast.nodes.ClassConstantDeclaration;
import org.eclipse.php.internal.core.compiler.ast.nodes.FieldAccess;
import org.eclipse.php.internal.core.compiler.ast.nodes.ForEachStatement;
import org.eclipse.php.internal.core.compiler.ast.nodes.FormalParameter;
import org.eclipse.php.internal.core.compiler.ast.nodes.GlobalStatement;
import org.eclipse.php.internal.core.compiler.ast.nodes.IPHPDocAwareDeclaration;
import org.eclipse.php.internal.core.compiler.ast.nodes.Include;
import org.eclipse.php.internal.core.compiler.ast.nodes.ListVariable;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPFieldDeclaration;
import org.eclipse.php.internal.core.compiler.ast.nodes.Scalar;
import org.eclipse.php.internal.core.compiler.ast.parser.ASTUtils;
import org.eclipse.php.internal.core.mixin.IncludeField;
import org.eclipse.php.internal.core.mixin.PHPDocField;
import org.eclipse.php.internal.core.mixin.PHPMixinElementInfo;
import org.eclipse.php.internal.core.mixin.PHPMixinModel;
import org.eclipse.php.internal.core.typeinference.FakeField;

public class PHPMixinBuildVisitor
extends ASTVisitor {
    private ISourceModule sourceModule;
    private boolean moduleAvailable;
    private IMixinRequestor requestor;
    private Stack<Scope> scopes = new Stack();
    private SourceModuleScope sourceModuleScope;
    private Stack<Set<String>> globalVariables = new Stack();

    public PHPMixinBuildVisitor(ModuleDeclaration module, ISourceModule sourceModule, boolean moduleAvailable, IMixinRequestor requestor) {
        this.sourceModule = sourceModule;
        this.moduleAvailable = moduleAvailable;
        this.requestor = requestor;
    }

    protected String report(String key, PHPMixinElementInfo object) {
        PHPMixinModel.clearKeysCache(key);
        IMixinRequestor.ElementInfo info = new IMixinRequestor.ElementInfo();
        info.key = key;
        info.object = object;
        if (this.requestor != null) {
            this.requestor.reportElement(info);
        }
        return key;
    }

    protected String reportVariableDeclaration(SimpleReference var) throws Exception {
        return this.reportVariableDeclaration(var, this.scopes.peek());
    }

    protected String reportVariableDeclaration(SimpleReference var, Scope scope) throws Exception {
        IModelElement element;
        Set<String> globalVars;
        if (scope == null) {
            throw new NullPointerException("Scope must not be null");
        }
        if (var instanceof VariableReference && (globalVars = this.globalVariables.peek()).contains(var.getName())) {
            scope = this.sourceModuleScope;
        }
        Object obj = null;
        String name = var.getName();
        if (this.moduleAvailable && (element = this.findModelElementFor((ASTNode)var)) instanceof IField) {
            obj = (IField)element;
        }
        if (obj == null && this.sourceModule != null) {
            obj = new FakeField((ModelElement)this.sourceModule, name, var.sourceStart(), var.sourceEnd() - var.sourceStart());
        }
        return scope.reportVariable(name, (IField)obj);
    }

    protected void reportPHPDoc(String key, PHPDocBlock phpDoc) throws ModelException {
        PHPDocField phpDocField = new PHPDocField((ModelElement)this.sourceModule, phpDoc);
        this.report(key, PHPMixinElementInfo.createPHPDoc((IField)phpDocField));
    }

    protected void reportPHPDocForConstant(String key, PHPDocBlock phpDoc) throws ModelException {
        PHPDocField phpDocField = new PHPDocField((ModelElement)this.sourceModule, phpDoc);
        this.report(key, PHPMixinElementInfo.createPHPDocForConstant((IField)phpDocField));
    }

    protected IModelElement findModelElementFor(ASTNode decl) throws ModelException {
        return this.sourceModule.getElementAt(decl.sourceStart() + 1);
    }

    public boolean visit(Statement node) throws Exception {
        if (node instanceof ClassConstantDeclaration) {
            return this.visit((ClassConstantDeclaration)node);
        }
        if (node instanceof PHPFieldDeclaration) {
            return this.visit((PHPFieldDeclaration)node);
        }
        if (node instanceof FormalParameter) {
            return this.visit((FormalParameter)node);
        }
        if (node instanceof CatchClause) {
            return this.visit((CatchClause)node);
        }
        if (node instanceof GlobalStatement) {
            return this.visit((GlobalStatement)node);
        }
        if (node instanceof ForEachStatement) {
            return this.visit((ForEachStatement)node);
        }
        return this.visitGeneral((ASTNode)node);
    }

    public boolean visit(Expression expr) throws Exception {
        if (expr instanceof CallExpression) {
            return this.visit((CallExpression)expr);
        }
        if (expr instanceof Assignment) {
            return this.visit((Assignment)expr);
        }
        if (expr instanceof ListVariable) {
            return this.visit((ListVariable)expr);
        }
        if (expr instanceof Include) {
            return this.visit((Include)expr);
        }
        return this.visitGeneral((ASTNode)expr);
    }

    public boolean visitGeneral(ASTNode node) throws Exception {
        return true;
    }

    public void endvisitGeneral(ASTNode node) throws Exception {
    }

    public boolean visit(CallExpression expr) throws Exception {
        if ("define".equalsIgnoreCase(expr.getName())) {
            ASTNode firstArg;
            Object obj = null;
            List args = expr.getArgs().getChilds();
            if (args.size() > 1 && (firstArg = (ASTNode)args.get(0)) instanceof Scalar) {
                IModelElement element;
                Scalar constant = (Scalar)firstArg;
                String name = ASTUtils.stripQuotes(constant.getValue());
                if (this.moduleAvailable && (element = this.findModelElementFor((ASTNode)constant)) instanceof IField) {
                    obj = (IField)element;
                }
                if (this.sourceModule != null) {
                    obj = new FakeField((ModelElement)this.sourceModule, name, constant.sourceStart(), constant.sourceEnd() - constant.sourceStart());
                }
                Scope scope = this.scopes.peek();
                scope.reportConstant(name, (IField)obj);
            }
        }
        return this.visitGeneral((ASTNode)expr);
    }

    public boolean visit(Assignment assignment) throws Exception {
        Expression field;
        FieldAccess fieldAccess;
        Expression dispatcher;
        Expression left = assignment.getVariable();
        if (left instanceof VariableReference) {
            this.reportVariableDeclaration((SimpleReference)((VariableReference)left));
        } else if (left instanceof FieldAccess && (dispatcher = (fieldAccess = (FieldAccess)left).getDispatcher()) instanceof VariableReference && "$this".equals(((VariableReference)dispatcher).getName()) && (field = fieldAccess.getField()) instanceof SimpleReference) {
            this.reportVariableDeclaration((SimpleReference)field);
        }
        return this.visitGeneral((ASTNode)assignment);
    }

    public boolean visit(ListVariable list) throws Exception {
        Expression[] expressionArray = list.getVariables();
        int n = expressionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Expression variable = expressionArray[n2];
            if (variable instanceof VariableReference) {
                this.reportVariableDeclaration((SimpleReference)((VariableReference)variable));
            }
            ++n2;
        }
        return this.visitGeneral((ASTNode)list);
    }

    public boolean visit(FormalParameter parameter) throws Exception {
        this.reportVariableDeclaration((SimpleReference)parameter.getParameterName());
        return this.visitGeneral((ASTNode)parameter);
    }

    public boolean visit(ClassConstantDeclaration decl) throws Exception {
        IField obj = null;
        String name = decl.getConstantName().getName();
        if (this.moduleAvailable) {
            IModelElement element = this.findModelElementFor((ASTNode)decl);
            obj = (IField)element;
        }
        Scope scope = this.scopes.peek();
        String newKey = scope.reportConstant(ASTUtils.stripQuotes(name), obj);
        PHPDocBlock doc = decl.getPHPDoc();
        if (doc != null) {
            this.reportPHPDocForConstant(newKey, doc);
        }
        return this.visitGeneral((ASTNode)decl);
    }

    public boolean visit(CatchClause clause) throws Exception {
        VariableReference variable = clause.getVariable();
        this.reportVariableDeclaration((SimpleReference)variable);
        return this.visitGeneral((ASTNode)clause);
    }

    public boolean visit(GlobalStatement statement) throws Exception {
        Expression[] expressionArray = statement.getVariables();
        int n = expressionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Expression variable = expressionArray[n2];
            if (variable instanceof VariableReference) {
                VariableReference var = (VariableReference)variable;
                Set<String> globalVars = this.globalVariables.peek();
                globalVars.add(var.getName());
            }
            ++n2;
        }
        return this.visitGeneral((ASTNode)statement);
    }

    public boolean visit(ForEachStatement statement) throws Exception {
        Expression value;
        Expression key = statement.getKey();
        if (key instanceof VariableReference) {
            this.reportVariableDeclaration((SimpleReference)((VariableReference)key));
        }
        if ((value = statement.getValue()) instanceof VariableReference) {
            this.reportVariableDeclaration((SimpleReference)((VariableReference)value));
        }
        return this.visitGeneral((ASTNode)statement);
    }

    public boolean visit(PHPFieldDeclaration decl) throws Exception {
        String newKey = this.reportVariableDeclaration(decl.getRef());
        PHPDocBlock doc = decl.getPHPDoc();
        if (doc != null) {
            this.reportPHPDoc(newKey, doc);
        }
        return this.visitGeneral((ASTNode)decl);
    }

    public boolean visit(Include include) throws Exception {
        Expression expr = include.getExpr();
        if (expr instanceof Scalar) {
            Scope scope = this.scopes.peek();
            scope.reportInclude(ASTUtils.stripQuotes(((Scalar)expr).getValue()));
        }
        return this.visitGeneral((ASTNode)include);
    }

    public boolean visit(ModuleDeclaration s) throws Exception {
        this.sourceModuleScope = new SourceModuleScope(s);
        this.scopes.push(this.sourceModuleScope);
        this.globalVariables.push(new HashSet());
        return this.visitGeneral((ASTNode)s);
    }

    public boolean endvisit(ModuleDeclaration s) throws Exception {
        this.scopes.pop();
        this.globalVariables.pop();
        this.endvisitGeneral((ASTNode)s);
        return true;
    }

    public boolean visit(MethodDeclaration decl) throws Exception {
        IPHPDocAwareDeclaration phpDocAwareDeclaration;
        PHPDocBlock doc;
        IMethod obj = null;
        String name = decl.getName();
        if (this.moduleAvailable) {
            IModelElement element = this.findModelElementFor((ASTNode)decl);
            obj = (IMethod)element;
        }
        Scope scope = this.scopes.peek();
        String method = scope.reportMethod(name, obj);
        this.scopes.push(new MethodScope((ASTNode)decl, scope, method));
        this.globalVariables.push(new HashSet());
        if (decl instanceof IPHPDocAwareDeclaration && (doc = (phpDocAwareDeclaration = (IPHPDocAwareDeclaration)decl).getPHPDoc()) != null) {
            this.reportPHPDoc(method, doc);
        }
        return this.visitGeneral((ASTNode)decl);
    }

    public boolean endvisit(MethodDeclaration decl) throws Exception {
        this.scopes.pop();
        this.globalVariables.pop();
        this.endvisitGeneral((ASTNode)decl);
        return true;
    }

    public boolean visit(TypeDeclaration decl) throws Exception {
        IPHPDocAwareDeclaration phpDocAwareDeclaration;
        PHPDocBlock doc;
        String newKey;
        IType obj = null;
        if (this.moduleAvailable) {
            IModelElement elementFor = this.findModelElementFor((ASTNode)decl);
            obj = (IType)elementFor;
        }
        String name = decl.getName();
        Scope scope = this.scopes.peek();
        if (decl.getKind() == 40) {
            newKey = scope.reportInterface(name, obj);
            newKey = newKey.replace(">", "%");
        } else {
            newKey = scope.reportType(name, obj);
        }
        this.scopes.push(new ClassScope((ASTNode)decl, newKey));
        if (decl instanceof IPHPDocAwareDeclaration && (doc = (phpDocAwareDeclaration = (IPHPDocAwareDeclaration)decl).getPHPDoc()) != null) {
            this.reportPHPDoc(newKey, doc);
        }
        return this.visitGeneral((ASTNode)decl);
    }

    public boolean endvisit(TypeDeclaration decl) throws Exception {
        this.scopes.pop();
        this.endvisitGeneral((ASTNode)decl);
        return true;
    }

    public static String restoreKeyByNode(ISourceModule sourceModule, ModuleDeclaration unit, final ASTNode node) {
        final String[] elementKey = new String[1];
        PHPMixinBuildVisitor visitor = new PHPMixinBuildVisitor(unit, sourceModule, false, null){
            private String tmpKey;

            protected String report(String key, PHPMixinElementInfo object) {
                this.tmpKey = key;
                return super.report(key, object);
            }

            public boolean visitGeneral(ASTNode n) throws Exception {
                if (elementKey[0] != null) {
                    return false;
                }
                if (node == n) {
                    elementKey[0] = this.tmpKey;
                }
                return super.visitGeneral(node);
            }
        };
        try {
            unit.traverse((ASTVisitor)visitor);
        }
        catch (Exception e) {
            Logger.logException(e);
        }
        return elementKey[0];
    }

    private class ClassScope
    extends Scope {
        private final String classKey;

        public ClassScope(ASTNode node, String classKey) {
            super(node);
            this.classKey = classKey;
        }

        public String reportMethod(String name, IMethod object) {
            return PHPMixinBuildVisitor.this.report(this.getClassKey() + MixinModel.SEPARATOR + name, PHPMixinElementInfo.createMethod(object));
        }

        public String reportType(String name, IType obj) {
            return null;
        }

        public String reportInterface(String name, IType obj) {
            return null;
        }

        public String reportVariable(String name, IField object) {
            PHPMixinElementInfo info = PHPMixinElementInfo.createVariable(object);
            return PHPMixinBuildVisitor.this.report(this.getClassKey() + MixinModel.SEPARATOR + name, info);
        }

        public String reportConstant(String name, IField object) {
            return PHPMixinBuildVisitor.this.report(this.getClassKey() + MixinModel.SEPARATOR + name + "@", PHPMixinElementInfo.createConstant(object));
        }

        public String getClassKey() {
            return this.classKey;
        }

        public String getKey() {
            return this.classKey;
        }

        public String reportInclude(String filePath) {
            return null;
        }
    }

    private class MethodScope
    extends Scope {
        private final Scope classScope;
        private final String methodKey;

        public MethodScope(ASTNode node, Scope classScope, String methodKey) {
            super(node);
            this.classScope = classScope;
            this.methodKey = methodKey;
        }

        public String reportMethod(String name, IMethod object) {
            return PHPMixinBuildVisitor.this.sourceModuleScope.reportMethod(name, object);
        }

        public String reportType(String name, IType obj) {
            return PHPMixinBuildVisitor.this.sourceModuleScope.reportType(name, obj);
        }

        public String reportInterface(String name, IType obj) {
            return PHPMixinBuildVisitor.this.sourceModuleScope.reportInterface(name, obj);
        }

        public String reportVariable(String name, IField obj) {
            PHPMixinElementInfo info = PHPMixinElementInfo.createVariable(obj);
            if (name.charAt(0) == '$') {
                return PHPMixinBuildVisitor.this.report(this.getKey() + MixinModel.SEPARATOR + name, info);
            }
            return PHPMixinBuildVisitor.this.report(this.getClassKey() + MixinModel.SEPARATOR + '$' + name, info);
        }

        public String reportConstant(String name, IField object) {
            return PHPMixinBuildVisitor.this.sourceModuleScope.reportConstant(name, object);
        }

        public String getClassKey() {
            return this.classScope.getClassKey();
        }

        public String getKey() {
            return this.methodKey;
        }

        public String reportInclude(String filePath) {
            return PHPMixinBuildVisitor.this.sourceModuleScope.reportInclude(filePath);
        }
    }

    private abstract class Scope {
        private final ASTNode node;

        public Scope(ASTNode node) {
            this.node = node;
        }

        public ASTNode getNode() {
            return this.node;
        }

        public abstract String reportMethod(String var1, IMethod var2);

        public abstract String reportVariable(String var1, IField var2);

        public abstract String reportConstant(String var1, IField var2);

        public abstract String reportType(String var1, IType var2);

        public abstract String reportInterface(String var1, IType var2);

        public abstract String reportInclude(String var1);

        public abstract String getClassKey();

        public abstract String getKey();
    }

    private class SourceModuleScope
    extends Scope {
        public SourceModuleScope(ModuleDeclaration node) {
            super((ASTNode)node);
        }

        public String getClassKey() {
            return "";
        }

        public String reportMethod(String name, IMethod object) {
            return PHPMixinBuildVisitor.this.report(MixinModel.SEPARATOR + name, PHPMixinElementInfo.createMethod(object));
        }

        public String reportType(String name, IType object) {
            return PHPMixinBuildVisitor.this.report(name + "%", PHPMixinElementInfo.createClass(object));
        }

        public String reportInterface(String name, IType object) {
            return PHPMixinBuildVisitor.this.report(name + ">", PHPMixinElementInfo.createInterface(object));
        }

        public String reportVariable(String name, IField object) {
            return PHPMixinBuildVisitor.this.report(MixinModel.SEPARATOR + name, PHPMixinElementInfo.createVariable(object));
        }

        public String reportConstant(String name, IField object) {
            return PHPMixinBuildVisitor.this.report(MixinModel.SEPARATOR + name + "@", PHPMixinElementInfo.createConstant(object));
        }

        public String getKey() {
            return "";
        }

        public String reportInclude(String filePath) {
            IncludeField object = new IncludeField((ModelElement)PHPMixinBuildVisitor.this.sourceModule, filePath);
            int i = Math.max(filePath.lastIndexOf(47), filePath.lastIndexOf(92));
            if (i >= 0) {
                filePath = filePath.substring(i + 1);
            }
            return PHPMixinBuildVisitor.this.report(filePath + "#", PHPMixinElementInfo.createInclude((IField)object));
        }
    }
}

