/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.mixin;

import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IType;

public class PHPMixinElementInfo {
    public static final int K_CLASS = 1;
    public static final int K_INTERFACE = 2;
    public static final int K_METHOD = 4;
    public static final int K_VARIABLE = 8;
    public static final int K_CONSTANT = 16;
    public static final int K_INCLUDE = 32;
    public static final int K_PHPDOC = 64;
    public static final int K_PHPDOC_FOR_CONSTANT = 128;
    public static final int K_NON_PHP = 1024;
    private int kind = 0;
    private Object object = null;

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.kind;
        result = 31 * result + (this.object == null ? 0 : this.object.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PHPMixinElementInfo other = (PHPMixinElementInfo)obj;
        if (this.kind != other.kind) {
            return false;
        }
        return !(this.object == null ? other.object != null : !this.object.equals(other.object));
    }

    public PHPMixinElementInfo(int kind, Object object) {
        this.kind = kind;
        this.object = object;
    }

    public int getKind() {
        return this.kind;
    }

    public void setKind(int kind) {
        this.kind = kind;
    }

    public Object getObject() {
        return this.object;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public static PHPMixinElementInfo createClass(IType type) {
        return new PHPMixinElementInfo(1, type);
    }

    public static PHPMixinElementInfo createInterface(IType type) {
        return new PHPMixinElementInfo(2, type);
    }

    public static PHPMixinElementInfo createMethod(IMethod m) {
        return new PHPMixinElementInfo(4, m);
    }

    public static PHPMixinElementInfo createInclude(IField includeField) {
        return new PHPMixinElementInfo(32, includeField);
    }

    public static PHPMixinElementInfo createVariable(IField type) {
        return new PHPMixinElementInfo(8, type);
    }

    public static PHPMixinElementInfo createConstant(IField type) {
        return new PHPMixinElementInfo(16, type);
    }

    public static PHPMixinElementInfo createPHPDoc(IField docField) {
        return new PHPMixinElementInfo(64, docField);
    }

    public static PHPMixinElementInfo createPHPDocForConstant(IField type) {
        return new PHPMixinElementInfo(128, type);
    }
}

