/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.mixin;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.IShutdownListener;
import org.eclipse.dltk.core.mixin.IMixinElement;
import org.eclipse.dltk.core.mixin.MixinModel;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.PHPLanguageToolkit;
import org.eclipse.php.internal.core.mixin.PHPMixinElementInfo;

public class PHPMixinModel
implements IShutdownListener {
    private static final Map<IScriptProject, PHPMixinModel> instances = new HashMap<IScriptProject, PHPMixinModel>();
    private static PHPMixinModel instance;
    private final MixinModel model;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PHPMixinModel getWorkspaceInstance() {
        Map<IScriptProject, PHPMixinModel> map = instances;
        synchronized (map) {
            if (instance == null) {
                instance = new PHPMixinModel(null);
            }
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PHPMixinModel getInstance(IScriptProject project) {
        Assert.isNotNull((Object)project);
        Map<IScriptProject, PHPMixinModel> map = instances;
        synchronized (map) {
            PHPMixinModel mixinModel = instances.get(project);
            if (mixinModel == null) {
                mixinModel = new PHPMixinModel(project);
                instances.put(project, mixinModel);
            }
            return mixinModel;
        }
    }

    public MixinModel getRawModel() {
        return this.model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearKeysCache(String key) {
        Map<IScriptProject, PHPMixinModel> map = instances;
        synchronized (map) {
            if (instance != null) {
                instance.getRawModel().clearKeysCache(key);
            }
            for (PHPMixinModel mixinModel : instances.values()) {
                mixinModel.getRawModel().clearKeysCache(key);
            }
        }
    }

    private PHPMixinModel(IScriptProject project) {
        this.model = new MixinModel(PHPLanguageToolkit.getDefault(), project);
        PHPCorePlugin.getDefault().addShutdownListener(this);
    }

    public void shutdown() {
        this.model.stop();
    }

    private IModelElement[] filterElements(IMixinElement[] elements, int kind, IDLTKSearchScope scope) {
        LinkedList<IModelElement> filtered = new LinkedList<IModelElement>();
        IMixinElement[] iMixinElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object[] objects;
            IMixinElement element = iMixinElementArray[n2];
            Object[] objectArray = objects = element.getAllObjects();
            int n3 = objects.length;
            int n4 = 0;
            while (n4 < n3) {
                PHPMixinElementInfo info;
                Object obj = objectArray[n4];
                if (obj instanceof PHPMixinElementInfo && ((info = (PHPMixinElementInfo)obj).getKind() & kind) != 0) {
                    IModelElement modelElement = (IModelElement)info.getObject();
                    if (scope == null || scope.encloses(modelElement)) {
                        filtered.add(modelElement);
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return filtered.toArray(new IModelElement[filtered.size()]);
    }

    public IModelElement[] getMethod(String className, String methodName) {
        return this.getMethod(className, methodName, null);
    }

    public IModelElement[] getMethod(String className, String methodName, IDLTKSearchScope scope) {
        if (className == null) {
            return this.getFunction(methodName, scope);
        }
        IMixinElement[] elements = this.model.find(className + "%" + MixinModel.SEPARATOR + methodName);
        return this.filterElements(elements, 4, scope);
    }

    public IModelElement[] getMethodDoc(String className, String methodName) {
        return this.getMethodDoc(className, methodName, null);
    }

    public IModelElement[] getMethodDoc(String className, String methodName, IDLTKSearchScope scope) {
        if (className == null) {
            return this.getFunctionDoc(methodName, scope);
        }
        IMixinElement[] elements = this.model.find(className + "%" + MixinModel.SEPARATOR + methodName);
        return this.filterElements(elements, 64, scope);
    }

    public IModelElement[] getFunction(String functionName) {
        return this.getFunction(functionName, null);
    }

    public IModelElement[] getFunction(String functionName, IDLTKSearchScope scope) {
        IMixinElement[] elements = this.model.find(MixinModel.SEPARATOR + functionName);
        return this.filterElements(elements, 4, scope);
    }

    public IModelElement[] getFunctionDoc(String functionName) {
        return this.getFunctionDoc(functionName, null);
    }

    public IModelElement[] getFunctionDoc(String functionName, IDLTKSearchScope scope) {
        IMixinElement[] elements = this.model.find(MixinModel.SEPARATOR + functionName);
        return this.filterElements(elements, 64, scope);
    }

    public IModelElement[] getType(String className) {
        return this.getType(className, null);
    }

    public IModelElement[] getType(String className, IDLTKSearchScope scope) {
        IMixinElement[] classes = this.model.find(className + "%");
        IMixinElement[] interfaces = this.model.find(className + ">");
        IMixinElement[] elements = new IMixinElement[classes.length + interfaces.length];
        System.arraycopy(classes, 0, elements, 0, classes.length);
        System.arraycopy(interfaces, 0, elements, classes.length, interfaces.length);
        return this.filterElements(elements, 3, scope);
    }

    public IModelElement[] getInterface(String className) {
        return this.getInterface(className, null);
    }

    public IModelElement[] getInterface(String className, IDLTKSearchScope scope) {
        IMixinElement[] elements = this.model.find(className + ">");
        return this.filterElements(elements, 2, scope);
    }

    public IModelElement[] getClass(String className) {
        return this.getClass(className, null);
    }

    public IModelElement[] getClass(String className, IDLTKSearchScope scope) {
        IMixinElement[] elements = this.model.find(className + "%");
        return this.filterElements(elements, 1, scope);
    }

    public IModelElement[] getClassDoc(String className) {
        return this.getClassDoc(className, null);
    }

    public IModelElement[] getClassDoc(String className, IDLTKSearchScope scope) {
        IMixinElement[] elements = this.model.find(className + "%");
        return this.filterElements(elements, 64, scope);
    }

    private IMixinElement[] internalGetVariable(String variableName, String methodName, String typeName) {
        StringBuilder buf = new StringBuilder();
        if (typeName != null) {
            buf.append(typeName).append("%");
        }
        if (methodName != null) {
            buf.append(MixinModel.SEPARATOR).append(methodName);
        }
        buf.append(MixinModel.SEPARATOR).append(variableName);
        return this.model.find(buf.toString());
    }

    public IModelElement[] getVariable(String variableName, String methodName, String typeName) {
        return this.getVariable(variableName, methodName, typeName, null);
    }

    public IModelElement[] getVariable(String variableName, String methodName, String typeName, IDLTKSearchScope scope) {
        return this.filterElements(this.internalGetVariable(variableName, methodName, typeName), 8, scope);
    }

    public IModelElement[] getVariableDoc(String variableName, String methodName, String typeName) {
        return this.getVariableDoc(variableName, methodName, typeName, null);
    }

    public IModelElement[] getVariableDoc(String variableName, String methodName, String typeName, IDLTKSearchScope scope) {
        return this.filterElements(this.internalGetVariable(variableName, methodName, typeName), 64, scope);
    }

    private IMixinElement[] internalGetConstant(String constantName, String typeName) {
        StringBuilder buf = new StringBuilder();
        if (typeName != null) {
            buf.append(typeName).append("%");
        }
        buf.append(MixinModel.SEPARATOR).append(constantName).append("@");
        return this.model.find(buf.toString());
    }

    public IModelElement[] getConstant(String constantName, String typeName) {
        return this.getConstant(constantName, typeName, null);
    }

    public IModelElement[] getConstant(String constantName, String typeName, IDLTKSearchScope scope) {
        return this.filterElements(this.internalGetConstant(constantName, typeName), 16, scope);
    }

    public IModelElement[] getConstantDoc(String constantName, String typeName) {
        return this.getConstantDoc(constantName, typeName, null);
    }

    public IModelElement[] getConstantDoc(String constantName, String typeName, IDLTKSearchScope scope) {
        return this.filterElements(this.internalGetConstant(constantName, typeName), 128, scope);
    }

    public IModelElement[] getInclude(String fileName) {
        return this.getInclude(fileName, null);
    }

    public IModelElement[] getInclude(String fileName, IDLTKSearchScope scope) {
        IMixinElement[] elements = this.model.find(fileName + "#");
        return this.filterElements(elements, 32, scope);
    }
}

