/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.phpModel;

import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.core.resources.IProject;
import org.eclipse.php.internal.core.project.properties.handlers.PhpVersionProjectPropertyHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PHPKeywords {
    private static final String OPEN_BLOCK_SUFFIX = " {";
    private static final String PAAMAYIM_NEKUDOTAYIM_SUFFIX = "::";
    private static final String WS_QUOTES_SEMICOLON_SUFFIX = " '';";
    private static final String EMPTY_SUFFIX = "";
    private static final String COLON_SUFFIX = ":";
    private static final String WHITESPACE_COLON_SUFFIX = " :";
    private static final String SEMICOLON_SUFFIX = ";";
    private static final String WHITESPACE_PARENTESES_SUFFIX = " ()";
    private static final String WHITESPACE_SUFFIX = " ";
    private static final String PARENTESES_SUFFIX = "()";
    private static final KeywordData[] keywordsPhp4 = new KeywordData[]{new KeywordData("and", " ", 1), new KeywordData("array", "()", 1), new KeywordData("as", " ", 1), new KeywordData("break", "", 0), new KeywordData("case", " :", 2), new KeywordData("class", " ", 1), new KeywordData("const", " ", 1, true), new KeywordData("continue", "", 0), new KeywordData("declare", "()", 1), new KeywordData("default", ":", 1), new KeywordData("die", "()", 1), new KeywordData("do", " ", 1), new KeywordData("echo", " ", 1), new KeywordData("elseif", " ()", 2), new KeywordData("else", " ", 1), new KeywordData("empty", "()", 1), new KeywordData("enddeclare", ";", 1), new KeywordData("endforeach", ";", 1), new KeywordData("endfor", ";", 1), new KeywordData("endif", ";", 1), new KeywordData("endswitch", ";", 1), new KeywordData("endwhile", ";", 1), new KeywordData("eval", "()", 1), new KeywordData("exit", "()", 1), new KeywordData("extends", " ", 1), new KeywordData("false", "", 0), new KeywordData("foreach", " ()", 2), new KeywordData("for", " ()", 2), new KeywordData("function", " ", 1, true), new KeywordData("global", " ", 1), new KeywordData("if", " ()", 2), new KeywordData("include_once", " '';", 2), new KeywordData("include", " '';", 2), new KeywordData("isset", "()", 1), new KeywordData("list", "()", 1), new KeywordData("new", " ", 1), new KeywordData("null", "", 0), new KeywordData("old_function", " ", 1), new KeywordData("or", " ", 1), new KeywordData("parent", "::", 2), new KeywordData("print", " ", 1), new KeywordData("require_once", " '';", 2), new KeywordData("require", " '';", 2), new KeywordData("return", " ", 1), new KeywordData("static", " ", 1, true), new KeywordData("switch", " ()", 2), new KeywordData("true", "", 0), new KeywordData("unset", "()", 1), new KeywordData("var", " ", 1, true), new KeywordData("while", " ()", 2), new KeywordData("xor", " ", 1)};
    private static final KeywordData[] keywordsPhp5 = new KeywordData[]{new KeywordData("abstract", " ", 1, true), new KeywordData("and", " ", 1), new KeywordData("array", "()", 1), new KeywordData("as", " ", 1), new KeywordData("break", "", 0), new KeywordData("case", " :", 2), new KeywordData("catch", " ()", 2), new KeywordData("class", " ", 1), new KeywordData("clone", " ", 1), new KeywordData("const", " ", 1, true), new KeywordData("continue", "", 0), new KeywordData("declare", "()", 1), new KeywordData("default", ":", 1), new KeywordData("die", "()", 1), new KeywordData("do", " ", 1), new KeywordData("echo", " ", 1), new KeywordData("elseif", " ()", 2), new KeywordData("else", " ", 1), new KeywordData("empty", "()", 1), new KeywordData("enddeclare", ";", 1), new KeywordData("endforeach", ";", 1), new KeywordData("endfor", ";", 1), new KeywordData("endif", ";", 1), new KeywordData("endswitch", ";", 1), new KeywordData("endwhile", ";", 1), new KeywordData("eval", "()", 1), new KeywordData("exit", "()", 1), new KeywordData("extends", " ", 1), new KeywordData("false", "", 0), new KeywordData("final", " ", 1), new KeywordData("foreach", " ()", 2), new KeywordData("for", " ()", 2), new KeywordData("function", " ", 1, true), new KeywordData("global", " ", 1), new KeywordData("if", " ()", 2), new KeywordData("implements", " ", 1), new KeywordData("include_once", " '';", 2), new KeywordData("include", " '';", 2), new KeywordData("instanceof", " ", 1), new KeywordData("interface", " ", 1), new KeywordData("isset", "()", 1), new KeywordData("list", "()", 1), new KeywordData("new", " ", 1), new KeywordData("null", "", 0), new KeywordData("or", " ", 1), new KeywordData("parent", "::", 2), new KeywordData("print", " ", 1), new KeywordData("private", " ", 1, true), new KeywordData("protected", " ", 1, true), new KeywordData("public", " ", 1, true), new KeywordData("require_once", " '';", 2), new KeywordData("require", " '';", 2), new KeywordData("return", " ", 1), new KeywordData("self", "::", 2), new KeywordData("static", " ", 1, true), new KeywordData("switch", " ()", 2), new KeywordData("throw", " ", 1), new KeywordData("true", "", 0), new KeywordData("try", " {", 2), new KeywordData("unset", "()", 1), new KeywordData("var", " ", 1, true), new KeywordData("while", " ()", 2), new KeywordData("xor", " ", 1)};

    public static KeywordData[] getKeywordDataByProject(IProject project) {
        if ("php4".equals(PhpVersionProjectPropertyHandler.getVersion(project))) {
            return keywordsPhp4;
        }
        return keywordsPhp5;
    }

    public static Collection<KeywordData> findByPrefix(IProject project, String prefix) {
        KeywordData[] keywordData = PHPKeywords.getKeywordDataByProject(project);
        LinkedList<KeywordData> result = new LinkedList<KeywordData>();
        KeywordData[] keywordDataArray = keywordData;
        int n = keywordData.length;
        int n2 = 0;
        while (n2 < n) {
            KeywordData data = keywordDataArray[n2];
            if (data.name.startsWith(prefix)) {
                result.add(data);
            }
            ++n2;
        }
        return result;
    }

    public static Collection<String> findNamesByPrefix(IProject project, String prefix) {
        KeywordData[] keywordData = PHPKeywords.getKeywordDataByProject(project);
        LinkedList<String> result = new LinkedList<String>();
        KeywordData[] keywordDataArray = keywordData;
        int n = keywordData.length;
        int n2 = 0;
        while (n2 < n) {
            KeywordData data = keywordDataArray[n2];
            if (data.name.startsWith(prefix)) {
                result.add(data.name);
            }
            ++n2;
        }
        return result;
    }

    public static class KeywordData {
        public String name;
        public String suffix;
        public int suffixOffset;
        public boolean isClassKeyword;

        public KeywordData(String name, String suffix, int suffixOffset) {
            this.name = name;
            this.suffix = suffix;
            this.suffixOffset = suffixOffset;
        }

        public KeywordData(String name, String suffix, int suffixOffset, boolean isClassKeyword) {
            this.name = name;
            this.suffix = suffix;
            this.suffixOffset = suffixOffset;
            this.isClassKeyword = isClassKeyword;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            KeywordData other = (KeywordData)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }
    }
}

