/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.phpModel;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.php.internal.core.documentModel.provisional.contenttype.ContentTypeIdForPHP;

public class PHPModelUtil {
    public static boolean isPhpElement(IModelElement modelElement) {
        Assert.isNotNull((Object)modelElement);
        IModelElement sourceModule = modelElement.getAncestor(5);
        if (sourceModule != null) {
            return PHPModelUtil.isPhpFile((ISourceModule)sourceModule);
        }
        return false;
    }

    public static boolean isPhpFile(ISourceModule sourceModule) {
        try {
            IResource resource = sourceModule.getCorrespondingResource();
            if (resource instanceof IFile) {
                IContentDescription contentDescription = ((IFile)resource).getContentDescription();
                return ContentTypeIdForPHP.ContentTypeID_PHP.equals(contentDescription.getContentType().getId());
            }
        }
        catch (CoreException coreException) {}
        return PHPModelUtil.hasPhpExtention(sourceModule.getElementName());
    }

    public static boolean isPhpFile(IFile file) {
        IContentDescription contentDescription = null;
        if (!file.exists()) {
            return PHPModelUtil.hasPhpExtention(file);
        }
        try {
            contentDescription = file.getContentDescription();
        }
        catch (CoreException coreException) {
            return PHPModelUtil.hasPhpExtention(file);
        }
        if (contentDescription == null) {
            return PHPModelUtil.hasPhpExtention(file);
        }
        return ContentTypeIdForPHP.ContentTypeID_PHP.equals(contentDescription.getContentType().getId());
    }

    public static boolean hasPhpExtention(IFile file) {
        String[] validExtensions;
        String fileName = file.getName();
        int index = fileName.lastIndexOf(46);
        if (index == -1) {
            return false;
        }
        String extension = fileName.substring(index + 1);
        IContentType type = Platform.getContentTypeManager().getContentType(ContentTypeIdForPHP.ContentTypeID_PHP);
        String[] stringArray = validExtensions = type.getFileSpecs(8);
        int n = validExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            String validExtension = stringArray[n2];
            if (extension.equalsIgnoreCase(validExtension)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean hasPhpExtention(String fileName) {
        String[] validExtensions;
        if (fileName == null) {
            throw new IllegalArgumentException();
        }
        int index = fileName.lastIndexOf(46);
        if (index == -1) {
            return false;
        }
        String extension = fileName.substring(index + 1);
        IContentType type = Platform.getContentTypeManager().getContentType(ContentTypeIdForPHP.ContentTypeID_PHP);
        String[] stringArray = validExtensions = type.getFileSpecs(8);
        int n = validExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            String validExtension = stringArray[n2];
            if (extension.equalsIgnoreCase(validExtension)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isPhpProject(IProject project) throws CoreException {
        if (project == null || !project.isAccessible()) {
            return false;
        }
        IProjectNature nature = project.getNature("org.eclipse.php.core.PHPNature");
        return nature != null;
    }
}

