/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.project.properties.handlers;

import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.preferences.IPreferencesPropagatorListener;
import org.eclipse.php.internal.core.preferences.PreferencePropagatorFactory;
import org.eclipse.php.internal.core.preferences.PreferencesPropagator;
import org.eclipse.php.internal.core.preferences.PreferencesPropagatorEvent;
import org.eclipse.php.internal.core.preferences.PreferencesSupport;

public class PhpVersionChangedHandler
implements IResourceChangeListener {
    private static final String PHP_VERSION = "phpVersion";
    private HashMap<IProject, HashSet> projectListeners = new HashMap();
    private HashMap<IProject, PreferencesPropagatorListener> preferencesPropagatorListeners = new HashMap();
    private PreferencesPropagator preferencesPropagator;
    private static final String NODES_QUALIFIER = "org.eclipse.php.core";
    private static final Preferences store = PHPCorePlugin.getDefault().getPluginPreferences();
    private static PhpVersionChangedHandler instance = new PhpVersionChangedHandler();

    private PhpVersionChangedHandler() {
        PreferencePropagatorFactory.getInstance();
        this.preferencesPropagator = PreferencePropagatorFactory.getPreferencePropagator(NODES_QUALIFIER, store);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public static PhpVersionChangedHandler getInstance() {
        return instance;
    }

    private void projectVersionChanged(IProject project, PreferencesPropagatorEvent event) {
        HashSet listeners = this.projectListeners.get(project);
        if (listeners != null) {
            for (IPreferencesPropagatorListener listener : listeners) {
                listener.preferencesEventOccured(event);
            }
        }
    }

    public void addPhpVersionChangedListener(IPreferencesPropagatorListener listener) {
        IProject project = listener.getProject();
        HashSet listeners = this.projectListeners.get(project);
        if (listeners == null) {
            this.projectAdded(project);
            listeners = this.projectListeners.get(project);
        }
        listeners.add(listener);
    }

    public void removePhpVersionChangedListener(IPreferencesPropagatorListener listener) {
        if (listener == null) {
            return;
        }
        IProject project = listener.getProject();
        HashSet listeners = this.projectListeners.get(project);
        if (listeners != null) {
            listeners.remove(listener);
        }
    }

    public void projectAdded(IProject project) {
        if (project == null || this.projectListeners.get(project) != null) {
            return;
        }
        this.projectListeners.put(project, new HashSet());
        PreferencesPropagatorListener listener = new PreferencesPropagatorListener(project);
        this.preferencesPropagatorListeners.put(project, listener);
        this.preferencesPropagator.addPropagatorListener(listener, PHP_VERSION);
    }

    public void projectRemoved(IProject project) {
        PreferencesPropagatorListener listener = this.preferencesPropagatorListeners.get(project);
        if (listener == null) {
            return;
        }
        this.preferencesPropagator.removePropagatorListener(listener, PHP_VERSION);
        this.preferencesPropagatorListeners.remove(project);
        this.projectListeners.remove(project);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta[] affectedChildren;
        IResourceDelta resourceDelta = event.getDelta();
        if (resourceDelta != null && (affectedChildren = resourceDelta.getAffectedChildren(4)).length > 0) {
            int i = 0;
            while (i < affectedChildren.length) {
                resourceDelta = affectedChildren[i];
                IResource resource = resourceDelta.getResource();
                if (resource instanceof IProject) {
                    IProject project = (IProject)resource;
                    int eventFlags = resourceDelta.getFlags();
                    if ((eventFlags & 0x4000) != 0) {
                        if (project.isOpen()) {
                            this.projectAdded(project);
                        } else {
                            this.projectRemoved(project);
                        }
                    }
                }
                ++i;
            }
        }
    }

    private class PreferencesPropagatorListener
    implements IPreferencesPropagatorListener {
        private IProject project;

        public PreferencesPropagatorListener(IProject project) {
            this.project = project;
        }

        public void preferencesEventOccured(PreferencesPropagatorEvent event) {
            String preferencesValue;
            if (event.getNewValue() == null) {
                String newValue = PreferencesSupport.getWorkspacePreferencesValue((String)event.getKey(), store);
                if (newValue == null || newValue.equals(event.getOldValue())) {
                    return;
                }
                event = new PreferencesPropagatorEvent(event.getSource(), event.getOldValue(), newValue, event.getKey());
            } else if (event.getOldValue() == null && (preferencesValue = PreferencesSupport.getWorkspacePreferencesValue((String)event.getKey(), store)) != null && preferencesValue.equals(event.getNewValue())) {
                return;
            }
            PhpVersionChangedHandler.this.projectVersionChanged(this.project, event);
        }

        public IProject getProject() {
            return this.project;
        }
    }
}

