/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.search;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.FieldDeclaration;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.CallExpression;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.compiler.util.HashtableOfIntValues;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchMatch;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.SearchRequestor;
import org.eclipse.dltk.core.search.matching.MatchLocator;
import org.eclipse.dltk.internal.core.search.matching.MatchingNodeSet;
import org.eclipse.php.internal.core.compiler.ast.parser.ASTUtils;

public class PHPMatchLocator
extends MatchLocator {
    public PHPMatchLocator(SearchPattern pattern, SearchRequestor requestor, IDLTKSearchScope scope, IProgressMonitor progressMonitor) {
        super(pattern, requestor, scope, progressMonitor);
    }

    protected void reportMatching(ModuleDeclaration module, MethodDeclaration method, IModelElement parent, int accuracy, MatchingNodeSet nodeSet) throws CoreException {
        IModelElement enclosingElement;
        block15: {
            if (parent == null) {
                parent = this.createSourceModuleHandle();
            }
            if ((enclosingElement = this.createHandle(method, parent)) == null) {
                enclosingElement = this.createMethodHandle(method.getName());
            }
            if (accuracy > -1 && enclosingElement != null && this.encloses(enclosingElement)) {
                SearchMatch match = null;
                if (DLTKCore.DEBUG) {
                    System.out.println("TODO: AST Add constructor support.");
                }
                if ((match = this.patternLocator.newDeclarationMatch((ASTNode)method, enclosingElement, accuracy, (MatchLocator)this)) != null) {
                    this.report(match);
                }
            }
            LocalDeclarationVisitor localDeclarationVisitor = new LocalDeclarationVisitor(enclosingElement, nodeSet);
            try {
                method.getBody().traverse((ASTVisitor)localDeclarationVisitor);
            }
            catch (Exception e) {
                if (!DLTKCore.DEBUG) break block15;
                e.printStackTrace();
            }
        }
        ASTNode[] nodes = nodeSet.matchingNodes(method.sourceStart(), method.sourceEnd());
        if (nodes != null) {
            if (parent == null) {
                parent = this.createSourceModuleHandle();
            }
            if ((this.matchContainer & 4) != 0) {
                if (enclosingElement == null) {
                    enclosingElement = this.createHandle(method, parent);
                }
                if (this.encloses(enclosingElement)) {
                    int i = 0;
                    int l = nodes.length;
                    while (i < l) {
                        ASTNode node = nodes[i];
                        Integer level = (Integer)nodeSet.matchingNodes.removeKey((Object)node);
                        if (DLTKCore.DEBUG) {
                            System.out.println("TODO: Searching. Add scope support.");
                        }
                        this.patternLocator.matchReportReference(node, enclosingElement, null, level.intValue(), (MatchLocator)this);
                        ++i;
                    }
                    return;
                }
            }
            int i = 0;
            int l = nodes.length;
            while (i < l) {
                nodeSet.matchingNodes.removeKey((Object)nodes[i]);
                ++i;
            }
        }
    }

    protected void reportMatching(TypeDeclaration type, MethodDeclaration method, IModelElement parent, int accuracy, boolean typeInHierarchy, MatchingNodeSet nodeSet) throws CoreException {
        ASTNode[] nodes;
        IModelElement enclosingElement;
        block12: {
            enclosingElement = this.createHandle(method, parent);
            if (accuracy > -1 && enclosingElement != null && this.encloses(enclosingElement)) {
                SearchMatch match = null;
                if (DLTKCore.DEBUG) {
                    System.out.println("TODO: AST Add constructor support.");
                }
                if ((match = this.patternLocator.newDeclarationMatch((ASTNode)method, enclosingElement, accuracy, (MatchLocator)this)) != null) {
                    this.report(match);
                }
            }
            LocalDeclarationVisitor localDeclarationVisitor = new LocalDeclarationVisitor(enclosingElement, nodeSet);
            try {
                method.getBody().traverse((ASTVisitor)localDeclarationVisitor);
            }
            catch (Exception e) {
                if (!DLTKCore.DEBUG) break block12;
                e.printStackTrace();
            }
        }
        if (typeInHierarchy && (nodes = nodeSet.matchingNodes(method.sourceStart(), method.sourceEnd())) != null) {
            if ((this.matchContainer & 2) != 0) {
                if (enclosingElement == null) {
                    enclosingElement = this.createHandle(method, parent);
                }
                if (this.encloses(enclosingElement)) {
                    int i = 0;
                    int l = nodes.length;
                    while (i < l) {
                        ASTNode node = nodes[i];
                        Integer level = (Integer)nodeSet.matchingNodes.removeKey((Object)node);
                        if (DLTKCore.DEBUG) {
                            System.out.println("TODO: Searching. Add scope support.");
                        }
                        this.patternLocator.matchReportReference(node, enclosingElement, null, level.intValue(), (MatchLocator)this);
                        ++i;
                    }
                    return;
                }
            }
            int i = 0;
            int l = nodes.length;
            while (i < l) {
                nodeSet.matchingNodes.removeKey((Object)nodes[i]);
                ++i;
            }
        }
    }

    protected void reportMatching(TypeDeclaration type, IModelElement parent, int accuracy, MatchingNodeSet nodeSet, int occurrenceCount) throws CoreException {
        if (parent != null && parent.getElementType() == 9) {
            parent = null;
        }
        super.reportMatching(type, parent, accuracy, nodeSet, occurrenceCount);
    }

    public class LocalDeclarationVisitor
    extends ASTVisitor {
        IModelElement parent;
        MatchingNodeSet nodeSet;
        HashtableOfIntValues occurrencesCounts = new HashtableOfIntValues();

        public LocalDeclarationVisitor(IModelElement parent, MatchingNodeSet nodeSet) {
            this.parent = parent;
            this.nodeSet = nodeSet;
        }

        public boolean visit(Expression expression) {
            if (expression instanceof CallExpression) {
                try {
                    FieldDeclaration constantDecl = ASTUtils.getConstantDeclaration((CallExpression)expression);
                    if (constantDecl != null) {
                        Integer level = (Integer)this.nodeSet.matchingNodes.removeKey((Object)constantDecl);
                        PHPMatchLocator.this.reportMatching(null, constantDecl, this.parent, level != null ? level : -1, this.nodeSet);
                        return false;
                    }
                }
                catch (CoreException e) {
                    throw new MatchLocator.WrappedCoreException(e);
                }
            }
            return true;
        }

        public boolean visit(TypeDeclaration typeDeclaration) {
            try {
                char[] simpleName = typeDeclaration.getName().toCharArray();
                int occurrenceCount = this.occurrencesCounts.get(simpleName);
                occurrenceCount = occurrenceCount == Integer.MIN_VALUE ? 1 : ++occurrenceCount;
                this.occurrencesCounts.put(simpleName, occurrenceCount);
                Integer level = (Integer)this.nodeSet.matchingNodes.removeKey((Object)typeDeclaration);
                PHPMatchLocator.this.reportMatching(typeDeclaration, this.parent, level != null ? level : -1, this.nodeSet, occurrenceCount);
                return false;
            }
            catch (CoreException e) {
                throw new MatchLocator.WrappedCoreException(e);
            }
        }

        public boolean visit(MethodDeclaration method) {
            try {
                Integer level = (Integer)this.nodeSet.matchingNodes.removeKey((Object)method);
                PHPMatchLocator.this.reportMatching(null, method, this.parent, level != null ? level : -1, this.nodeSet);
                return false;
            }
            catch (CoreException e) {
                throw new MatchLocator.WrappedCoreException(e);
            }
        }
    }
}

