/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.search;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.Argument;
import org.eclipse.dltk.ast.declarations.FieldDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.expressions.CallArgumentsList;
import org.eclipse.dltk.ast.expressions.CallExpression;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.ConstantReference;
import org.eclipse.dltk.ast.references.Reference;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.references.TypeReference;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.core.search.matching.MatchLocator;
import org.eclipse.dltk.core.search.matching.MatchLocatorParser;
import org.eclipse.dltk.core.search.matching.PatternLocator;
import org.eclipse.php.internal.core.compiler.ast.nodes.Assignment;
import org.eclipse.php.internal.core.compiler.ast.nodes.CatchClause;
import org.eclipse.php.internal.core.compiler.ast.nodes.ClassConstantDeclaration;
import org.eclipse.php.internal.core.compiler.ast.nodes.FieldAccess;
import org.eclipse.php.internal.core.compiler.ast.nodes.ForEachStatement;
import org.eclipse.php.internal.core.compiler.ast.nodes.Include;
import org.eclipse.php.internal.core.compiler.ast.nodes.Scalar;
import org.eclipse.php.internal.core.compiler.ast.parser.ASTUtils;

public class PHPMatchLocatorParser
extends MatchLocatorParser {
    public PHPMatchLocatorParser(MatchLocator locator) {
        super(locator);
    }

    protected void processStatement(ASTNode node, PatternLocator locator) {
        if (node instanceof FieldDeclaration) {
            locator.match((FieldDeclaration)node, this.getNodeSet());
        } else if (node instanceof ClassConstantDeclaration) {
            ClassConstantDeclaration constDecl = (ClassConstantDeclaration)node;
            ConstantReference constantName = constDecl.getConstantName();
            FieldDeclaration decl = new FieldDeclaration(constantName.getName(), constantName.sourceStart(), constantName.sourceEnd(), constDecl.sourceStart(), constDecl.sourceEnd());
            decl.setModifiers(4);
            locator.match(decl, this.getNodeSet());
        } else if (node instanceof Assignment) {
            Expression left = ((Assignment)node).getVariable();
            if (left instanceof FieldAccess) {
                Expression field;
                FieldAccess fieldAccess = (FieldAccess)left;
                Expression dispatcher = fieldAccess.getDispatcher();
                if (dispatcher instanceof VariableReference && "$this".equals(((VariableReference)dispatcher).getName()) && (field = fieldAccess.getField()) instanceof SimpleReference) {
                    SimpleReference ref = (SimpleReference)field;
                    FieldDeclaration decl = new FieldDeclaration(String.valueOf('$') + ref.getName(), ref.sourceStart(), ref.sourceEnd(), node.sourceStart(), node.sourceEnd());
                    locator.match(decl, this.getNodeSet());
                }
            } else if (left instanceof VariableReference) {
                FieldDeclaration decl = new FieldDeclaration(((VariableReference)left).getName(), left.sourceStart(), left.sourceEnd(), node.sourceStart(), node.sourceEnd());
                locator.match(decl, this.getNodeSet());
            }
        } else if (node instanceof TypeReference) {
            locator.match((TypeReference)node, this.getNodeSet());
        } else if (node instanceof VariableReference) {
            locator.match((Reference)((VariableReference)node), this.getNodeSet());
        } else if (node instanceof CallExpression) {
            FieldDeclaration constantDecl = ASTUtils.getConstantDeclaration((CallExpression)node);
            if (constantDecl != null) {
                locator.match(constantDecl, this.getNodeSet());
            } else {
                locator.match((CallExpression)node, this.getNodeSet());
            }
        } else if (node instanceof Include) {
            Include include = (Include)node;
            if (include.getExpr() instanceof Scalar) {
                Scalar filePath = (Scalar)include.getExpr();
                CallExpression callExpression = new CallExpression(filePath.sourceStart(), filePath.sourceEnd(), null, "include", new CallArgumentsList());
                locator.match(callExpression, this.getNodeSet());
            }
        } else if (node instanceof Argument) {
            SimpleReference ref = ((Argument)node).getRef();
            FieldDeclaration decl = new FieldDeclaration(ref.getName(), ref.sourceStart(), ref.sourceEnd(), node.sourceStart(), node.sourceEnd());
            locator.match(decl, this.getNodeSet());
        } else if (node instanceof ForEachStatement) {
            FieldDeclaration decl;
            SimpleReference ref;
            Expression key = ((ForEachStatement)node).getKey();
            Expression value = ((ForEachStatement)node).getValue();
            if (key instanceof SimpleReference) {
                ref = (SimpleReference)key;
                decl = new FieldDeclaration(ref.getName(), ref.sourceStart(), ref.sourceEnd(), node.sourceStart(), node.sourceEnd());
                locator.match(decl, this.getNodeSet());
            }
            if (value instanceof SimpleReference) {
                ref = (SimpleReference)value;
                decl = new FieldDeclaration(ref.getName(), ref.sourceStart(), ref.sourceEnd(), node.sourceStart(), node.sourceEnd());
                locator.match(decl, this.getNodeSet());
            }
        } else if (node instanceof CatchClause) {
            VariableReference ref = ((CatchClause)node).getVariable();
            FieldDeclaration decl = new FieldDeclaration(ref.getName(), ref.sourceStart(), ref.sourceEnd(), node.sourceStart(), node.sourceEnd());
            locator.match(decl, this.getNodeSet());
        }
    }

    public void parseBodies(ModuleDeclaration unit) {
        unit.rebuild();
        super.parseBodies(unit);
    }
}

