/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.Argument;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.evaluation.types.UnknownType;
import org.eclipse.dltk.internal.core.SourceRefElement;
import org.eclipse.dltk.ti.BasicContext;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.ISourceModuleContext;
import org.eclipse.dltk.ti.InstanceContext;
import org.eclipse.dltk.ti.goals.AbstractTypeGoal;
import org.eclipse.dltk.ti.goals.ExpressionTypeGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.internal.core.typeinference.MethodContext;
import org.eclipse.php.internal.core.typeinference.PHPClassType;
import org.eclipse.php.internal.core.typeinference.PHPTypeInferenceUtils;
import org.eclipse.php.internal.core.typeinference.PHPTypeInferencer;

public class BindingUtility {
    private static final int TIME_LIMIT = 500;
    private ISourceModule sourceModule;
    private ASTNode rootNode;
    private Map<SourceRange, IEvaluatedType> evaluatedTypesCache = new HashMap<SourceRange, IEvaluatedType>();
    private int timeLimit = 500;

    public BindingUtility(ISourceModule sourceModule) {
        this.sourceModule = sourceModule;
        this.rootNode = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
    }

    public BindingUtility(ISourceModule sourceModule, ASTNode rootNode) {
        this.sourceModule = sourceModule;
        this.rootNode = rootNode;
    }

    public void setTimeLimit(int timeLimit) {
        this.timeLimit = timeLimit;
    }

    public IEvaluatedType getType(ASTNode node) throws ModelException {
        if (node == null) {
            throw new NullPointerException();
        }
        return this.getType(new SourceRange(node));
    }

    public IEvaluatedType getType(SourceRefElement element) throws ModelException {
        if (element == null) {
            throw new NullPointerException();
        }
        ISourceModule elementModule = element.getSourceModule();
        if (!elementModule.equals(this.sourceModule)) {
            throw new IllegalArgumentException("Unknown model element");
        }
        return this.getType(new SourceRange(element.getSourceRange()));
    }

    public IEvaluatedType getType(int startOffset, int length) throws ModelException {
        return this.getType(new SourceRange(startOffset, length));
    }

    protected IEvaluatedType getType(SourceRange sourceRange, IContext context, ASTNode node) {
        PHPTypeInferencer typeInferencer = new PHPTypeInferencer();
        return typeInferencer.evaluateType((AbstractTypeGoal)new ExpressionTypeGoal(context, node), this.timeLimit);
    }

    protected ContextFinder getContext(SourceRange sourceRange) throws ModelException {
        ContextFinder contextFinder = new ContextFinder(sourceRange);
        try {
            this.rootNode.traverse((ASTVisitor)contextFinder);
        }
        catch (Exception e) {
            throw new ModelException((Throwable)e, 4);
        }
        if (contextFinder.getNode() == null) {
            throw new ModelException((Throwable)new IllegalArgumentException("AST node can not be found for the given source range: " + sourceRange), 4);
        }
        return contextFinder;
    }

    protected IEvaluatedType getType(SourceRange sourceRange) throws ModelException {
        if (!this.evaluatedTypesCache.containsKey(sourceRange)) {
            ContextFinder contextFinder = this.getContext(sourceRange);
            this.evaluatedTypesCache.put(sourceRange, this.getType(sourceRange, contextFinder.getContext(), contextFinder.getNode()));
        }
        return this.evaluatedTypesCache.get(sourceRange);
    }

    public IModelElement[] getModelElement(ASTNode node) throws ModelException {
        if (node == null) {
            throw new NullPointerException();
        }
        return this.getModelElement(new SourceRange(node), true);
    }

    public IModelElement[] getModelElement(SourceRefElement element) throws ModelException {
        if (element == null) {
            throw new NullPointerException();
        }
        ISourceModule elementModule = element.getSourceModule();
        if (!elementModule.equals(this.sourceModule)) {
            throw new IllegalArgumentException("Unknown model element");
        }
        return this.getModelElement(new SourceRange(element.getSourceRange()), true);
    }

    public IModelElement[] getModelElement(int startOffset, int length) throws ModelException {
        return this.getModelElement(startOffset, length, true);
    }

    public IModelElement[] getModelElement(int startOffset, int length, boolean filter) throws ModelException {
        return this.getModelElement(new SourceRange(startOffset, length), filter);
    }

    protected IModelElement[] getModelElement(SourceRange sourceRange, boolean filter) throws ModelException {
        ContextFinder contextFinder = this.getContext(sourceRange);
        if (!this.evaluatedTypesCache.containsKey(sourceRange)) {
            this.evaluatedTypesCache.put(sourceRange, this.getType(sourceRange, contextFinder.getContext(), contextFinder.getNode()));
        }
        IEvaluatedType evaluatedType = this.evaluatedTypesCache.get(sourceRange);
        return PHPTypeInferenceUtils.getModelElements(evaluatedType, (ISourceModuleContext)contextFinder.getContext());
    }

    private class ContextFinder
    extends ASTVisitor {
        private SourceRange sourceRange;
        private IContext context;
        private ASTNode node;
        private Stack<IContext> contextStack = new Stack();

        public ContextFinder(SourceRange sourceRange) {
            this.sourceRange = sourceRange;
        }

        public IContext getContext() {
            return this.context;
        }

        public ASTNode getNode() {
            return this.node;
        }

        public boolean visitGeneral(ASTNode node) throws Exception {
            if (node.sourceStart() > this.sourceRange.getEnd()) {
                return false;
            }
            if (node.sourceStart() <= this.sourceRange.offset && node.sourceEnd() >= this.sourceRange.getEnd() && !this.contextStack.isEmpty()) {
                this.context = this.contextStack.peek();
                this.node = node;
            }
            return true;
        }

        public boolean visit(ModuleDeclaration node) throws Exception {
            this.contextStack.push((IContext)new BasicContext(BindingUtility.this.sourceModule, node));
            return this.visitGeneral((ASTNode)node);
        }

        public boolean visit(TypeDeclaration node) throws Exception {
            this.contextStack.push((IContext)new InstanceContext((ISourceModuleContext)this.contextStack.peek(), (IEvaluatedType)new PHPClassType(node.getName())));
            return this.visitGeneral((ASTNode)node);
        }

        public boolean visit(MethodDeclaration node) throws Exception {
            LinkedList<String> argumentsList = new LinkedList<String>();
            LinkedList<IEvaluatedType> argTypes = new LinkedList<IEvaluatedType>();
            List args = node.getArguments();
            for (Argument a : args) {
                argumentsList.add(a.getName());
                argTypes.add(UnknownType.INSTANCE);
            }
            IContext parent = this.contextStack.peek();
            ModuleDeclaration rootNode = ((ISourceModuleContext)parent).getRootNode();
            this.contextStack.push(new MethodContext(parent, BindingUtility.this.sourceModule, rootNode, node, argumentsList.toArray(new String[argumentsList.size()]), argTypes.toArray(new IEvaluatedType[argTypes.size()])));
            return this.visitGeneral((ASTNode)node);
        }

        public boolean endvisit(ModuleDeclaration node) throws Exception {
            this.contextStack.pop();
            this.endvisitGeneral((ASTNode)node);
            return true;
        }

        public boolean endvisit(TypeDeclaration node) throws Exception {
            this.contextStack.pop();
            this.endvisitGeneral((ASTNode)node);
            return true;
        }

        public boolean endvisit(MethodDeclaration node) throws Exception {
            this.contextStack.pop();
            this.endvisitGeneral((ASTNode)node);
            return true;
        }
    }

    private class SourceRange {
        private final int offset;
        private final int length;

        public SourceRange(ISourceRange sourceRange) {
            this.offset = sourceRange.getOffset();
            this.length = sourceRange.getLength();
        }

        public SourceRange(int offset, int length) {
            this.length = length;
            this.offset = offset;
        }

        public SourceRange(ASTNode node) {
            this(node.sourceStart(), node.sourceEnd() - node.sourceStart());
        }

        public int getEnd() {
            return this.length + this.offset;
        }

        public int getLength() {
            return this.length;
        }

        public int getOffset() {
            return this.offset;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.length;
            result = 31 * result + this.offset;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SourceRange other = (SourceRange)obj;
            if (this.length != other.length) {
                return false;
            }
            return this.offset == other.offset;
        }

        public String toString() {
            return "<offset=" + this.offset + ", length=" + this.length + ">";
        }
    }
}

