/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference;

import java.util.LinkedList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.mixin.IMixinElement;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.core.search.SearchMatch;
import org.eclipse.dltk.core.search.SearchParticipant;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.SearchRequestor;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.php.internal.core.PHPLanguageToolkit;
import org.eclipse.php.internal.core.filenetwork.FileNetworkUtility;
import org.eclipse.php.internal.core.filenetwork.ReferenceTree;
import org.eclipse.php.internal.core.language.LanguageModelInitializer;
import org.eclipse.php.internal.core.mixin.PHPDocField;
import org.eclipse.php.internal.core.mixin.PHPMixinBuildVisitor;
import org.eclipse.php.internal.core.mixin.PHPMixinElementInfo;
import org.eclipse.php.internal.core.mixin.PHPMixinModel;
import org.eclipse.php.internal.core.typeinference.DeclarationSearcher;

public class PHPModelUtils {
    public static IModelElement getModelElementByNode(ISourceModule sourceModule, ModuleDeclaration unit, ASTNode node) {
        IMixinElement[] elements;
        Assert.isNotNull((Object)node);
        String key = PHPMixinBuildVisitor.restoreKeyByNode(sourceModule, unit, node);
        if (key != null && (elements = PHPMixinModel.getInstance(sourceModule.getScriptProject()).getRawModel().find(key)).length > 0) {
            Object[] allObjects;
            Object[] objectArray = allObjects = elements[0].getAllObjects();
            int n = allObjects.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                IModelElement element = (IModelElement)((PHPMixinElementInfo)obj).getObject();
                if (!(element instanceof PHPDocField)) {
                    return element;
                }
                ++n2;
            }
        }
        return null;
    }

    public static IMethod[] getClassMethod(IType type, String name, IProgressMonitor monitor) throws CoreException {
        if (name == null) {
            throw new NullPointerException();
        }
        IDLTKSearchScope scope = SearchEngine.createSuperHierarchyScope((IType)type);
        SearchPattern pattern = SearchPattern.createPattern((String)name, (int)1, (int)0, (int)0, (IDLTKLanguageToolkit)PHPLanguageToolkit.getDefault());
        final LinkedList methods = new LinkedList();
        new SearchEngine().search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                methods.add((IMethod)match.getElement());
            }
        }, monitor);
        return methods.toArray(new IMethod[methods.size()]);
    }

    public static PHPDocField[] getClassMethodDoc(IType type, String name, IProgressMonitor monitor) throws CoreException {
        if (name == null) {
            throw new NullPointerException();
        }
        IDLTKSearchScope scope = SearchEngine.createSuperHierarchyScope((IType)type);
        SearchPattern pattern = SearchPattern.createPattern((String)name, (int)1, (int)0, (int)0, (IDLTKLanguageToolkit)PHPLanguageToolkit.getDefault());
        final LinkedList docs = new LinkedList();
        new SearchEngine().search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                IModelElement[] methodDoc;
                IMethod method = (IMethod)match.getElement();
                IScriptProject scriptProject = method.getScriptProject();
                IModelElement[] iModelElementArray = methodDoc = PHPMixinModel.getInstance(scriptProject).getMethodDoc(method.getDeclaringType().getElementName(), method.getElementName(), SearchEngine.createSearchScope((IModelElement)scriptProject));
                int n = methodDoc.length;
                int n2 = 0;
                while (n2 < n) {
                    IModelElement doc = iModelElementArray[n2];
                    docs.add((PHPDocField)doc);
                    ++n2;
                }
            }
        }, monitor);
        return docs.toArray(new PHPDocField[docs.size()]);
    }

    public static MethodDeclaration getNodeByMethod(ModuleDeclaration rootNode, IMethod method) throws ModelException {
        DeclarationSearcher visitor;
        block2: {
            visitor = new DeclarationSearcher(rootNode, (IMember)method, DeclarationSearcher.DeclarationType.METHOD);
            try {
                rootNode.traverse((ASTVisitor)visitor);
            }
            catch (Exception e) {
                if (!DLTKCore.DEBUG) break block2;
                e.printStackTrace();
            }
        }
        return (MethodDeclaration)visitor.getResult();
    }

    public static TypeDeclaration getNodeByClass(ModuleDeclaration rootNode, IType type) throws ModelException {
        DeclarationSearcher visitor;
        block2: {
            visitor = new DeclarationSearcher(rootNode, (IMember)type, DeclarationSearcher.DeclarationType.CLASS);
            try {
                rootNode.traverse((ASTVisitor)visitor);
            }
            catch (Exception e) {
                if (!DLTKCore.DEBUG) break block2;
                e.printStackTrace();
            }
        }
        return (TypeDeclaration)visitor.getResult();
    }

    public static ASTNode getNodeByField(ModuleDeclaration rootNode, IField field) throws ModelException {
        DeclarationSearcher visitor;
        block2: {
            visitor = new DeclarationSearcher(rootNode, (IMember)field, DeclarationSearcher.DeclarationType.FIELD);
            try {
                rootNode.traverse((ASTVisitor)visitor);
            }
            catch (Exception e) {
                if (!DLTKCore.DEBUG) break block2;
                e.printStackTrace();
            }
        }
        return visitor.getResult();
    }

    public static IDLTKSearchScope createProjectSearchScope(IScriptProject project) {
        int includeMask = 15;
        return SearchEngine.createSearchScope((IModelElement)project, (int)includeMask);
    }

    public static IModelElement[] filterElements(ISourceModule sourceModule, IModelElement[] elements) {
        if (elements == null) {
            return null;
        }
        int elementType = 0;
        String elementName = null;
        boolean fileNetworkFilter = true;
        IModelElement[] iModelElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IModelElement element = iModelElementArray[n2];
            if (elementName == null) {
                elementType = element.getElementType();
                elementName = element.getElementName();
            } else if (!elementName.equals(element.getElementName()) || elementType != element.getElementType()) {
                fileNetworkFilter = false;
                break;
            }
            ++n2;
        }
        if (fileNetworkFilter) {
            return PHPModelUtils.fileNetworkFilter(sourceModule, elements);
        }
        return elements;
    }

    private static IModelElement[] fileNetworkFilter(ISourceModule sourceModule, IModelElement[] elements) {
        if (elements != null && elements.length > 0) {
            LinkedList<IModelElement> filteredElements = new LinkedList<IModelElement>();
            IModelElement[] iModelElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IModelElement element = iModelElementArray[n2];
                if (sourceModule.equals(element.getOpenable())) {
                    filteredElements.add(element);
                }
                ++n2;
            }
            if (filteredElements.size() == 0) {
                ReferenceTree referenceTree = FileNetworkUtility.buildReferencedFilesTree(sourceModule, null);
                IModelElement[] iModelElementArray2 = elements;
                int n3 = elements.length;
                n = 0;
                while (n < n3) {
                    IModelElement element = iModelElementArray2[n];
                    if (LanguageModelInitializer.isLanguageModelElement(element) || referenceTree.find(((ModelElement)element).getSourceModule())) {
                        filteredElements.add(element);
                    }
                    ++n;
                }
            }
            if (filteredElements.size() > 0) {
                elements = filteredElements.toArray(new IModelElement[filteredElements.size()]);
            }
        }
        return elements;
    }
}

