/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference.evaluators;

import java.util.HashSet;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.evaluation.types.AmbiguousType;
import org.eclipse.dltk.ti.goals.GoalEvaluator;
import org.eclipse.dltk.ti.goals.IGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.internal.core.mixin.PHPMixinModel;
import org.eclipse.php.internal.core.typeinference.PHPClassType;

public abstract class AbstractPHPGoalEvaluator
extends GoalEvaluator {
    public AbstractPHPGoalEvaluator(IGoal goal) {
        super(goal);
    }

    protected IType[] getTypes(IEvaluatedType instanceType, ISourceModule currentModule) {
        int n;
        IDLTKSearchScope scope;
        IScriptProject scriptProject;
        HashSet<IType> types = new HashSet<IType>();
        if (instanceType instanceof PHPClassType) {
            IModelElement[] elements;
            PHPClassType classType = (PHPClassType)instanceType;
            scriptProject = currentModule.getScriptProject();
            scope = SearchEngine.createSearchScope((IModelElement)scriptProject);
            IModelElement[] iModelElementArray = elements = PHPMixinModel.getInstance(scriptProject).getType(classType.getTypeName(), scope);
            int n2 = elements.length;
            n = 0;
            while (n < n2) {
                IModelElement e = iModelElementArray[n];
                types.add((IType)e);
                ++n;
            }
        } else if (instanceType instanceof AmbiguousType) {
            AmbiguousType ambiguousType = (AmbiguousType)instanceType;
            scriptProject = currentModule.getScriptProject();
            scope = SearchEngine.createSearchScope((IModelElement)scriptProject);
            IEvaluatedType[] iEvaluatedTypeArray = ambiguousType.getPossibleTypes();
            n = iEvaluatedTypeArray.length;
            int n3 = 0;
            while (n3 < n) {
                IEvaluatedType type = iEvaluatedTypeArray[n3];
                if (type instanceof PHPClassType) {
                    IModelElement[] elements;
                    PHPClassType classType = (PHPClassType)type;
                    IModelElement[] iModelElementArray = elements = PHPMixinModel.getInstance(scriptProject).getType(classType.getTypeName(), scope);
                    int n4 = elements.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        IModelElement e = iModelElementArray[n5];
                        types.add((IType)e);
                        ++n5;
                    }
                }
                ++n3;
            }
        }
        if (currentModule != null) {
            IType typeFromSameFile = null;
            for (IType type : types) {
                if (!type.getSourceModule().equals(currentModule)) continue;
                typeFromSameFile = type;
                break;
            }
            if (typeFromSameFile != null) {
                return new IType[]{typeFromSameFile};
            }
        }
        return types.toArray(new IType[types.size()]);
    }
}

