/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference.evaluators;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.Argument;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.TypeReference;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.core.search.SearchMatch;
import org.eclipse.dltk.core.search.SearchParticipant;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.SearchRequestor;
import org.eclipse.dltk.evaluation.types.UnknownType;
import org.eclipse.dltk.internal.core.SourceRefElement;
import org.eclipse.dltk.ti.BasicContext;
import org.eclipse.dltk.ti.GoalState;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.InstanceContext;
import org.eclipse.dltk.ti.goals.ExpressionTypeGoal;
import org.eclipse.dltk.ti.goals.IGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.internal.core.PHPLanguageToolkit;
import org.eclipse.php.internal.core.compiler.ast.nodes.Assignment;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocTag;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPFieldDeclaration;
import org.eclipse.php.internal.core.compiler.ast.nodes.StaticFieldAccess;
import org.eclipse.php.internal.core.mixin.PHPDocField;
import org.eclipse.php.internal.core.mixin.PHPMixinModel;
import org.eclipse.php.internal.core.typeinference.MethodContext;
import org.eclipse.php.internal.core.typeinference.PHPClassType;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.typeinference.PHPSimpleTypes;
import org.eclipse.php.internal.core.typeinference.PHPTypeInferenceUtils;
import org.eclipse.php.internal.core.typeinference.evaluators.AbstractPHPGoalEvaluator;
import org.eclipse.php.internal.core.typeinference.goals.ClassVariableDeclarationGoal;

public class ClassVariableDeclarationEvaluator
extends AbstractPHPGoalEvaluator {
    private List<IEvaluatedType> evaluated = new LinkedList<IEvaluatedType>();

    public ClassVariableDeclarationEvaluator(IGoal goal) {
        super(goal);
    }

    public IGoal[] init() {
        ClassVariableDeclarationGoal typedGoal = (ClassVariableDeclarationGoal)this.goal;
        IType[] types = typedGoal.getTypes();
        if (types == null) {
            InstanceContext context = (InstanceContext)typedGoal.getContext();
            types = this.getTypes(context.getInstanceType(), context.getSourceModule());
        }
        String variableName = typedGoal.getVariableName();
        SearchEngine searchEngine = new SearchEngine();
        SearchParticipant[] participants = new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
        final LinkedList<ExpressionTypeGoal> subGoals = new LinkedList<ExpressionTypeGoal>();
        IType[] iTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            block9: {
                IType type = iTypeArray[n2];
                try {
                    SearchRequestor requestor = new SearchRequestor(){

                        public void acceptSearchMatch(SearchMatch match) throws CoreException {
                            block4: {
                                ISourceModule sourceModule;
                                ModuleDeclaration moduleDeclaration;
                                TypeDeclaration typeDeclaration;
                                IType declaringType;
                                Object element = match.getElement();
                                if (element instanceof IMember && (declaringType = (IType)((IMember)element).getAncestor(7)) != null && (typeDeclaration = PHPModelUtils.getNodeByClass(moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)(sourceModule = declaringType.getSourceModule())), declaringType)) != null && element instanceof SourceRefElement) {
                                    SourceRefElement sourceRefElement = (SourceRefElement)element;
                                    ISourceRange sourceRange = sourceRefElement.getSourceRange();
                                    ClassDeclarationSearcher searcher = new ClassDeclarationSearcher(sourceModule, moduleDeclaration, sourceRange.getOffset(), sourceRange.getLength(), null);
                                    try {
                                        typeDeclaration.traverse((ASTVisitor)searcher);
                                        if (searcher.getResult() != null) {
                                            subGoals.add(new ExpressionTypeGoal(searcher.getContext(), searcher.getResult()));
                                        }
                                    }
                                    catch (Exception e) {
                                        if (!DLTKCore.DEBUG) break block4;
                                        e.printStackTrace();
                                    }
                                }
                            }
                        }
                    };
                    SearchPattern pattern = SearchPattern.createPattern((String)variableName, (int)2, (int)0, (int)0, (IDLTKLanguageToolkit)PHPLanguageToolkit.getDefault());
                    IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)type);
                    searchEngine.search(pattern, participants, scope, requestor, null);
                    if (type.getSuperClasses() != null) {
                        scope = SearchEngine.createSuperHierarchyScope((IType)type);
                        searchEngine.search(pattern, participants, scope, requestor, null);
                    }
                    if (subGoals.size() != 0) break block9;
                    ISourceModule sourceModule = type.getSourceModule();
                    ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
                    TypeDeclaration typeDeclaration = PHPModelUtils.getNodeByClass(moduleDeclaration, type);
                    ClassDeclarationSearcher searcher = new ClassDeclarationSearcher(sourceModule, moduleDeclaration, 0, 0, variableName);
                    try {
                        typeDeclaration.traverse((ASTVisitor)searcher);
                        Map<ASTNode, IContext> staticDeclarations = searcher.getStaticDeclarations();
                        for (ASTNode node : staticDeclarations.keySet()) {
                            subGoals.add(new ExpressionTypeGoal(staticDeclarations.get(node), node));
                        }
                    }
                    catch (Exception e) {
                        if (DLTKCore.DEBUG) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (CoreException e) {
                    if (!DLTKCore.DEBUG) break block9;
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        this.resolveMagicClassVariableDeclaration(types, variableName);
        return subGoals.toArray(new IGoal[subGoals.size()]);
    }

    private void resolveMagicClassVariableDeclaration(IType[] types, String variableName) {
        IType[] iTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IModelElement[] elements;
            IType type = iTypeArray[n2];
            IScriptProject scriptProject = type.getScriptProject();
            IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)type.getSourceModule());
            IModelElement[] iModelElementArray = elements = PHPMixinModel.getInstance(scriptProject).getClassDoc(type.getElementName(), scope);
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IModelElement e = iModelElementArray[n4];
                PHPDocBlock docBlock = ((PHPDocField)e).getDocBlock();
                PHPDocTag[] pHPDocTagArray = docBlock.getTags();
                int n5 = pHPDocTagArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    String typeName;
                    PHPDocTag tag = pHPDocTagArray[n6];
                    int tagKind = tag.getTagKind();
                    if ((tagKind == 30 || tagKind == 31 || tagKind == 32) && (typeName = this.getTypeBinding(variableName, tag)) != null) {
                        Object resolved = PHPSimpleTypes.fromString(typeName);
                        if (resolved == null) {
                            resolved = new PHPClassType(typeName);
                        }
                        this.evaluated.add((IEvaluatedType)resolved);
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
    }

    private String getTypeBinding(String variableName, PHPDocTag docTag) {
        String[] split = docTag.getValue().trim().split("\\s+");
        if (split.length < 2) {
            return null;
        }
        return split[1].equals(variableName) ? split[0] : null;
    }

    public Object produceResult() {
        return PHPTypeInferenceUtils.combineTypes(this.evaluated);
    }

    public IGoal[] subGoalDone(IGoal subgoal, Object result, GoalState state) {
        if (state != GoalState.RECURSIVE && result != null) {
            this.evaluated.add((IEvaluatedType)result);
        }
        return IGoal.NO_GOALS;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ClassDeclarationSearcher
    extends ASTVisitor {
        private Stack<IContext> contextStack = new Stack();
        private ISourceModule sourceModule;
        private ModuleDeclaration moduleDeclaration;
        private ASTNode result;
        private IContext context;
        private int offset;
        private int length;
        private String variableName;
        private Map<ASTNode, IContext> staticDeclarations;

        public ClassDeclarationSearcher(ISourceModule sourceModule, ModuleDeclaration moduleDeclaration, int offset, int length, String variableName) {
            this.sourceModule = sourceModule;
            this.moduleDeclaration = moduleDeclaration;
            this.offset = offset;
            this.length = length;
            this.variableName = variableName;
            this.staticDeclarations = new HashMap<ASTNode, IContext>();
        }

        public ASTNode getResult() {
            return this.result;
        }

        public Map<ASTNode, IContext> getStaticDeclarations() {
            return this.staticDeclarations;
        }

        public IContext getContext() {
            return this.context;
        }

        public boolean visit(Statement e) throws Exception {
            PHPFieldDeclaration phpFieldDecl;
            if (e instanceof PHPFieldDeclaration && (phpFieldDecl = (PHPFieldDeclaration)e).getDeclarationStart() == this.offset && phpFieldDecl.sourceEnd() - phpFieldDecl.getDeclarationStart() == this.length) {
                this.result = ((PHPFieldDeclaration)e).getVariableValue();
                this.context = this.contextStack.peek();
            }
            return this.visitGeneral((ASTNode)e);
        }

        public boolean visit(Expression e) throws Exception {
            if (e instanceof Assignment) {
                if (e.sourceStart() == this.offset && e.sourceEnd() - e.sourceStart() == this.length) {
                    this.result = ((Assignment)e).getValue();
                    this.context = this.contextStack.peek();
                } else if (this.variableName != null) {
                    Expression field;
                    StaticFieldAccess fieldAccess;
                    Expression dispatcher;
                    Assignment assignment = (Assignment)e;
                    Expression left = assignment.getVariable();
                    Expression right = assignment.getValue();
                    if (left instanceof StaticFieldAccess && (dispatcher = (fieldAccess = (StaticFieldAccess)left).getDispatcher()) instanceof TypeReference && "self".equals(((TypeReference)dispatcher).getName()) && (field = fieldAccess.getField()) instanceof VariableReference && this.variableName.equals(((VariableReference)field).getName())) {
                        this.staticDeclarations.put((ASTNode)right, this.contextStack.peek());
                    }
                }
            }
            return this.visitGeneral((ASTNode)e);
        }

        public boolean visitGeneral(ASTNode e) throws Exception {
            return e.sourceStart() <= this.offset || this.variableName != null;
        }

        public boolean visit(TypeDeclaration node) throws Exception {
            InstanceContext context = new InstanceContext(this.sourceModule, this.moduleDeclaration, (IEvaluatedType)new PHPClassType(node.getName()));
            this.contextStack.push((IContext)context);
            return this.visitGeneral((ASTNode)node);
        }

        public boolean endvisit(TypeDeclaration node) throws Exception {
            this.contextStack.pop();
            this.endvisitGeneral((ASTNode)node);
            return true;
        }

        public boolean visit(MethodDeclaration e) throws Exception {
            LinkedList<String> argumentsList = new LinkedList<String>();
            LinkedList<IEvaluatedType> argTypes = new LinkedList<IEvaluatedType>();
            List args = e.getArguments();
            for (Argument a : args) {
                argumentsList.add(a.getName());
                argTypes.add(UnknownType.INSTANCE);
            }
            MethodContext context = new MethodContext(this.contextStack.peek(), this.sourceModule, this.moduleDeclaration, e, argumentsList.toArray(new String[argumentsList.size()]), argTypes.toArray(new IEvaluatedType[argTypes.size()]));
            this.contextStack.push(context);
            return this.visitGeneral((ASTNode)e);
        }

        public boolean endvisit(MethodDeclaration node) throws Exception {
            this.contextStack.pop();
            this.endvisitGeneral((ASTNode)node);
            return true;
        }

        public boolean visit(ModuleDeclaration node) throws Exception {
            BasicContext context = new BasicContext(this.sourceModule, node);
            this.contextStack.push((IContext)context);
            return this.visitGeneral((ASTNode)node);
        }

        public boolean endvisit(ModuleDeclaration node) throws Exception {
            this.contextStack.pop();
            this.endvisitGeneral((ASTNode)node);
            return true;
        }
    }
}

