/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference.evaluators;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.expressions.CallExpression;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.ti.GoalState;
import org.eclipse.dltk.ti.ISourceModuleContext;
import org.eclipse.dltk.ti.goals.ExpressionTypeGoal;
import org.eclipse.dltk.ti.goals.GoalEvaluator;
import org.eclipse.dltk.ti.goals.IGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.internal.core.compiler.ast.nodes.ClassConstantDeclaration;
import org.eclipse.php.internal.core.compiler.ast.nodes.Scalar;
import org.eclipse.php.internal.core.mixin.PHPMixinModel;
import org.eclipse.php.internal.core.typeinference.PHPTypeInferenceUtils;
import org.eclipse.php.internal.core.typeinference.goals.ConstantDeclarationGoal;

public class ConstantDeclarationEvaluator
extends GoalEvaluator {
    private List<IEvaluatedType> evaluatedTypes = new LinkedList<IEvaluatedType>();

    public ConstantDeclarationEvaluator(IGoal goal) {
        super(goal);
    }

    public IGoal[] init() {
        ConstantDeclarationGoal typedGoal = (ConstantDeclarationGoal)this.goal;
        String constantName = typedGoal.getConstantName();
        String typeName = typedGoal.getTypeName();
        IDLTKSearchScope scope = null;
        IScriptProject scriptProject = null;
        ISourceModuleContext sourceModuleContext = (ISourceModuleContext)this.goal.getContext();
        if (sourceModuleContext != null) {
            scriptProject = sourceModuleContext.getSourceModule().getScriptProject();
            scope = SearchEngine.createSearchScope((IModelElement)scriptProject);
        }
        PHPMixinModel mixinModel = scriptProject == null ? PHPMixinModel.getWorkspaceInstance() : PHPMixinModel.getInstance(scriptProject);
        IModelElement[] elements = mixinModel.getConstant(constantName, typeName, scope);
        HashMap<ISourceModule, TreeSet<ISourceRange>> offsets = new HashMap<ISourceModule, TreeSet<ISourceRange>>();
        Comparator<ISourceRange> sourceRangeComparator = new Comparator<ISourceRange>(){

            @Override
            public int compare(ISourceRange o1, ISourceRange o2) {
                return o1.getOffset() - o2.getOffset();
            }
        };
        IModelElement[] iModelElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            block10: {
                IModelElement element = iModelElementArray[n2];
                if (element instanceof IField) {
                    IField field = (IField)element;
                    ISourceModule sourceModule = field.getSourceModule();
                    if (!offsets.containsKey(sourceModule)) {
                        offsets.put(sourceModule, new TreeSet<ISourceRange>(sourceRangeComparator));
                    }
                    try {
                        ((SortedSet)offsets.get(sourceModule)).add(field.getSourceRange());
                    }
                    catch (ModelException e) {
                        if (!DLTKCore.DEBUG) break block10;
                        e.printStackTrace();
                    }
                }
            }
            ++n2;
        }
        LinkedList<ExpressionTypeGoal> subGoals = new LinkedList<ExpressionTypeGoal>();
        for (ISourceModule sourceModule : offsets.keySet()) {
            ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
            SortedSet fileOffsets = (SortedSet)offsets.get(sourceModule);
            if (fileOffsets.isEmpty()) continue;
            ConstantDeclarationSearcher searcher = new ConstantDeclarationSearcher(fileOffsets, constantName);
            try {
                moduleDeclaration.traverse((ASTVisitor)searcher);
                for (Scalar scalar : searcher.getDeclarations()) {
                    subGoals.add(new ExpressionTypeGoal(this.goal.getContext(), (ASTNode)scalar));
                }
            }
            catch (Exception e) {
                if (!DLTKCore.DEBUG) continue;
                e.printStackTrace();
            }
        }
        return subGoals.toArray(new IGoal[subGoals.size()]);
    }

    public Object produceResult() {
        return PHPTypeInferenceUtils.combineTypes(this.evaluatedTypes);
    }

    public IGoal[] subGoalDone(IGoal subgoal, Object result, GoalState state) {
        if (state != GoalState.RECURSIVE && result != null) {
            this.evaluatedTypes.add((IEvaluatedType)result);
        }
        return IGoal.NO_GOALS;
    }

    private static String stripQuotes(String name) {
        int len = name.length();
        if (len > 1 && (name.charAt(0) == '\'' && name.charAt(len - 1) == '\'' || name.charAt(0) == '\"' && name.charAt(len - 1) == '\"')) {
            name = name.substring(1, len - 1);
        }
        return name;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ConstantDeclarationSearcher
    extends ASTVisitor {
        private String constantName;
        private Iterator<ISourceRange> offsetsIt;
        private int currentStart;
        private int currentEnd;
        private boolean stopProcessing;
        private List<Scalar> declarations = new LinkedList<Scalar>();

        public ConstantDeclarationSearcher(SortedSet<ISourceRange> offsets, String constantName) {
            this.constantName = constantName;
            this.offsetsIt = offsets.iterator();
            this.setNextRange();
        }

        public List<Scalar> getDeclarations() {
            return this.declarations;
        }

        private void setNextRange() {
            if (this.offsetsIt.hasNext()) {
                ISourceRange range = this.offsetsIt.next();
                this.currentStart = range.getOffset();
                this.currentEnd = this.currentStart + range.getLength();
            } else {
                this.stopProcessing = true;
            }
        }

        private boolean interesting(ASTNode node) {
            return !this.stopProcessing && node.sourceStart() <= this.currentStart && node.sourceEnd() >= this.currentEnd;
        }

        public boolean visit(CallExpression node) throws Exception {
            List args;
            if (!this.interesting((ASTNode)node)) {
                return false;
            }
            if ("define".equalsIgnoreCase(node.getName()) && (args = node.getArgs().getChilds()).size() == 2) {
                ASTNode firstArg = (ASTNode)args.get(0);
                ASTNode secondArg = (ASTNode)args.get(0);
                if (firstArg instanceof Scalar && secondArg instanceof Scalar) {
                    Scalar constantName = (Scalar)firstArg;
                    Scalar constantValue = (Scalar)secondArg;
                    if (this.constantName.equals(ConstantDeclarationEvaluator.stripQuotes(constantName.getValue()))) {
                        this.declarations.add(constantValue);
                    }
                }
            }
            return this.visitGeneral((ASTNode)node);
        }

        public boolean visit(ClassConstantDeclaration node) throws Exception {
            if (!this.interesting((ASTNode)node)) {
                return false;
            }
            Expression value = node.getConstantValue();
            if (value instanceof Scalar) {
                this.declarations.add((Scalar)value);
            }
            return this.visitGeneral((ASTNode)node);
        }

        public boolean visit(Expression node) throws Exception {
            if (!this.interesting((ASTNode)node)) {
                return false;
            }
            if (node instanceof CallExpression) {
                return this.visit((CallExpression)node);
            }
            return this.visitGeneral((ASTNode)node);
        }

        public boolean endvisit(Statement s) throws Exception {
            if (s instanceof ClassConstantDeclaration) {
                return this.visit((ClassConstantDeclaration)s);
            }
            return this.visitGeneral((ASTNode)s);
        }

        public boolean visitGeneral(ASTNode node) throws Exception {
            return this.interesting(node);
        }
    }
}

