/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference.evaluators;

import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ti.GoalState;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.goals.ExpressionTypeGoal;
import org.eclipse.dltk.ti.goals.GoalEvaluator;
import org.eclipse.dltk.ti.goals.IGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.internal.core.compiler.ast.nodes.FormalParameter;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocTag;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPMethodDeclaration;
import org.eclipse.php.internal.core.typeinference.MethodContext;
import org.eclipse.php.internal.core.typeinference.PHPClassType;
import org.eclipse.php.internal.core.typeinference.PHPSimpleTypes;

public class FormalParameterEvaluator
extends GoalEvaluator {
    private IEvaluatedType result;

    public FormalParameterEvaluator(IGoal goal) {
        super(goal);
    }

    public IGoal[] init() {
        ExpressionTypeGoal typedGoal = (ExpressionTypeGoal)this.goal;
        FormalParameter parameter = (FormalParameter)typedGoal.getExpression();
        SimpleReference type = parameter.getParameterType();
        if (type != null) {
            this.result = new PHPClassType(type.getName());
        } else {
            MethodContext methodContext;
            PHPMethodDeclaration methodDeclaration;
            PHPDocBlock docBlock;
            IContext context = typedGoal.getContext();
            if (context instanceof MethodContext && (docBlock = (methodDeclaration = (PHPMethodDeclaration)(methodContext = (MethodContext)context).getMethodNode()).getPHPDoc()) != null) {
                PHPDocTag[] pHPDocTagArray = docBlock.getTags();
                int n = pHPDocTagArray.length;
                int n2 = 0;
                while (n2 < n) {
                    SimpleReference[] references;
                    PHPDocTag tag = pHPDocTagArray[n2];
                    if (tag.getTagKind() == 7 && (references = tag.getReferences()).length == 2 && references[0].getName().equals(parameter.getName())) {
                        this.result = PHPSimpleTypes.fromString(references[1].getName());
                        if (this.result == null) {
                            this.result = new PHPClassType(references[1].getName());
                        }
                    }
                    ++n2;
                }
            }
        }
        return IGoal.NO_GOALS;
    }

    public Object produceResult() {
        return this.result;
    }

    public IGoal[] subGoalDone(IGoal subgoal, Object result, GoalState state) {
        return IGoal.NO_GOALS;
    }
}

