/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference.evaluators;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.Argument;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.evaluation.types.UnknownType;
import org.eclipse.dltk.internal.core.SourceField;
import org.eclipse.dltk.ti.BasicContext;
import org.eclipse.dltk.ti.GoalState;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.ISourceModuleContext;
import org.eclipse.dltk.ti.InstanceContext;
import org.eclipse.dltk.ti.goals.GoalEvaluator;
import org.eclipse.dltk.ti.goals.IGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.internal.core.compiler.ast.nodes.Assignment;
import org.eclipse.php.internal.core.compiler.ast.nodes.CatchClause;
import org.eclipse.php.internal.core.compiler.ast.nodes.ConditionalExpression;
import org.eclipse.php.internal.core.compiler.ast.nodes.ForEachStatement;
import org.eclipse.php.internal.core.compiler.ast.nodes.ForStatement;
import org.eclipse.php.internal.core.compiler.ast.nodes.IfStatement;
import org.eclipse.php.internal.core.compiler.ast.nodes.SwitchCase;
import org.eclipse.php.internal.core.compiler.ast.nodes.WhileStatement;
import org.eclipse.php.internal.core.mixin.PHPMixinModel;
import org.eclipse.php.internal.core.typeinference.MethodContext;
import org.eclipse.php.internal.core.typeinference.PHPClassType;
import org.eclipse.php.internal.core.typeinference.PHPTypeInferenceUtils;
import org.eclipse.php.internal.core.typeinference.goals.GlobalVariableReferencesGoal;
import org.eclipse.php.internal.core.typeinference.goals.VariableDeclarationGoal;

public class GlobalVariableReferencesEvaluator
extends GoalEvaluator {
    private List<IEvaluatedType> evaluated = new LinkedList<IEvaluatedType>();

    public GlobalVariableReferencesEvaluator(IGoal goal) {
        super(goal);
    }

    public IGoal[] init() {
        GlobalVariableReferencesGoal typedGoal = (GlobalVariableReferencesGoal)this.goal;
        IContext context = this.goal.getContext();
        ISourceModuleContext sourceModuleContext = null;
        if (context instanceof ISourceModuleContext) {
            sourceModuleContext = (ISourceModuleContext)context;
        }
        String variableName = typedGoal.getVariableName();
        boolean exploreOtherFiles = true;
        IScriptProject scriptProject = sourceModuleContext.getSourceModule().getScriptProject();
        IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)scriptProject);
        IModelElement[] elements = PHPMixinModel.getInstance(scriptProject).getVariable(variableName, null, null, scope);
        HashMap<ISourceModule, TreeSet<ISourceRange>> offsets = new HashMap<ISourceModule, TreeSet<ISourceRange>>();
        Comparator<ISourceRange> sourceRangeComparator = new Comparator<ISourceRange>(){

            @Override
            public int compare(ISourceRange o1, ISourceRange o2) {
                return o1.getOffset() - o2.getOffset();
            }
        };
        IModelElement[] iModelElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            block11: {
                IModelElement element = iModelElementArray[n2];
                if (element instanceof SourceField) {
                    SourceField sourceField = (SourceField)element;
                    ISourceModule sourceModule = sourceField.getSourceModule();
                    if (!offsets.containsKey(sourceModule)) {
                        offsets.put(sourceModule, new TreeSet<ISourceRange>(sourceRangeComparator));
                    }
                    try {
                        ((SortedSet)offsets.get(sourceModule)).add(sourceField.getSourceRange());
                    }
                    catch (ModelException e) {
                        if (!DLTKCore.DEBUG) break block11;
                        e.printStackTrace();
                    }
                }
            }
            ++n2;
        }
        LinkedList<VariableDeclarationGoal> subGoals = new LinkedList<VariableDeclarationGoal>();
        for (ISourceModule sourceModule : offsets.keySet()) {
            if (!exploreOtherFiles && (sourceModuleContext == null || !sourceModuleContext.getSourceModule().equals(sourceModule))) continue;
            ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
            SortedSet fileOffsets = (SortedSet)offsets.get(sourceModule);
            if (fileOffsets.isEmpty()) continue;
            VariableDeclarationSearcher varSearcher = new VariableDeclarationSearcher(sourceModule, moduleDeclaration, fileOffsets, variableName);
            try {
                moduleDeclaration.traverse((ASTVisitor)varSearcher);
                Map<IContext, LinkedList<ASTNode>> contextToDeclarationMap = varSearcher.getContextToDeclarationMap();
                for (IContext c : contextToDeclarationMap.keySet()) {
                    for (ASTNode declaration : contextToDeclarationMap.get(c)) {
                        subGoals.add(new VariableDeclarationGoal(c, declaration));
                    }
                }
            }
            catch (Exception e) {
                if (!DLTKCore.DEBUG) continue;
                e.printStackTrace();
            }
        }
        return subGoals.toArray(new IGoal[subGoals.size()]);
    }

    public Object produceResult() {
        return PHPTypeInferenceUtils.combineTypes(this.evaluated);
    }

    public IGoal[] subGoalDone(IGoal subgoal, Object result, GoalState state) {
        if (state != GoalState.RECURSIVE && result != null) {
            this.evaluated.add((IEvaluatedType)result);
        }
        return IGoal.NO_GOALS;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class VariableDeclarationSearcher
    extends ASTVisitor {
        private final ISourceModule sourceModule;
        private final ModuleDeclaration moduleDeclaration;
        private final String variableName;
        private Stack<IContext> contextStack = new Stack();
        private Map<IContext, LinkedList<ASTNode>> contextToDeclarations = new HashMap<IContext, LinkedList<ASTNode>>();
        private Stack<ASTNode> nodesStack = new Stack();
        private int level = 0;
        private Iterator<ISourceRange> offsetsIt;
        private int currentStart;
        private int currentEnd;
        private boolean stopProcessing;

        public VariableDeclarationSearcher(ISourceModule sourceModule, ModuleDeclaration moduleDeclaration, SortedSet<ISourceRange> offsets, String variableName) {
            this.sourceModule = sourceModule;
            this.moduleDeclaration = moduleDeclaration;
            this.variableName = variableName;
            this.offsetsIt = offsets.iterator();
            this.setNextRange();
        }

        public Map<IContext, LinkedList<ASTNode>> getContextToDeclarationMap() {
            return this.contextToDeclarations;
        }

        private void setNextRange() {
            if (this.offsetsIt.hasNext()) {
                ISourceRange range = this.offsetsIt.next();
                this.currentStart = range.getOffset();
                this.currentEnd = this.currentStart + range.getLength();
            } else {
                this.stopProcessing = true;
            }
        }

        private boolean interesting(ASTNode node) {
            return !this.stopProcessing && node.sourceStart() <= this.currentStart && node.sourceEnd() >= this.currentEnd;
        }

        private void increaseConditionalLevel() {
            ++this.level;
        }

        private void decreaseConditionalLevel() {
            --this.level;
        }

        public boolean visit(Assignment node) throws Exception {
            VariableReference variableReference;
            if (!this.interesting((ASTNode)node)) {
                return false;
            }
            Expression variable = node.getVariable();
            if (variable instanceof VariableReference && this.variableName.equals((variableReference = (VariableReference)variable).getName())) {
                LinkedList<ASTNode> decl = this.contextToDeclarations.get(this.contextStack.peek());
                while (decl.size() > this.level) {
                    decl.removeLast();
                }
                decl.addLast((ASTNode)node.getValue());
                this.setNextRange();
            }
            return this.visitGeneral((ASTNode)node);
        }

        public boolean visit(Block s) throws Exception {
            ASTNode parent = this.nodesStack.peek();
            if (parent instanceof CatchClause || parent instanceof IfStatement || parent instanceof ForStatement || parent instanceof ForEachStatement || parent instanceof SwitchCase || parent instanceof WhileStatement) {
                this.increaseConditionalLevel();
            }
            return this.visitGeneral((ASTNode)s);
        }

        public boolean visit(Statement node) throws Exception {
            if (!this.interesting((ASTNode)node)) {
                return false;
            }
            ASTNode parent = this.nodesStack.peek();
            if (parent instanceof IfStatement || parent instanceof ForStatement || parent instanceof ForEachStatement || parent instanceof SwitchCase || parent instanceof WhileStatement) {
                this.increaseConditionalLevel();
            }
            return this.visitGeneral((ASTNode)node);
        }

        public boolean visit(Expression node) throws Exception {
            if (!this.interesting((ASTNode)node)) {
                return false;
            }
            if (node instanceof Assignment) {
                return this.visit((Assignment)node);
            }
            if (node instanceof Block) {
                return this.visit((Block)node);
            }
            ASTNode parent = this.nodesStack.peek();
            if (parent instanceof ConditionalExpression) {
                this.increaseConditionalLevel();
            }
            return this.visitGeneral((ASTNode)node);
        }

        public boolean endvisit(Block s) throws Exception {
            ASTNode parent = this.nodesStack.peek();
            if (parent instanceof CatchClause || parent instanceof IfStatement || parent instanceof ForStatement || parent instanceof ForEachStatement || parent instanceof SwitchCase || parent instanceof WhileStatement) {
                this.decreaseConditionalLevel();
            }
            this.endvisitGeneral((ASTNode)s);
            return true;
        }

        public boolean endvisit(Statement s) throws Exception {
            ASTNode parent = this.nodesStack.peek();
            if (parent instanceof IfStatement || parent instanceof ForStatement || parent instanceof ForEachStatement || parent instanceof SwitchCase || parent instanceof WhileStatement) {
                this.decreaseConditionalLevel();
            }
            return this.visitGeneral((ASTNode)s);
        }

        public boolean endvisit(Expression e) throws Exception {
            if (e instanceof Block) {
                return this.endvisit((Block)e);
            }
            ASTNode parent = this.nodesStack.peek();
            if (parent instanceof ConditionalExpression) {
                this.decreaseConditionalLevel();
            }
            this.endvisitGeneral((ASTNode)e);
            return true;
        }

        public boolean visit(TypeDeclaration node) throws Exception {
            InstanceContext context = new InstanceContext(this.sourceModule, this.moduleDeclaration, (IEvaluatedType)new PHPClassType(node.getName()));
            this.contextStack.push((IContext)context);
            this.contextToDeclarations.put((IContext)context, new LinkedList());
            return this.visitGeneral((ASTNode)node);
        }

        public boolean endvisit(TypeDeclaration node) throws Exception {
            this.contextStack.pop();
            this.endvisitGeneral((ASTNode)node);
            return true;
        }

        public boolean visit(MethodDeclaration node) throws Exception {
            LinkedList<String> argumentsList = new LinkedList<String>();
            LinkedList<IEvaluatedType> argTypes = new LinkedList<IEvaluatedType>();
            List args = node.getArguments();
            for (Argument a : args) {
                argumentsList.add(a.getName());
                argTypes.add(UnknownType.INSTANCE);
            }
            MethodContext context = new MethodContext(this.contextStack.peek(), this.sourceModule, this.moduleDeclaration, node, argumentsList.toArray(new String[argumentsList.size()]), argTypes.toArray(new IEvaluatedType[argTypes.size()]));
            this.contextStack.push(context);
            this.contextToDeclarations.put(context, new LinkedList());
            return this.visitGeneral((ASTNode)node);
        }

        public boolean endvisit(MethodDeclaration node) throws Exception {
            this.contextStack.pop();
            this.endvisitGeneral((ASTNode)node);
            return true;
        }

        public boolean visit(ModuleDeclaration node) throws Exception {
            BasicContext context = new BasicContext(this.sourceModule, node);
            this.contextStack.push((IContext)context);
            this.contextToDeclarations.put((IContext)context, new LinkedList());
            return this.visitGeneral((ASTNode)node);
        }

        public boolean endvisit(ModuleDeclaration node) throws Exception {
            this.contextStack.pop();
            this.endvisitGeneral((ASTNode)node);
            return true;
        }

        public boolean visitGeneral(ASTNode node) throws Exception {
            this.nodesStack.push(node);
            return this.interesting(node);
        }

        public void endvisitGeneral(ASTNode node) throws Exception {
            this.nodesStack.pop();
        }
    }
}

