/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference.evaluators;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.ti.GoalState;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.goals.ExpressionTypeGoal;
import org.eclipse.dltk.ti.goals.IGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocTag;
import org.eclipse.php.internal.core.compiler.ast.nodes.ReturnStatement;
import org.eclipse.php.internal.core.mixin.PHPDocField;
import org.eclipse.php.internal.core.mixin.PHPMixinModel;
import org.eclipse.php.internal.core.typeinference.MethodContext;
import org.eclipse.php.internal.core.typeinference.PHPClassType;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.typeinference.PHPSimpleTypes;
import org.eclipse.php.internal.core.typeinference.PHPTypeInferenceUtils;
import org.eclipse.php.internal.core.typeinference.evaluators.AbstractPHPGoalEvaluator;
import org.eclipse.php.internal.core.typeinference.goals.MethodElementReturnTypeGoal;

public class MethodElementReturnTypeEvaluator
extends AbstractPHPGoalEvaluator {
    private final List<IEvaluatedType> evaluated = new LinkedList<IEvaluatedType>();

    public MethodElementReturnTypeEvaluator(IGoal goal) {
        super(goal);
    }

    public IGoal[] init() {
        MethodDeclaration decl;
        ModuleDeclaration module;
        ISourceModule sourceModule;
        LinkedList<ExpressionTypeGoal> subGoals;
        IMethod method;
        MethodElementReturnTypeGoal goal;
        block9: {
            goal = (MethodElementReturnTypeGoal)this.getGoal();
            method = goal.getMethod();
            subGoals = new LinkedList<ExpressionTypeGoal>();
            sourceModule = method.getSourceModule();
            module = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
            decl = null;
            try {
                decl = PHPModelUtils.getNodeByMethod(module, method);
            }
            catch (ModelException e) {
                if (!DLTKCore.DEBUG) break block9;
                e.printStackTrace();
            }
        }
        if (decl != null) {
            MethodContext innerContext;
            block10: {
                String[] parameters;
                try {
                    parameters = method.getParameters();
                }
                catch (ModelException e) {
                    if (DLTKCore.DEBUG) {
                        e.printStackTrace();
                    }
                    parameters = new String[]{};
                }
                innerContext = new MethodContext(goal.getContext(), sourceModule, module, decl, parameters, new IEvaluatedType[0]);
                ASTVisitor visitor = new ASTVisitor(){

                    public boolean visitGeneral(ASTNode node) throws Exception {
                        if (node instanceof ReturnStatement) {
                            ReturnStatement statement = (ReturnStatement)node;
                            Expression expr = statement.getExpr();
                            if (expr == null) {
                                MethodElementReturnTypeEvaluator.this.evaluated.add(PHPSimpleTypes.VOID);
                            } else {
                                subGoals.add(new ExpressionTypeGoal(innerContext, (ASTNode)expr));
                            }
                        }
                        return super.visitGeneral(node);
                    }
                };
                try {
                    decl.traverse(visitor);
                }
                catch (Exception e) {
                    if (!DLTKCore.DEBUG) break block10;
                    e.printStackTrace();
                }
            }
            if (decl.getBody() != null) {
                subGoals.add(new ExpressionTypeGoal((IContext)innerContext, (ASTNode)decl.getBody()));
            }
        }
        this.resolveMagicMethodDeclaration(method, method.getElementName());
        return subGoals.toArray(new IGoal[subGoals.size()]);
    }

    private void resolveMagicMethodDeclaration(IMethod method, String methodName) {
        IModelElement[] elements;
        IModelElement parent = method.getParent();
        if (parent.getElementType() != 7) {
            return;
        }
        IType type = (IType)parent;
        IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)type.getSourceModule());
        IModelElement[] iModelElementArray = elements = PHPMixinModel.getInstance(type.getScriptProject()).getClassDoc(type.getElementName(), scope);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IModelElement e = iModelElementArray[n2];
            PHPDocBlock docBlock = ((PHPDocField)e).getDocBlock();
            PHPDocTag[] pHPDocTagArray = docBlock.getTags();
            int n3 = pHPDocTagArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String typeName;
                PHPDocTag tag = pHPDocTagArray[n4];
                int tagKind = tag.getTagKind();
                if (tagKind == 33 && (typeName = this.getTypeBinding(methodName, tag)) != null) {
                    Object resolved = PHPSimpleTypes.fromString(typeName);
                    if (resolved == null) {
                        resolved = new PHPClassType(typeName);
                    }
                    this.evaluated.add((IEvaluatedType)resolved);
                }
                ++n4;
            }
            ++n2;
        }
    }

    private String getTypeBinding(String methodName, PHPDocTag docTag) {
        String[] split = docTag.getValue().trim().split("\\s+");
        if (split.length < 2) {
            return null;
        }
        if (split[1].equals(methodName)) {
            return split[0];
        }
        if (split[1].length() > 2 && split[1].endsWith("()")) {
            String substring = split[1].substring(0, split[1].length() - 2);
            return substring.equals(methodName) ? split[0] : null;
        }
        return null;
    }

    public IGoal[] subGoalDone(IGoal subgoal, Object result, GoalState state) {
        if (state != GoalState.RECURSIVE && result != null) {
            this.evaluated.add((IEvaluatedType)result);
        }
        return IGoal.NO_GOALS;
    }

    public Object produceResult() {
        return PHPTypeInferenceUtils.combineTypes(this.evaluated);
    }
}

