/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference.evaluators;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.ti.GoalState;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.InstanceContext;
import org.eclipse.dltk.ti.goals.IGoal;
import org.eclipse.dltk.ti.goals.MethodReturnTypeGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.internal.core.mixin.PHPMixinModel;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.typeinference.PHPTypeInferenceUtils;
import org.eclipse.php.internal.core.typeinference.evaluators.AbstractPHPGoalEvaluator;
import org.eclipse.php.internal.core.typeinference.goals.MethodElementReturnTypeGoal;

public class MethodReturnTypeEvaluator
extends AbstractPHPGoalEvaluator {
    private final List<IEvaluatedType> evaluated = new LinkedList<IEvaluatedType>();

    public MethodReturnTypeEvaluator(IGoal goal) {
        super(goal);
    }

    private MethodReturnTypeGoal getTypedGoal() {
        return (MethodReturnTypeGoal)this.getGoal();
    }

    private InstanceContext getTypedContext() {
        return (InstanceContext)this.getGoal().getContext();
    }

    public Object produceResult() {
        return PHPTypeInferenceUtils.combineTypes(this.evaluated);
    }

    public IGoal[] init() {
        MethodReturnTypeGoal typedGoal = this.getTypedGoal();
        InstanceContext typedContext = this.getTypedContext();
        HashSet<IMethod> methods = new HashSet<IMethod>();
        String methodName = typedGoal.getMethodName();
        IType[] types = this.getTypes(typedContext.getInstanceType(), typedContext.getSourceModule());
        if (types.length == 0) {
            IModelElement[] elements;
            IScriptProject scriptProject = typedContext.getSourceModule().getScriptProject();
            IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)scriptProject);
            IModelElement[] iModelElementArray = elements = PHPMixinModel.getInstance(scriptProject).getFunction(methodName, scope);
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IModelElement e = iModelElementArray[n2];
                methods.add((IMethod)e);
                ++n2;
            }
        } else {
            IType[] iTypeArray = types;
            int n = types.length;
            int scope = 0;
            while (scope < n) {
                block9: {
                    IType type = iTypeArray[scope];
                    try {
                        IModelElement[] elements = PHPMixinModel.getInstance(type.getScriptProject()).getMethod(type.getElementName(), methodName);
                        if (elements.length == 0) {
                            elements = PHPModelUtils.getClassMethod(type, methodName, null);
                        }
                        IModelElement[] iModelElementArray = elements;
                        int n3 = elements.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IModelElement e = iModelElementArray[n4];
                            methods.add((IMethod)e);
                            ++n4;
                        }
                    }
                    catch (CoreException e) {
                        if (!DLTKCore.DEBUG) break block9;
                        e.printStackTrace();
                    }
                }
                ++scope;
            }
        }
        ArrayList<MethodElementReturnTypeGoal> subGoals = new ArrayList<MethodElementReturnTypeGoal>(methods.size());
        for (IMethod method : methods) {
            subGoals.add(new MethodElementReturnTypeGoal((IContext)typedContext, method));
        }
        return subGoals.toArray(new IGoal[subGoals.size()]);
    }

    public IGoal[] subGoalDone(IGoal subgoal, Object result, GoalState state) {
        if (state != GoalState.RECURSIVE && result != null) {
            this.evaluated.add((IEvaluatedType)result);
        }
        return IGoal.NO_GOALS;
    }
}

