/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference.evaluators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.ti.IGoalEvaluatorFactory;
import org.eclipse.dltk.ti.goals.GoalEvaluator;
import org.eclipse.dltk.ti.goals.IGoal;

public class PHPGoalEvaluatorFactory
implements IGoalEvaluatorFactory {
    private static final String GOAL_EVALUATOR_FACTORIES_EXT = "org.eclipse.php.core.goalEvaluatorFactories";
    private static final FactoryInfo[] factoryInfos;

    static {
        ArrayList<FactoryInfo> factories = new ArrayList<FactoryInfo>();
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(GOAL_EVALUATOR_FACTORIES_EXT);
        int i = 0;
        while (i < elements.length) {
            block4: {
                IConfigurationElement element = elements[i];
                try {
                    int priority = PHPGoalEvaluatorFactory.getPriority(element);
                    IGoalEvaluatorFactory factory = (IGoalEvaluatorFactory)element.createExecutableExtension("class");
                    if (factory != null) {
                        factories.add(new FactoryInfo(priority, factory));
                    }
                }
                catch (Exception e) {
                    if (!DLTKCore.DEBUG) break block4;
                    e.printStackTrace();
                }
            }
            ++i;
        }
        factoryInfos = factories.toArray(new FactoryInfo[factories.size()]);
        Arrays.sort(factoryInfos, new Comparator<FactoryInfo>(){

            @Override
            public int compare(FactoryInfo info1, FactoryInfo info2) {
                return info2.priority - info1.priority;
            }
        });
    }

    private static int getPriority(IConfigurationElement element) {
        String priority = element.getAttribute("priority");
        if (priority == null) {
            return 0;
        }
        try {
            int parseInt = Integer.parseInt(priority);
            return parseInt;
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public GoalEvaluator createEvaluator(IGoal goal) {
        if (factoryInfos == null) {
            return null;
        }
        int i = 0;
        while (i < factoryInfos.length) {
            GoalEvaluator evaluator = PHPGoalEvaluatorFactory.factoryInfos[i].factory.createEvaluator(goal);
            if (evaluator != null) {
                return evaluator;
            }
            ++i;
        }
        return null;
    }

    private static class FactoryInfo {
        int priority;
        IGoalEvaluatorFactory factory;

        public FactoryInfo(int priority, IGoalEvaluatorFactory factory) {
            this.priority = priority;
            this.factory = factory;
        }
    }
}

