/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference.evaluators;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.evaluation.types.SimpleType;
import org.eclipse.dltk.ti.BasicContext;
import org.eclipse.dltk.ti.GoalState;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.ISourceModuleContext;
import org.eclipse.dltk.ti.goals.AbstractGoal;
import org.eclipse.dltk.ti.goals.ExpressionTypeGoal;
import org.eclipse.dltk.ti.goals.GoalEvaluator;
import org.eclipse.dltk.ti.goals.IGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.internal.core.compiler.ast.nodes.Assignment;
import org.eclipse.php.internal.core.compiler.ast.nodes.CatchClause;
import org.eclipse.php.internal.core.compiler.ast.nodes.ConditionalExpression;
import org.eclipse.php.internal.core.compiler.ast.nodes.ForEachStatement;
import org.eclipse.php.internal.core.compiler.ast.nodes.ForStatement;
import org.eclipse.php.internal.core.compiler.ast.nodes.FormalParameter;
import org.eclipse.php.internal.core.compiler.ast.nodes.GlobalStatement;
import org.eclipse.php.internal.core.compiler.ast.nodes.IfStatement;
import org.eclipse.php.internal.core.compiler.ast.nodes.SwitchCase;
import org.eclipse.php.internal.core.compiler.ast.nodes.WhileStatement;
import org.eclipse.php.internal.core.typeinference.MethodContext;
import org.eclipse.php.internal.core.typeinference.PHPClassType;
import org.eclipse.php.internal.core.typeinference.PHPTypeInferenceUtils;
import org.eclipse.php.internal.core.typeinference.goals.ForeachStatementGoal;
import org.eclipse.php.internal.core.typeinference.goals.GlobalVariableReferencesGoal;
import org.eclipse.php.internal.core.typeinference.goals.VariableDeclarationGoal;

public class VariableReferenceEvaluator
extends GoalEvaluator {
    private List<IEvaluatedType> results = new ArrayList<IEvaluatedType>();

    public VariableReferenceEvaluator(IGoal goal) {
        super(goal);
    }

    public IGoal[] init() {
        block9: {
            VariableReference variableReference = (VariableReference)((ExpressionTypeGoal)this.goal).getExpression();
            IContext context = this.goal.getContext();
            if (variableReference.getName().equals("$this") && context instanceof MethodContext) {
                MethodContext methodContext = (MethodContext)context;
                IEvaluatedType instanceType = methodContext.getInstanceType();
                if (instanceType != null) {
                    this.results.add((IEvaluatedType)new PHPClassType(instanceType.getTypeName()));
                } else {
                    this.results.add((IEvaluatedType)new SimpleType(8));
                }
                return IGoal.NO_GOALS;
            }
            try {
                if (context instanceof ISourceModuleContext) {
                    ISourceModuleContext typedContext = (ISourceModuleContext)context;
                    ModuleDeclaration node = context instanceof MethodContext ? ((MethodContext)context).getMethodNode() : typedContext.getRootNode();
                    VariableDeclarationSearcher varDecSearcher = new VariableDeclarationSearcher(variableReference);
                    node.traverse((ASTVisitor)varDecSearcher);
                    LinkedList<AbstractGoal> subGoals = new LinkedList<AbstractGoal>();
                    LinkedList<ASTNode> declarations = varDecSearcher.getDeclarations();
                    if (varDecSearcher.needsMergingWithGlobalScope() || declarations.isEmpty() && context.getClass() == BasicContext.class) {
                        subGoals.add(new GlobalVariableReferencesGoal(context, variableReference.getName()));
                    }
                    for (ASTNode declaration : declarations) {
                        if (declaration instanceof ForEachStatement) {
                            subGoals.add(new ForeachStatementGoal(context, ((ForEachStatement)declaration).getExpression()));
                            continue;
                        }
                        subGoals.add(new VariableDeclarationGoal(context, declaration));
                    }
                    return subGoals.toArray(new IGoal[subGoals.size()]);
                }
            }
            catch (Exception e) {
                if (!DLTKCore.DEBUG) break block9;
                e.printStackTrace();
            }
        }
        return IGoal.NO_GOALS;
    }

    public Object produceResult() {
        return PHPTypeInferenceUtils.combineTypes(this.results);
    }

    public IGoal[] subGoalDone(IGoal subgoal, Object result, GoalState state) {
        if (state != GoalState.RECURSIVE && result != null) {
            this.results.add((IEvaluatedType)result);
        }
        return IGoal.NO_GOALS;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class VariableDeclarationSearcher
    extends ASTVisitor {
        private final String variableName;
        private final int variableOffset;
        private LinkedList<ASTNode> declarations = new LinkedList();
        private int level = 0;
        private Stack<ASTNode> nodesStack = new Stack();
        private int seenGlobal = 0;
        private boolean mergeWithGlobalScope;

        public VariableDeclarationSearcher(VariableReference variableReference) {
            this.variableName = variableReference.getName();
            this.variableOffset = variableReference.sourceStart();
        }

        public LinkedList<ASTNode> getDeclarations() {
            int nullIdx;
            while ((nullIdx = this.declarations.indexOf(null)) != -1) {
                this.declarations.remove(nullIdx);
            }
            return this.declarations;
        }

        public boolean needsMergingWithGlobalScope() {
            return this.mergeWithGlobalScope;
        }

        public boolean visit(Assignment s) throws Exception {
            VariableReference variableReference;
            Expression variable = s.getVariable();
            if (variable instanceof VariableReference && this.variableName.equals((variableReference = (VariableReference)variable).getName())) {
                if (this.level <= this.seenGlobal) {
                    this.mergeWithGlobalScope = false;
                }
                while (this.declarations.size() > this.level) {
                    this.declarations.removeLast();
                }
                this.declarations.addLast((ASTNode)s);
            }
            return this.visitGeneral((ASTNode)s);
        }

        private void increaseConditionalLevel() {
            ++this.level;
        }

        private void decreaseConditionalLevel() {
            --this.level;
        }

        public boolean visit(Block s) throws Exception {
            ASTNode parent = this.nodesStack.peek();
            if (parent instanceof CatchClause || parent instanceof IfStatement || parent instanceof ForStatement || parent instanceof ForEachStatement || parent instanceof SwitchCase || parent instanceof WhileStatement) {
                this.increaseConditionalLevel();
            }
            return this.visitGeneral((ASTNode)s);
        }

        public boolean visit(Statement s) throws Exception {
            ForEachStatement foreachStatement;
            if (!this.shouldContinue((ASTNode)s)) {
                return false;
            }
            if (s instanceof GlobalStatement) {
                GlobalStatement globalStatement = (GlobalStatement)s;
                Expression[] expressionArray = globalStatement.getVariables();
                int n = expressionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    VariableReference variableReference;
                    Expression variable = expressionArray[n2];
                    if (variable instanceof VariableReference && (variableReference = (VariableReference)variable).getName().equals(this.variableName)) {
                        this.seenGlobal = this.level;
                        this.mergeWithGlobalScope = true;
                        int i = 0;
                        if (i < this.declarations.size()) {
                            this.declarations.set(i, null);
                            return this.visitGeneral((ASTNode)s);
                        }
                    }
                    ++n2;
                }
            } else if (s instanceof FormalParameter) {
                FormalParameter parameter = (FormalParameter)s;
                if (parameter.getName().equals(this.variableName)) {
                    this.declarations.clear();
                    this.declarations.addLast((ASTNode)s);
                    return this.visitGeneral((ASTNode)s);
                }
            } else if (s instanceof CatchClause) {
                CatchClause catchClause = (CatchClause)s;
                if (catchClause.getVariable().getName().equals(this.variableName)) {
                    this.declarations.clear();
                    this.declarations.addLast((ASTNode)catchClause);
                    return this.visitGeneral((ASTNode)s);
                }
            } else if (s instanceof ForEachStatement && (foreachStatement = (ForEachStatement)s).getValue() instanceof SimpleReference && ((SimpleReference)foreachStatement.getValue()).getName().equals(this.variableName)) {
                this.declarations.clear();
                this.declarations.addLast((ASTNode)foreachStatement);
                return this.visitGeneral((ASTNode)s);
            }
            ASTNode parent = this.nodesStack.peek();
            if (parent instanceof IfStatement || parent instanceof ForStatement || parent instanceof ForEachStatement || parent instanceof SwitchCase || parent instanceof WhileStatement) {
                this.increaseConditionalLevel();
            }
            return this.visitGeneral((ASTNode)s);
        }

        public boolean visit(Expression e) throws Exception {
            if (!this.shouldContinue((ASTNode)e)) {
                return false;
            }
            if (e instanceof Assignment) {
                return this.visit((Assignment)e);
            }
            if (e instanceof Block) {
                return this.visit((Block)e);
            }
            ASTNode parent = this.nodesStack.peek();
            if (parent instanceof ConditionalExpression) {
                this.increaseConditionalLevel();
            }
            return this.visitGeneral((ASTNode)e);
        }

        public boolean endvisit(Block s) throws Exception {
            ASTNode parent = this.nodesStack.peek();
            if (parent instanceof CatchClause || parent instanceof IfStatement || parent instanceof ForStatement || parent instanceof ForEachStatement || parent instanceof SwitchCase || parent instanceof WhileStatement) {
                this.decreaseConditionalLevel();
            }
            this.endvisitGeneral((ASTNode)s);
            return true;
        }

        public boolean endvisit(Statement s) throws Exception {
            ASTNode parent = this.nodesStack.peek();
            if (parent instanceof IfStatement || parent instanceof ForStatement || parent instanceof ForEachStatement || parent instanceof SwitchCase || parent instanceof WhileStatement) {
                this.decreaseConditionalLevel();
            }
            return this.visitGeneral((ASTNode)s);
        }

        public boolean endvisit(Expression e) throws Exception {
            if (e instanceof Block) {
                return this.endvisit((Block)e);
            }
            ASTNode parent = this.nodesStack.peek();
            if (parent instanceof ConditionalExpression) {
                this.decreaseConditionalLevel();
            }
            this.endvisitGeneral((ASTNode)e);
            return true;
        }

        public boolean visit(TypeDeclaration node) throws Exception {
            return false;
        }

        public boolean visit(MethodDeclaration node) throws Exception {
            if (this.nodesStack.isEmpty()) {
                return this.visitGeneral((ASTNode)node);
            }
            return false;
        }

        public boolean visitGeneral(ASTNode node) throws Exception {
            this.nodesStack.push(node);
            return this.shouldContinue(node);
        }

        public void endvisitGeneral(ASTNode node) throws Exception {
            this.nodesStack.pop();
        }

        private boolean shouldContinue(ASTNode node) {
            return node.sourceStart() < this.variableOffset;
        }
    }
}

