/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference.evaluators.phpdoc;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.ti.GoalState;
import org.eclipse.dltk.ti.InstanceContext;
import org.eclipse.dltk.ti.goals.IGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocTag;
import org.eclipse.php.internal.core.mixin.PHPDocField;
import org.eclipse.php.internal.core.mixin.PHPMixinModel;
import org.eclipse.php.internal.core.typeinference.PHPClassType;
import org.eclipse.php.internal.core.typeinference.PHPSimpleTypes;
import org.eclipse.php.internal.core.typeinference.PHPTypeInferenceUtils;
import org.eclipse.php.internal.core.typeinference.evaluators.AbstractPHPGoalEvaluator;
import org.eclipse.php.internal.core.typeinference.goals.phpdoc.PHPDocClassVariableGoal;

public class PHPDocClassVariableEvaluator
extends AbstractPHPGoalEvaluator {
    private List<IEvaluatedType> evaluated = new LinkedList<IEvaluatedType>();

    public PHPDocClassVariableEvaluator(IGoal goal) {
        super(goal);
    }

    public IGoal[] init() {
        PHPDocClassVariableGoal typedGoal = (PHPDocClassVariableGoal)this.goal;
        InstanceContext context = (InstanceContext)typedGoal.getContext();
        String variableName = typedGoal.getVariableName();
        IType[] types = this.getTypes(context.getInstanceType(), context.getSourceModule());
        HashSet<PHPDocField> docs = new HashSet<PHPDocField>();
        IType[] iTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IModelElement[] elements;
            IType type = iTypeArray[n2];
            IModelElement[] iModelElementArray = elements = PHPMixinModel.getInstance(type.getScriptProject()).getVariableDoc(variableName, null, type.getElementName());
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IModelElement e = iModelElementArray[n4];
                docs.add((PHPDocField)e);
                ++n4;
            }
            ++n2;
        }
        for (PHPDocField doc : docs) {
            PHPDocBlock docBlock = doc.getDocBlock();
            PHPDocTag[] pHPDocTagArray = docBlock.getTags();
            int n5 = pHPDocTagArray.length;
            int n6 = 0;
            while (n6 < n5) {
                PHPDocTag tag = pHPDocTagArray[n6];
                if (tag.getTagKind() == 12) {
                    SimpleReference[] references;
                    SimpleReference[] simpleReferenceArray = references = tag.getReferences();
                    int n7 = references.length;
                    int n8 = 0;
                    while (n8 < n7) {
                        SimpleReference ref = simpleReferenceArray[n8];
                        Object type = PHPSimpleTypes.fromString(ref.getName());
                        if (type == null) {
                            type = new PHPClassType(ref.getName());
                        }
                        this.evaluated.add((IEvaluatedType)type);
                        ++n8;
                    }
                }
                ++n6;
            }
        }
        return IGoal.NO_GOALS;
    }

    public Object produceResult() {
        return PHPTypeInferenceUtils.combineTypes(this.evaluated);
    }

    public IGoal[] subGoalDone(IGoal subgoal, Object result, GoalState state) {
        if (state != GoalState.RECURSIVE && result != null) {
            this.evaluated.add((IEvaluatedType)result);
        }
        return IGoal.NO_GOALS;
    }
}

