/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference.evaluators.phpdoc;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.evaluation.types.AmbiguousType;
import org.eclipse.dltk.ti.GoalState;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.InstanceContext;
import org.eclipse.dltk.ti.goals.GoalEvaluator;
import org.eclipse.dltk.ti.goals.IGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.internal.core.mixin.PHPDocField;
import org.eclipse.php.internal.core.mixin.PHPMixinModel;
import org.eclipse.php.internal.core.typeinference.PHPClassType;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.typeinference.PHPSimpleTypes;
import org.eclipse.php.internal.core.typeinference.PHPTypeInferenceUtils;
import org.eclipse.php.internal.core.typeinference.goals.phpdoc.PHPDocMethodReturnTypeGoal;

public class PHPDocMethodReturnTypeEvaluator
extends GoalEvaluator {
    private static final Pattern PIPE_PATTERN = Pattern.compile("\\|");
    private final List<IEvaluatedType> evaluated = new LinkedList<IEvaluatedType>();

    public PHPDocMethodReturnTypeEvaluator(IGoal goal) {
        super(goal);
    }

    public IGoal[] init() {
        Object[] objectArray;
        PHPDocMethodReturnTypeGoal typedGoal = (PHPDocMethodReturnTypeGoal)this.goal;
        IContext context = this.goal.getContext();
        String methodName = typedGoal.getMethodName();
        InstanceContext typedGontext = (InstanceContext)context;
        IEvaluatedType instanceType = typedGontext.getInstanceType();
        HashSet<PHPDocField> docs = new HashSet<PHPDocField>();
        if (instanceType instanceof PHPClassType || instanceType instanceof AmbiguousType) {
            Object classType;
            int n;
            LinkedList<IType> types = new LinkedList<IType>();
            if (instanceType instanceof AmbiguousType) {
                AmbiguousType ambiguousType = (AmbiguousType)instanceType;
                IScriptProject scriptProject = typedGontext.getSourceModule().getScriptProject();
                IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)scriptProject);
                objectArray = ambiguousType.getPossibleTypes();
                n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IEvaluatedType type = objectArray[n2];
                    if (type instanceof PHPClassType) {
                        IModelElement[] classes;
                        classType = (PHPClassType)type;
                        IModelElement[] iModelElementArray = classes = PHPMixinModel.getInstance(scriptProject).getType(((PHPClassType)((Object)classType)).getTypeName(), scope);
                        int n3 = classes.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IModelElement c = iModelElementArray[n4];
                            types.add((IType)c);
                            ++n4;
                        }
                    }
                    ++n2;
                }
            } else {
                IScriptProject scriptProject = typedGontext.getSourceModule().getScriptProject();
                IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)scriptProject);
                PHPClassType classType2 = (PHPClassType)instanceType;
                IModelElement[] classes = PHPMixinModel.getInstance(scriptProject).getType(classType2.getTypeName(), scope);
                classType = classes;
                int n5 = classes.length;
                n = 0;
                while (n < n5) {
                    IModelElement c = classType[n];
                    types.add((IType)c);
                    ++n;
                }
            }
            for (IType type : types) {
                try {
                    PHPDocField[] pHPDocFieldArray = PHPModelUtils.getClassMethodDoc(type, methodName, null);
                    int n6 = pHPDocFieldArray.length;
                    int classes = 0;
                    while (classes < n6) {
                        PHPDocField doc = pHPDocFieldArray[classes];
                        docs.add(doc);
                        ++classes;
                    }
                }
                catch (CoreException e) {
                    if (!DLTKCore.DEBUG) continue;
                    e.printStackTrace();
                }
            }
        } else {
            IModelElement[] elements;
            IScriptProject scriptProject = typedGontext.getSourceModule().getScriptProject();
            IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)scriptProject);
            IModelElement[] iModelElementArray = elements = PHPMixinModel.getInstance(scriptProject).getFunctionDoc(methodName, scope);
            int n = elements.length;
            int classes = 0;
            while (classes < n) {
                IModelElement e = iModelElementArray[classes];
                docs.add((PHPDocField)e);
                ++classes;
            }
        }
        PHPDocField docFromSameFile = null;
        for (PHPDocField doc : docs) {
            if (!doc.getSourceModule().equals(typedGontext.getSourceModule())) continue;
            docFromSameFile = doc;
            break;
        }
        if (docFromSameFile != null) {
            docs.clear();
            docs.add(docFromSameFile);
        }
        for (PHPDocField doc : docs) {
            PHPDocBlock docBlock = doc.getDocBlock();
            objectArray = docBlock.getTags();
            int n = objectArray.length;
            int n7 = 0;
            while (n7 < n) {
                IEvaluatedType tag = objectArray[n7];
                if (tag.getTagKind() == 6) {
                    SimpleReference[] simpleReferenceArray = tag.getReferences();
                    int n8 = simpleReferenceArray.length;
                    int n9 = 0;
                    while (n9 < n8) {
                        String[] types;
                        SimpleReference reference = simpleReferenceArray[n9];
                        String[] stringArray = types = PIPE_PATTERN.split(reference.getName());
                        int n10 = types.length;
                        int n11 = 0;
                        while (n11 < n10) {
                            String typeName = stringArray[n11];
                            Object type = PHPSimpleTypes.fromString(typeName);
                            if (type == null) {
                                type = new PHPClassType(typeName);
                            }
                            this.evaluated.add((IEvaluatedType)type);
                            ++n11;
                        }
                        ++n9;
                    }
                }
                ++n7;
            }
        }
        return IGoal.NO_GOALS;
    }

    public Object produceResult() {
        return PHPTypeInferenceUtils.combineTypes(this.evaluated);
    }

    public IGoal[] subGoalDone(IGoal subgoal, Object result, GoalState state) {
        return IGoal.NO_GOALS;
    }
}

