/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.util;

import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.Argument;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.evaluation.types.UnknownType;
import org.eclipse.dltk.ti.BasicContext;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.ISourceModuleContext;
import org.eclipse.dltk.ti.InstanceContext;
import org.eclipse.dltk.ti.goals.AbstractTypeGoal;
import org.eclipse.dltk.ti.goals.ExpressionTypeGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.typeinference.MethodContext;
import org.eclipse.php.internal.core.typeinference.PHPClassType;
import org.eclipse.php.internal.core.typeinference.PHPTypeInferenceUtils;
import org.eclipse.php.internal.core.typeinference.PHPTypeInferencer;

public class ModelElementResolver {
    public static IModelElement[] resolve(ISourceModule sourceModule, int offset) {
        IModelElement[] modelElements = null;
        ContextFinder visitor = new ContextFinder(sourceModule, offset);
        ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
        try {
            moduleDeclaration.traverse((ASTVisitor)visitor);
        }
        catch (Exception e) {
            Logger.logException(e);
        }
        if (visitor.getNode() != null) {
            PHPTypeInferencer typeInferencer = new PHPTypeInferencer();
            IEvaluatedType evaluatedType = typeInferencer.evaluateType((AbstractTypeGoal)new ExpressionTypeGoal(visitor.getContext(), visitor.getNode()));
            modelElements = PHPTypeInferenceUtils.getModelElements(evaluatedType, (ISourceModuleContext)((BasicContext)visitor.getContext()));
        }
        return modelElements;
    }

    private static class ContextFinder
    extends ASTVisitor {
        private IContext context;
        private ASTNode node;
        private Stack<IContext> contextStack = new Stack();
        private int offset;
        private ISourceModule sourceModule;

        public ContextFinder(ISourceModule sourceModule, int offset) {
            this.offset = offset;
            this.sourceModule = sourceModule;
        }

        public IContext getContext() {
            return this.context;
        }

        public ASTNode getNode() {
            return this.node;
        }

        public boolean visitGeneral(ASTNode node) throws Exception {
            if (node.sourceEnd() < this.offset || node.sourceStart() > this.offset) {
                return false;
            }
            if (node.sourceStart() <= this.offset && node.sourceEnd() >= this.offset && !this.contextStack.isEmpty()) {
                this.context = this.contextStack.peek();
                this.node = node;
            }
            return true;
        }

        public boolean visit(ModuleDeclaration node) throws Exception {
            this.contextStack.push((IContext)new BasicContext(this.sourceModule, node));
            return this.visitGeneral((ASTNode)node);
        }

        public boolean visit(TypeDeclaration node) throws Exception {
            this.contextStack.push((IContext)new InstanceContext((ISourceModuleContext)this.contextStack.peek(), (IEvaluatedType)new PHPClassType(node.getName())));
            return this.visitGeneral((ASTNode)node);
        }

        public boolean visit(MethodDeclaration node) throws Exception {
            LinkedList<String> argumentsList = new LinkedList<String>();
            LinkedList<IEvaluatedType> argTypes = new LinkedList<IEvaluatedType>();
            List args = node.getArguments();
            for (Argument a : args) {
                argumentsList.add(a.getName());
                argTypes.add(UnknownType.INSTANCE);
            }
            IContext parent = this.contextStack.peek();
            ModuleDeclaration rootNode = ((ISourceModuleContext)parent).getRootNode();
            this.contextStack.push(new MethodContext(parent, this.sourceModule, rootNode, node, argumentsList.toArray(new String[argumentsList.size()]), argTypes.toArray(new IEvaluatedType[argTypes.size()])));
            return this.visitGeneral((ASTNode)node);
        }

        public boolean endvisit(ModuleDeclaration node) throws Exception {
            this.contextStack.pop();
            this.endvisitGeneral((ASTNode)node);
            return true;
        }

        public boolean endvisit(TypeDeclaration node) throws Exception {
            this.contextStack.pop();
            this.endvisitGeneral((ASTNode)node);
            return true;
        }

        public boolean endvisit(MethodDeclaration node) throws Exception {
            this.contextStack.pop();
            this.endvisitGeneral((ASTNode)node);
            return true;
        }
    }
}

