/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.console;

import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.php.internal.core.PHPLanguageToolkit;
import org.eclipse.php.internal.debug.ui.PHPDebugUIPlugin;
import org.eclipse.php.internal.debug.ui.console.PHPConsoleSourceModuleLookup;
import org.eclipse.php.internal.ui.util.EditorUtility;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.ide.IDE;

public class PHPFileLink
implements IHyperlink {
    protected String fileName;
    protected int lineNumber;

    public PHPFileLink(String fileName, int lineNumber) {
        this.fileName = fileName;
        this.lineNumber = lineNumber;
    }

    public void linkActivated() {
        Object element = PHPFileLink.findSourceModule(this.fileName);
        if (element == null) {
            MessageDialog.openInformation((Shell)PHPDebugUIPlugin.getActiveWorkbenchShell(), (String)"Information", (String)MessageFormat.format("Source not found for {0}", this.fileName));
            return;
        }
        this.openElementInEditor(element);
    }

    protected void openElementInEditor(Object element) {
        Assert.isNotNull((Object)element);
        IEditorInput input = EditorUtility.getEditorInput((Object)element);
        if (input == null) {
            return;
        }
        try {
            IEditorDescriptor descriptor = IDE.getEditorDescriptor((String)input.getName());
            IWorkbenchPage page = PHPDebugUIPlugin.getActivePage();
            IEditorPart editor = page.openEditor(input, descriptor.getId());
            EditorUtility.revealInEditor((IEditorPart)editor, (int)this.lineNumber);
        }
        catch (PartInitException e) {
            PHPDebugUIPlugin.log(e);
        }
    }

    public static Object findSourceModule(String fileName) {
        IPath path = Path.fromOSString((String)fileName);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile f = root.getFileForLocation(path);
        if (f != null) {
            return f;
        }
        IDLTKLanguageToolkit toolkit = PHPLanguageToolkit.getDefault();
        PHPConsoleSourceModuleLookup lookup = new PHPConsoleSourceModuleLookup(toolkit);
        return lookup.findSourceModuleByLocalPath(path);
    }

    public void linkEntered() {
    }

    public void linkExited() {
    }
}

