/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.launching;

import com.ibm.icu.text.MessageFormat;
import java.io.IOException;
import java.net.URI;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.BuildpathContainerInitializer;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IAccessRule;
import org.eclipse.dltk.core.IBuildpathAttribute;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.internal.launching.DLTKLaunchingPlugin;
import org.eclipse.dltk.launching.IRuntimeBuildpathEntry;
import org.eclipse.dltk.launching.LaunchingMessages;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RuntimeBuildpathEntry
implements IRuntimeBuildpathEntry {
    private int fType = -1;
    private int fBuildpathProperty = -1;
    private IBuildpathEntry fBuildpathEntry = null;
    private IScriptProject fProject = null;
    private IPath fInvalidPath;

    public RuntimeBuildpathEntry(IBuildpathEntry entry) {
        switch (entry.getEntryKind()) {
            case 2: {
                this.setType(1);
                break;
            }
            case 1: {
                this.setType(2);
                break;
            }
            case 3: {
                this.setType(3);
                break;
            }
            default: {
                throw new IllegalArgumentException(MessageFormat.format((String)LaunchingMessages.RuntimeBuildpathEntry_Illegal_classpath_entry__0__1, (Object[])new String[]{entry.toString()}));
            }
        }
        this.setBuildpathEntry(entry);
        this.initializeBuildpathProperty();
    }

    public RuntimeBuildpathEntry(IBuildpathEntry entry, int buildpathProperty) {
        switch (entry.getEntryKind()) {
            case 5: {
                this.setType(4);
                break;
            }
            default: {
                throw new IllegalArgumentException(MessageFormat.format((String)LaunchingMessages.RuntimeBuildpathEntry_Illegal_classpath_entry__0__1, (Object[])new String[]{entry.toString()}));
            }
        }
        this.setBuildpathEntry(entry);
        this.setBuildpathProperty(buildpathProperty);
    }

    public RuntimeBuildpathEntry(Element root) throws CoreException {
        String name;
        try {
            this.setType(Integer.parseInt(root.getAttribute("type")));
        }
        catch (NumberFormatException e) {
            this.abort(LaunchingMessages.RuntimeBuildpathEntry_Unable_to_recover_runtime_class_path_entry_type_2, e);
        }
        try {
            this.setBuildpathProperty(Integer.parseInt(root.getAttribute("path")));
        }
        catch (NumberFormatException e) {
            this.abort(LaunchingMessages.RuntimeBuildpathEntry_Unable_to_recover_runtime_class_path_entry_location_3, e);
        }
        switch (this.getType()) {
            case 1: {
                name = root.getAttribute("projectName");
                if (this.isEmpty(name)) {
                    this.abort(LaunchingMessages.RuntimeBuildpathEntry_Unable_to_recover_runtime_class_path_entry___missing_project_name_4, null);
                    break;
                }
                IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
                this.setBuildpathEntry(DLTKCore.newProjectEntry((IPath)proj.getFullPath()));
                break;
            }
            case 2: {
                String path = root.getAttribute("externalArchive");
                if (this.isEmpty(path)) {
                    path = root.getAttribute("internalArchive");
                    if (this.isEmpty(path)) {
                        this.abort(LaunchingMessages.RuntimeBuildpathEntry_Unable_to_recover_runtime_class_path_entry___missing_archive_path_5, null);
                        break;
                    }
                    this.setBuildpathEntry(this.createLibraryEntry(path));
                    break;
                }
                this.setBuildpathEntry(this.createLibraryEntry(path));
                break;
            }
            case 4: {
                String var = root.getAttribute("containerPath");
                if (this.isEmpty(var)) {
                    this.abort(LaunchingMessages.RuntimeBuildpathEntry_Unable_to_recover_runtime_class_path_entry___missing_variable_name_6, null);
                    break;
                }
                this.setBuildpathEntry(DLTKCore.newContainerEntry((IPath)new Path(var)));
            }
        }
        name = root.getAttribute("scriptProject");
        if (this.isEmpty(name)) {
            this.fProject = null;
        } else {
            IProject project2 = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
            this.fProject = DLTKCore.create((IProject)project2);
        }
    }

    private IBuildpathEntry createLibraryEntry(String path) {
        Path p = new Path(path);
        if (!p.isAbsolute()) {
            this.fInvalidPath = p;
            return null;
        }
        return DLTKCore.newLibraryEntry((IPath)p);
    }

    protected void abort(String message, Throwable e) throws CoreException {
        Status s = new Status(4, DLTKLaunchingPlugin.getUniqueIdentifier(), 100, message, e);
        throw new CoreException((IStatus)s);
    }

    public int getType() {
        return this.fType;
    }

    private void setType(int type) {
        this.fType = type;
    }

    private void setBuildpathEntry(IBuildpathEntry entry) {
        this.fBuildpathEntry = entry;
    }

    public IBuildpathEntry getBuildpathEntry() {
        return this.fBuildpathEntry;
    }

    public String getMemento() throws CoreException {
        Document doc;
        try {
            doc = DLTKLaunchingPlugin.getDocument();
        }
        catch (ParserConfigurationException e) {
            Status status = new Status(4, DLTKLaunchingPlugin.getUniqueIdentifier(), 100, LaunchingMessages.RuntimeBuildpathEntry_An_exception_occurred_generating_runtime_classpath_memento_8, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        Element node = doc.createElement("runtimeBuildpathEntry");
        doc.appendChild(node);
        node.setAttribute("type", new Integer(this.getType()).toString());
        node.setAttribute("path", new Integer(this.getBuildpathProperty()).toString());
        switch (this.getType()) {
            case 1: {
                node.setAttribute("projectName", this.getPath().lastSegment());
                break;
            }
            case 2: {
                IResource res = this.getResource();
                if (res == null) {
                    node.setAttribute("externalArchive", this.getPath().toString());
                    break;
                }
                node.setAttribute("internalArchive", res.getFullPath().toString());
                break;
            }
            case 4: {
                node.setAttribute("containerPath", this.getPath().toString());
            }
        }
        if (this.getScriptProject() != null) {
            node.setAttribute("scriptProject", this.getScriptProject().getElementName());
        }
        try {
            return DLTKLaunchingPlugin.serializeDocument(doc);
        }
        catch (IOException e) {
            Status status = new Status(4, DLTKLaunchingPlugin.getUniqueIdentifier(), 100, LaunchingMessages.RuntimeBuildpathEntry_An_exception_occurred_generating_runtime_classpath_memento_8, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        catch (TransformerException e) {
            Status status = new Status(4, DLTKLaunchingPlugin.getUniqueIdentifier(), 100, LaunchingMessages.RuntimeBuildpathEntry_An_exception_occurred_generating_runtime_classpath_memento_8, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    public IPath getPath() {
        IBuildpathEntry entry = this.getBuildpathEntry();
        return entry != null ? entry.getPath() : this.fInvalidPath;
    }

    public IResource getResource() {
        switch (this.getType()) {
            case 4: {
                return null;
            }
        }
        return this.getResource(this.getPath());
    }

    protected IResource getResource(IPath path) {
        if (path != null) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            if (path.getDevice() == null) {
                return root.findMember(path);
            }
            IFile[] files = root.findFilesForLocation(path);
            if (files.length > 0) {
                return files[0];
            }
            IContainer[] containers = root.findContainersForLocation(path);
            if (containers.length > 0) {
                return containers[0];
            }
        }
        return null;
    }

    private void initializeBuildpathProperty() {
        switch (this.getType()) {
            case 1: 
            case 2: 
            case 3: {
                this.setBuildpathProperty(3);
                break;
            }
        }
    }

    public void setBuildpathProperty(int location) {
        this.fBuildpathProperty = location;
    }

    public int getBuildpathProperty() {
        return this.fBuildpathProperty;
    }

    public String getLocation() {
        IPath path = null;
        switch (this.getType()) {
            case 1: {
                IScriptProject pro = (IScriptProject)DLTKCore.create((IResource)this.getResource());
                if (pro == null) break;
                path = pro.getPath();
                break;
            }
            case 2: {
                path = this.getPath();
                break;
            }
            case 3: {
                path = this.getPath();
                break;
            }
        }
        return this.resolvePath(path).toPortableString();
    }

    protected IPath resolvePath(IPath path) {
        if (path != null) {
            IResource res = null;
            if (path.getDevice() == null) {
                res = this.getResource(path);
            }
            if (res == null) {
                return path;
            }
            URI locationURI = res.getLocationURI();
            if (locationURI != null) {
                return new Path(locationURI.getPath());
            }
            IPath location = res.getLocation();
            if (location != null) {
                return location;
            }
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IRuntimeBuildpathEntry) {
            IRuntimeBuildpathEntry r = (IRuntimeBuildpathEntry)obj;
            if (this.getType() == r.getType() && this.getBuildpathProperty() == r.getBuildpathProperty() && this.getType() == 4) {
                String id = this.getPath().segment(0);
                BuildpathContainerInitializer initializer = DLTKCore.getBuildpathContainerInitializer((String)id);
                IScriptProject scriptProject1 = this.getScriptProject();
                IScriptProject scriptProject2 = r.getScriptProject();
                if (initializer == null || scriptProject1 == null || scriptProject2 == null) {
                    return this.getPath().equals((Object)r.getPath());
                }
                Object comparisonID1 = initializer.getComparisonID(this.getPath(), scriptProject1);
                Object comparisonID2 = initializer.getComparisonID(r.getPath(), scriptProject2);
                return comparisonID1.equals(comparisonID2);
            }
        }
        return false;
    }

    protected boolean equal(Object one, Object two) {
        if (one == null) {
            return two == null;
        }
        return one.equals(two);
    }

    public int hashCode() {
        if (this.getType() == 4) {
            return this.getPath().segment(0).hashCode() + this.getType();
        }
        return this.getPath().hashCode() + this.getType();
    }

    protected void updateBuildpathEntry(IPath path) {
        IBuildpathEntry entry = null;
        IBuildpathEntry original = this.getBuildpathEntry();
        switch (this.getType()) {
            case 2: {
                entry = DLTKCore.newLibraryEntry((IPath)path, (IAccessRule[])original.getAccessRules(), (IBuildpathAttribute[])original.getExtraAttributes(), (boolean)original.isExported(), (boolean)original.isExternal());
                break;
            }
            default: {
                return;
            }
        }
        this.setBuildpathEntry(entry);
    }

    protected boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public String toString() {
        if (this.fBuildpathEntry != null) {
            return this.fBuildpathEntry.toString();
        }
        return super.toString();
    }

    public IScriptProject getScriptProject() {
        return this.fProject;
    }

    public void setScriptProject(IScriptProject project) {
        this.fProject = project;
    }

    public String getContainerName() {
        if (this.getType() == 4) {
            return this.getPath().segment(0);
        }
        return null;
    }
}

