/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.ui.text.MatchFilter;
import org.eclipse.search2.internal.ui.MatchFilterSelectionDialog;
import org.eclipse.search2.internal.ui.SearchMessages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class MatchFilterSelectionDialog
extends StatusDialog {
    private final boolean fShowLimitConfigurationControls;
    private final MatchFilter[] fAllFilters;
    private MatchFilter[] fEnabledFilters;
    private CheckboxTableViewer fListViewer;
    private Button fLimitElementsCheckbox;
    private Text fLimitElementsField;
    private Text fDescription;
    private int fLimitElementCount;
    private int fLastLimit;
    private final boolean fEnableMatchFilterConfiguration;

    public MatchFilterSelectionDialog(Shell shell, boolean enableMatchFilterConfiguration, MatchFilter[] allFilters, MatchFilter[] selectedFilters, boolean enableLimitConfiguration, int limit) {
        super(shell);
        this.setTitle(SearchMessages.MatchFilterSelectionDialog_label);
        this.setStatusLineAboveButtons(true);
        this.fShowLimitConfigurationControls = enableLimitConfiguration;
        this.fEnableMatchFilterConfiguration = enableMatchFilterConfiguration;
        this.fAllFilters = allFilters;
        this.fEnabledFilters = selectedFilters;
        this.fLimitElementCount = limit;
        this.fLastLimit = limit != -1 ? limit : 1000;
    }

    protected boolean isResizable() {
        return true;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        String name = "MatchFilterSelectionDialog_" + String.valueOf(this.fShowLimitConfigurationControls) + '.' + String.valueOf(this.fEnableMatchFilterConfiguration);
        return SearchPlugin.getDefault().getDialogSettingsSection(name);
    }

    public MatchFilter[] getMatchFilters() {
        return this.fEnabledFilters;
    }

    public int getLimit() {
        return this.fLimitElementCount;
    }

    protected Control createDialogArea(Composite composite) {
        Composite parent = (Composite)super.createDialogArea(composite);
        this.initializeDialogUnits((Control)composite);
        if (this.fShowLimitConfigurationControls) {
            this.createTableLimit(parent);
        }
        if (this.fEnableMatchFilterConfiguration) {
            this.createMatchFilterControls(parent);
        }
        return parent;
    }

    private void createMatchFilterControls(Composite parent) {
        Label l = new Label(parent, 0);
        l.setFont(parent.getFont());
        l.setText(SearchMessages.MatchFilterSelectionDialog_filter_description);
        Table table = new Table(parent, 2080);
        table.setFont(parent.getFont());
        this.fListViewer = new CheckboxTableViewer(table);
        GridData data = new GridData(1808);
        data.minimumHeight = this.convertHeightInCharsToPixels(8);
        table.setLayoutData((Object)data);
        class ListenerAndLabelProvider
        extends LabelProvider
        implements ISelectionChangedListener,
        ICheckStateListener {
            final /* synthetic */ MatchFilterSelectionDialog this$0;

            ListenerAndLabelProvider(MatchFilterSelectionDialog matchFilterSelectionDialog) {
                this.this$0 = matchFilterSelectionDialog;
            }

            public void selectionChanged(SelectionChangedEvent event) {
                MatchFilterSelectionDialog.access$0(this.this$0);
            }

            public void checkStateChanged(CheckStateChangedEvent event) {
                MatchFilterSelectionDialog.access$1(this.this$0);
            }

            public String getText(Object element) {
                return ((MatchFilter)element).getName();
            }
        }
        ListenerAndLabelProvider listenerAndLP = new ListenerAndLabelProvider(this);
        this.fListViewer.setLabelProvider((IBaseLabelProvider)listenerAndLP);
        this.fListViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fListViewer.addSelectionChangedListener((ISelectionChangedListener)listenerAndLP);
        this.fListViewer.addCheckStateListener((ICheckStateListener)listenerAndLP);
        this.fListViewer.setInput((Object)this.fAllFilters);
        this.fListViewer.setCheckedElements((Object[])this.fEnabledFilters);
        l = new Label(parent, 0);
        l.setFont(parent.getFont());
        l.setText(SearchMessages.MatchFilterSelectionDialog_description_label);
        this.fDescription = new Text(parent, 19018);
        this.fDescription.setFont(parent.getFont());
        data = new GridData(768);
        data.heightHint = this.convertHeightInCharsToPixels(3);
        this.fDescription.setLayoutData((Object)data);
    }

    private void createTableLimit(Composite ancestor) {
        Composite parent = new Composite(ancestor, 0);
        parent.setFont(ancestor.getFont());
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        parent.setLayout((Layout)gl);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        parent.setLayoutData((Object)gd);
        this.fLimitElementsCheckbox = new Button(parent, 32);
        this.fLimitElementsCheckbox.setText(SearchMessages.MatchFilterSelectionDialog_limit_description);
        this.fLimitElementsCheckbox.setLayoutData((Object)new GridData());
        this.fLimitElementsCheckbox.setFont(parent.getFont());
        this.fLimitElementsField = new Text(parent, 2048);
        this.fLimitElementsField.setFont(parent.getFont());
        gd = new GridData();
        gd.widthHint = this.convertWidthInCharsToPixels(6);
        this.fLimitElementsField.setLayoutData((Object)gd);
        this.fLimitElementsCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MatchFilterSelectionDialog.this.performLimitCheckboxChanged();
            }
        });
        this.fLimitElementsField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MatchFilterSelectionDialog.this.performLimitTextModified();
            }
        });
        this.fLimitElementsCheckbox.setSelection(this.fLimitElementCount != -1);
        this.fLimitElementsField.setText(String.valueOf(this.fLastLimit));
        this.fLimitElementsField.setEnabled(this.fLimitElementsCheckbox.getSelection());
    }

    private void performFilterListSelectionChanged() {
        Object selectedElement = ((IStructuredSelection)this.fListViewer.getSelection()).getFirstElement();
        if (selectedElement != null) {
            this.fDescription.setText(((MatchFilter)selectedElement).getDescription());
        } else {
            this.fDescription.setText(new String());
        }
    }

    private void performFilterListCheckStateChanged() {
        Object[] checked = this.fListViewer.getCheckedElements();
        this.fEnabledFilters = new MatchFilter[checked.length];
        System.arraycopy(checked, 0, this.fEnabledFilters, 0, checked.length);
    }

    private void performLimitCheckboxChanged() {
        this.fLimitElementsField.setEnabled(this.fLimitElementsCheckbox.getSelection());
        this.fLimitElementCount = this.fLimitElementsCheckbox.getSelection() ? this.fLastLimit : -1;
        this.performLimitTextModified();
    }

    private void performLimitTextModified() {
        String text = this.fLimitElementsField.getText();
        int value = -1;
        try {
            value = Integer.valueOf(text);
        }
        catch (NumberFormatException numberFormatException) {}
        this.fLimitElementCount = value;
        if (this.fLimitElementsCheckbox.getSelection() && value <= 0) {
            this.updateStatus(this.createStatus(4, SearchMessages.MatchFilterSelectionDialog_error_invalid_limit));
        } else {
            this.updateStatus(this.createStatus(0, ""));
        }
    }

    private IStatus createStatus(int severity, String message) {
        return new Status(severity, "org.eclipse.search", severity, message, null);
    }

    static /* synthetic */ void access$0(MatchFilterSelectionDialog matchFilterSelectionDialog) {
        matchFilterSelectionDialog.performFilterListSelectionChanged();
    }

    static /* synthetic */ void access$1(MatchFilterSelectionDialog matchFilterSelectionDialog) {
        matchFilterSelectionDialog.performFilterListCheckStateChanged();
    }
}

