/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.security.ui;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.internal.provisional.security.ui.AuthorizationManager;
import org.eclipse.equinox.internal.security.ui.Activator;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;

public class SecurityStatusControl
extends ControlContribution {
    private static final String IMAGE_PATH_OK = "/full/obj16/green.GIF";
    private static final String IMAGE_PATH_ERROR = "/full/obj16/red.GIF";
    private static final String IMAGE_PATH_DISABLED = "/full/obj16/red.GIF";
    private static final String IMAGE_PATH_UNKNOWN = "/full/obj16/red.GIF";
    private static final String ID = "org.eclipse.ui.securityStatus";
    private IWorkbenchWindow window;
    private CLabel label;
    private IconState currentState;

    public SecurityStatusControl(IWorkbenchWindow window) {
        this(window, ID);
    }

    public SecurityStatusControl(IWorkbenchWindow window, String id) {
        super(id);
        Assert.isNotNull((Object)window);
        this.window = window;
        this.currentState = SecurityStatusControl.getCurrentState();
    }

    private static IconState getCurrentState() {
        AuthorizationManager mgr = Activator.getAuthorizationManager();
        return new IconState(mgr.isEnabled(), mgr.getStatus(), mgr.needsAttention());
    }

    protected Control createControl(Composite parent) {
        this.label = new CLabel(parent, 0);
        this.label.setImage(SecurityStatusControl.getIcon(this.currentState));
        this.label.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        Job updateJob = new Job(ID){

            public IStatus run(IProgressMonitor monitor) {
                while (true) {
                    IconState newState = SecurityStatusControl.getCurrentState();
                    if (!SecurityStatusControl.this.currentState.equals(newState)) {
                        Display display = SecurityStatusControl.getDisplay(SecurityStatusControl.this.window);
                        if (display != null) {
                            display.asyncExec(new Runnable(this){
                                final /* synthetic */ 2 this$1;
                                {
                                    this.this$1 = var1_1;
                                }

                                public void run() {
                                    if (!SecurityStatusControl.access$4(2.access$0(this.this$1)).isDisposed()) {
                                        Image oldIcon = SecurityStatusControl.access$4(2.access$0(this.this$1)).getImage();
                                        SecurityStatusControl.access$4(2.access$0(this.this$1)).setImage(SecurityStatusControl.getIcon(SecurityStatusControl.access$1(2.access$0(this.this$1))));
                                        oldIcon.dispose();
                                    }
                                }
                            });
                        }
                        SecurityStatusControl.this.currentState = newState;
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        return null;
                    }
                }
            }

            static /* synthetic */ SecurityStatusControl access$0(2 var0) {
                return var0.SecurityStatusControl.this;
            }
        };
        updateJob.setSystem(true);
        updateJob.setPriority(50);
        updateJob.schedule();
        return this.label;
    }

    public void dispose() {
        Image currentImage = this.label.getImage();
        if (currentImage != null) {
            currentImage.dispose();
        }
        this.label.dispose();
    }

    protected static Image getIcon(IconState iconState) {
        Image returnValue = null;
        if (iconState.isEnabled()) {
            IStatus status = iconState.getStatus();
            ImageDescriptor imgDesc = null;
            switch (status.getSeverity()) {
                case 0: {
                    imgDesc = Activator.getImageDescriptor(IMAGE_PATH_OK);
                    break;
                }
                case 4: {
                    imgDesc = Activator.getImageDescriptor("/full/obj16/red.GIF");
                    break;
                }
                default: {
                    imgDesc = Activator.getImageDescriptor("/full/obj16/red.GIF");
                }
            }
            returnValue = imgDesc.createImage();
        } else {
            ImageDescriptor imgDesc = Activator.getImageDescriptor("/full/obj16/red.GIF");
            returnValue = imgDesc.createImage();
        }
        return returnValue;
    }

    private static Display getDisplay(IWorkbenchWindow window) {
        Shell shell;
        if (window != null && (shell = window.getShell()) != null) {
            return shell.getDisplay();
        }
        return null;
    }

    static /* synthetic */ CLabel access$4(SecurityStatusControl securityStatusControl) {
        return securityStatusControl.label;
    }

    private static class IconState {
        boolean enabled;
        boolean needsAttention;
        IStatus status;

        IconState(boolean enabled, IStatus status, boolean needsAttention) {
            if (status == null) {
                throw new IllegalArgumentException();
            }
            this.enabled = enabled;
            this.status = status;
            this.needsAttention = needsAttention;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public boolean needsAttention() {
            return this.needsAttention;
        }

        public IStatus getStatus() {
            return this.status;
        }

        public boolean equals(Object another) {
            boolean returnValue = false;
            if (another instanceof IconState && this.enabled == ((IconState)another).enabled && this.needsAttention == ((IconState)another).needsAttention && this.status.equals(((IconState)another).getStatus())) {
                returnValue = true;
            }
            return returnValue;
        }

        public int hashCode() {
            return Boolean.valueOf(this.enabled).hashCode() + this.status.hashCode() + Boolean.valueOf(this.needsAttention).hashCode();
        }
    }
}

