/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.security.ui.preferences;

import java.lang.reflect.Constructor;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.equinox.internal.security.ui.SecurityUIMsg;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.osgi.framework.Bundle;

public class AdvancedPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String ALG_ALIAS = "Alg.Alias.";
    private static final String PROVIDER = "Provider.";
    TreeViewer providerViewer;
    Combo providerCombo;
    Label versionText;
    Label descriptionText;
    private static final int TYPE_CLASSNAME = 3;
    private static final int TYPE_ALIASES = 4;
    private static final int TYPE_ATTRIBUTES = 5;

    public void init(IWorkbench workbench) {
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        Composite area = new Composite(parent, 0);
        area.setLayout((Layout)new FormLayout());
        Label providerLabel = new Label(area, 0);
        providerLabel.setText(SecurityUIMsg.ADVPAGE_LABEL_PROVIDER);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        providerLabel.setData((Object)data);
        this.providerCombo = new Combo(area, 12);
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment((Control)providerLabel, 0);
        data.width = 100;
        this.providerCombo.setLayoutData((Object)data);
        Provider[] providers = Security.getProviders();
        int i = 0;
        while (i < providers.length) {
            this.providerCombo.add(String.valueOf(i) + ": " + providers[i].getName());
            ++i;
        }
        this.providerCombo.setVisibleItemCount(providers.length);
        this.providerCombo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Provider provider = Security.getProviders()[AdvancedPage.this.providerCombo.getSelectionIndex()];
                AdvancedPage.this.providerViewer.setInput((Object)AdvancedPage.this.getContent(provider));
                AdvancedPage.this.versionText.setText(String.valueOf(provider.getVersion()));
                AdvancedPage.this.descriptionText.setText(provider.getInfo());
            }
        });
        Label versionLabel = new Label(area, 0);
        versionLabel.setText(SecurityUIMsg.ADVPAGE_LABEL_VERSION);
        data = new FormData();
        data.top = new FormAttachment((Control)this.providerCombo, 0);
        data.left = new FormAttachment(0, 0);
        versionLabel.setLayoutData((Object)data);
        this.versionText = new Label(area, 0);
        data = new FormData();
        data.top = new FormAttachment((Control)this.providerCombo, 0);
        data.left = new FormAttachment((Control)versionLabel, 0);
        data.right = new FormAttachment(100, 0);
        this.versionText.setLayoutData((Object)data);
        Label descriptionLabel = new Label(area, 0);
        descriptionLabel.setText(SecurityUIMsg.ADVPAGE_LABEL_DESCRIPTION);
        data = new FormData();
        data.top = new FormAttachment((Control)versionLabel, 0);
        data.left = new FormAttachment(0, 0);
        descriptionLabel.setLayoutData((Object)data);
        this.descriptionText = new Label(area, 0);
        data = new FormData();
        data.top = new FormAttachment((Control)this.versionText, 0);
        data.left = new FormAttachment((Control)versionLabel, 0);
        data.right = new FormAttachment(100, 0);
        data.width = 250;
        this.descriptionText.setLayoutData((Object)data);
        Group serviceGroup = new Group(area, 0);
        serviceGroup.setText(SecurityUIMsg.ADVPAGE_LABEL_SERVICES);
        data = new FormData();
        data.top = new FormAttachment((Control)descriptionLabel, 0);
        data.bottom = new FormAttachment(100, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        serviceGroup.setLayoutData((Object)data);
        serviceGroup.setLayout((Layout)new FormLayout());
        this.providerViewer = new TreeViewer((Composite)serviceGroup);
        this.providerViewer.setContentProvider((IContentProvider)new ProviderContentProvider());
        this.providerViewer.setLabelProvider((IBaseLabelProvider)new ProviderLabelProvider());
        Tree tree = (Tree)this.providerViewer.getControl();
        data = new FormData();
        data.top = new FormAttachment(0, 5);
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(100, -5);
        data.bottom = new FormAttachment(100, -5);
        data.height = 10 * tree.getItemHeight() + tree.getHeaderHeight();
        this.providerViewer.getControl().setLayoutData((Object)data);
        this.providerCombo.select(0);
        Provider provider = Security.getProviders()[0];
        this.providerViewer.setInput((Object)this.getContent(provider));
        this.versionText.setText(String.valueOf(provider.getVersion()));
        this.descriptionText.setText(provider.getInfo());
        return area;
    }

    Object[] getContent(Provider provider) {
        Set<Object> providerKeys = provider.keySet();
        Hashtable<String, Object> serviceList = new Hashtable<String, Object>();
        Hashtable<String, Hashtable<String, String>> attributeMap = new Hashtable<String, Hashtable<String, String>>();
        Hashtable<String, ArrayList<String>> aliasMap = new Hashtable<String, ArrayList<String>>();
        Iterator<Object> it = providerKeys.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (key.startsWith(PROVIDER)) continue;
            if (key.startsWith(ALG_ALIAS)) {
                String value = key.substring(key.indexOf(ALG_ALIAS) + ALG_ALIAS.length(), key.length());
                String type = (String)provider.get(key);
                String algo = value.substring(0, value.indexOf(46));
                String alias = value.substring(value.indexOf(46) + 1, value.length());
                ArrayList<String> aliasList = (ArrayList<String>)aliasMap.get(String.valueOf(type) + '.' + algo);
                if (aliasList == null) {
                    aliasList = new ArrayList<String>();
                    aliasList.add(alias);
                    aliasMap.put(type, aliasList);
                    continue;
                }
                aliasList.add(alias);
                continue;
            }
            if (key.indexOf(32) > -1) {
                String type = key.substring(0, key.indexOf(46));
                String algorithm = key.substring(key.indexOf(46) + 1, key.indexOf(32));
                String attribute = key.substring(key.indexOf(32) + 1, key.length());
                String value = (String)provider.get(key);
                Hashtable<String, String> attributeTable = (Hashtable<String, String>)attributeMap.get(String.valueOf(type) + '.' + algorithm);
                if (attributeTable == null) {
                    attributeTable = new Hashtable<String, String>();
                    attributeTable.put(attribute, value);
                    attributeMap.put(String.valueOf(type) + '.' + algorithm, attributeTable);
                    continue;
                }
                attributeTable.put(attribute, value);
                continue;
            }
            serviceList.put(key, provider.get(key));
        }
        Object[] serviceArray = new ProviderService[serviceList.size()];
        Set serviceKeys = serviceList.keySet();
        int serviceCount = 0;
        Iterator it2 = serviceKeys.iterator();
        while (it2.hasNext()) {
            String key = (String)it2.next();
            String type = key.substring(0, key.indexOf(46));
            String algo = key.substring(key.indexOf(46) + 1, key.length());
            String className = (String)serviceList.get(key);
            List aliases = (List)aliasMap.get(algo);
            Map attributes = (Map)attributeMap.get(key);
            serviceArray[serviceCount] = new ProviderService(type, algo, className, aliases, attributes, null);
            ++serviceCount;
        }
        Arrays.sort(serviceArray, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                ProviderService s0 = (ProviderService)arg0;
                ProviderService s1 = (ProviderService)arg1;
                return s0.getType().compareTo(s1.getType());
            }
        });
        return serviceArray;
    }

    class ProviderContentProvider
    implements ITreeContentProvider {
        ProviderContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Object[] returnValue = null;
            if (inputElement instanceof ProviderService[]) {
                returnValue = (Object[])inputElement;
            }
            return returnValue;
        }

        public Object getParent(Object element) {
            ProviderService returnValue = null;
            if (element instanceof ProviderServiceDetail) {
                returnValue = ((ProviderServiceDetail)element).getParent();
            }
            return returnValue;
        }

        public Object[] getChildren(Object parentElement) {
            Object[] returnValue = null;
            if (parentElement instanceof ProviderService) {
                ProviderService service = (ProviderService)parentElement;
                ArrayList<ProviderServiceDetail> detailList = new ArrayList<ProviderServiceDetail>();
                detailList.add(new ProviderServiceDetail(service, 3, service.getClassName()));
                if (service.getAliases() != null) {
                    detailList.add(new ProviderServiceDetail(service, 4, service.getAliases()));
                }
                if (service.getAttributes() != null) {
                    detailList.add(new ProviderServiceDetail(service, 5, service.getAttributes()));
                }
                returnValue = detailList.toArray(new ProviderServiceDetail[0]);
            } else if (parentElement instanceof ProviderServiceDetail) {
                returnValue = ((ProviderServiceDetail)parentElement).getChildren();
            }
            return returnValue;
        }

        public boolean hasChildren(Object element) {
            boolean returnValue = false;
            if (element instanceof ProviderService) {
                returnValue = true;
            } else if (element instanceof ProviderServiceDetail) {
                returnValue = ((ProviderServiceDetail)element).hasChildren();
            }
            return returnValue;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class ProviderLabelProvider
    implements ILabelProvider {
        ProviderLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            String returnValue = null;
            if (element instanceof String) {
                returnValue = (String)element;
            } else if (element instanceof ProviderService) {
                ProviderService service = (ProviderService)element;
                returnValue = String.valueOf(service.getType()) + ": " + service.getAlgorithm();
            } else if (element instanceof ProviderServiceDetail) {
                ProviderServiceDetail detail = (ProviderServiceDetail)element;
                returnValue = detail.toString();
            } else if (element instanceof ProviderServiceAttribute) {
                ProviderServiceAttribute attribute = (ProviderServiceAttribute)element;
                returnValue = attribute.toString();
            }
            return returnValue;
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }
    }

    private class ProviderService {
        private final String type;
        private final String algorithm;
        private final String className;
        private final List aliases;
        private final Map attributes;
        private final Bundle providingBundle;

        public ProviderService(String type, String algorithm, String className, List aliases, Map attributes, Bundle providingBundle) {
            this.type = type;
            this.algorithm = algorithm;
            this.className = className;
            this.aliases = aliases;
            this.attributes = attributes;
            this.providingBundle = providingBundle;
        }

        public String getType() {
            return this.type;
        }

        public String getAlgorithm() {
            return this.algorithm;
        }

        public String getClassName() {
            return this.className;
        }

        public List getAliases() {
            return this.aliases;
        }

        public Map getAttributes() {
            return this.attributes;
        }

        public Object newInstance(Object parameter) throws NoSuchAlgorithmException {
            Object obj;
            block5: {
                obj = null;
                try {
                    Class clazz = this.providingBundle.loadClass(this.getClassName());
                    if (parameter != null) {
                        try {
                            Constructor cons = clazz.getDeclaredConstructor(parameter.getClass());
                            obj = cons.newInstance(parameter);
                            break block5;
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            throw new InvalidParameterException();
                        }
                    }
                    obj = clazz.newInstance();
                }
                catch (Throwable throwable) {
                    throw new NoSuchAlgorithmException();
                }
            }
            return obj;
        }

        public boolean supportsParameter(Object parameter) {
            try {
                Class clazz = this.providingBundle.loadClass(this.getClassName());
                clazz.getDeclaredConstructor(parameter.getClass());
            }
            catch (Throwable throwable) {
                return false;
            }
            return true;
        }
    }

    private class ProviderServiceAttribute {
        String key;
        String value;

        public ProviderServiceAttribute(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.key) + ": " + this.value;
        }
    }

    private class ProviderServiceDetail {
        ProviderService parent;
        int type;
        Object data;

        ProviderServiceDetail(ProviderService parent, int type, Object data) {
            this.parent = parent;
            this.type = type;
            this.data = data;
        }

        int getType() {
            return this.type;
        }

        Object getData() {
            return this.data;
        }

        ProviderService getParent() {
            return this.parent;
        }

        public String toString() {
            String returnValue = null;
            switch (this.getType()) {
                case 3: {
                    returnValue = String.valueOf(SecurityUIMsg.ADVPAGE_LABEL_CLASS) + (String)this.getData();
                    break;
                }
                case 4: {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append(SecurityUIMsg.ADVPAGE_LABEL_ALIASES);
                    String[] aliases = ((List)this.getData()).toArray(new String[0]);
                    int i = 0;
                    while (i < aliases.length) {
                        buffer.append(aliases[i]);
                        if (i < aliases.length - 1) {
                            buffer.append(", ");
                        }
                        ++i;
                    }
                    returnValue = buffer.toString();
                    break;
                }
                case 5: {
                    returnValue = SecurityUIMsg.ADVPAGE_LABEL_ATTRIBUTES;
                }
            }
            return returnValue;
        }

        boolean hasChildren() {
            boolean returnValue = false;
            if (this.getType() == 5) {
                returnValue = true;
            }
            return returnValue;
        }

        Object[] getChildren() {
            Object[] returnValue = null;
            if (this.getType() == 5) {
                Map attributeMap = (Map)this.getData();
                ArrayList<ProviderServiceAttribute> attributeList = new ArrayList<ProviderServiceAttribute>();
                Iterator it = attributeMap.keySet().iterator();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    String value = (String)attributeMap.get(key);
                    attributeList.add(new ProviderServiceAttribute(key, value));
                }
                returnValue = attributeList.toArray(new ProviderServiceAttribute[0]);
            }
            return returnValue;
        }
    }
}

