/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.sourcelookup;

import java.text.MessageFormat;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.php.internal.debug.core.sourcelookup.PHPSourceNotFoundInput;
import org.eclipse.php.internal.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.internal.ui.containers.StorageEditorInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

public class PHPSourceNotFoundEditorInput
extends PlatformObject
implements IEditorInput {
    private IStackFrame fFrame;
    private String fFrameText;
    private String fTooltipText;

    public PHPSourceNotFoundEditorInput(PHPSourceNotFoundInput input) {
        this.fFrame = input.getStackFrame();
        IDebugModelPresentation pres = DebugUITools.newDebugModelPresentation((String)this.fFrame.getModelIdentifier());
        this.fFrameText = pres.getText((Object)this.fFrame);
        pres.dispose();
    }

    public PHPSourceNotFoundEditorInput(PHPSourceNotFoundInput input, String tooltipText) {
        this.fFrame = input.getStackFrame();
        IDebugModelPresentation pres = DebugUITools.newDebugModelPresentation((String)this.fFrame.getModelIdentifier());
        this.fFrameText = pres.getText((Object)this.fFrame);
        pres.dispose();
        this.fTooltipText = tooltipText;
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return DebugUITools.getDefaultImageDescriptor((Object)this.fFrame);
    }

    public String getName() {
        try {
            String fullName = this.fFrame.getName();
            String lastSegment = new Path(fullName).lastSegment();
            return lastSegment == null ? fullName : lastSegment;
        }
        catch (DebugException debugException) {
            return PHPDebugUIMessages.SourceNotFoundEditorInput_Source_Not_Found_1;
        }
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        if (this.fTooltipText == null) {
            return MessageFormat.format(PHPDebugUIMessages.SourceNotFoundEditorInput_Source_not_found_for__0__2, this.fFrameText);
        }
        return this.fTooltipText;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PHPSourceNotFoundEditorInput && this.fFrame != null) {
            return this.fFrame.equals(((PHPSourceNotFoundEditorInput)((Object)obj)).fFrame);
        }
        if (obj instanceof StorageEditorInput) {
            StorageEditorInput storageEditorInput = (StorageEditorInput)obj;
            String storageLocation = storageEditorInput.getStorage().getFullPath().toString();
            return storageLocation.equals(this.fFrameText);
        }
        return super.equals(obj);
    }
}

