/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.director;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.equinox.internal.p2.director.IUFilter;
import org.eclipse.equinox.internal.p2.director.Recommendation;
import org.eclipse.equinox.internal.p2.director.RecommendationDescriptor;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.ProvidedCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.RequiredCapability;
import org.eclipse.osgi.service.resolver.VersionRange;

public class Picker {
    private IInstallableUnit[] preferredSet;
    private IInstallableUnit[] completeSet;
    private IInstallableUnit[] secondChoiceSet;
    private RecommendationDescriptor recommendations;
    private List filters;

    public Picker(IInstallableUnit[] unitsToPickFrom, RecommendationDescriptor recommendations) {
        this.completeSet = unitsToPickFrom != null ? unitsToPickFrom : new IInstallableUnit[0];
        this.secondChoiceSet = this.completeSet;
        this.recommendations = recommendations;
        this.filters = new ArrayList(2);
    }

    public Collection[] findInstallableUnit(String id, VersionRange range, RequiredCapability searchedCapability) {
        IInstallableUnit[][] tmp = this.findInstallableUnit(id, range, new RequiredCapability[]{searchedCapability}, false);
        return new Collection[]{Arrays.asList(tmp[0]), Arrays.asList(tmp[1])};
    }

    public void prefer(Collection filtersToAdd) {
        if (!this.filters.addAll(filtersToAdd)) {
            return;
        }
        if (this.filters.size() == 0) {
            return;
        }
        HashSet<IInstallableUnit> preferredIUs = new HashSet<IInstallableUnit>(this.completeSet.length);
        HashSet<IInstallableUnit> secondChoice = new HashSet<IInstallableUnit>(this.completeSet.length);
        int i = 0;
        while (i < this.completeSet.length) {
            Iterator iterator = this.filters.iterator();
            while (iterator.hasNext()) {
                if (((IUFilter)iterator.next()).accept(this.completeSet[i])) {
                    preferredIUs.add(this.completeSet[i]);
                    continue;
                }
                secondChoice.add(this.completeSet[i]);
            }
            ++i;
        }
        this.preferredSet = preferredIUs.toArray(new IInstallableUnit[preferredIUs.size()]);
        this.secondChoiceSet = secondChoice.toArray(new IInstallableUnit[secondChoice.size()]);
    }

    public IInstallableUnit[][] findInstallableUnit(String id, VersionRange range, RequiredCapability[] searchedCapability, boolean fragmentsOnly) {
        return new IInstallableUnit[][]{this.findInstallableUnit(this.preferredSet, id, range, searchedCapability, fragmentsOnly), this.findInstallableUnit(this.secondChoiceSet, id, range, searchedCapability, fragmentsOnly)};
    }

    private IInstallableUnit[] findInstallableUnit(IInstallableUnit[] pool, String id, VersionRange range, RequiredCapability[] searchedCapability, boolean fragmentsOnly) {
        int i;
        if (pool == null || pool.length == 0) {
            return new IInstallableUnit[0];
        }
        HashSet<IInstallableUnit> candidates = new HashSet<IInstallableUnit>();
        if (id != null && range != null) {
            i = 0;
            while (i < pool.length) {
                if (pool[i].getId().equals(id) && range.isIncluded(pool[i].getVersion())) {
                    candidates.add(pool[i]);
                }
                ++i;
            }
            pool = candidates.toArray(new IInstallableUnit[candidates.size()]);
        }
        if (searchedCapability != null) {
            searchedCapability = this.rewrite(searchedCapability);
            i = 0;
            while (i < pool.length) {
                IInstallableUnit candidate = pool[i];
                int k = 0;
                while (k < searchedCapability.length) {
                    boolean valid = false;
                    ProvidedCapability[] capabilities = candidate.getProvidedCapabilities();
                    if (capabilities.length == 0) {
                        valid = false;
                    }
                    int j = 0;
                    while (j < capabilities.length) {
                        if (searchedCapability[k].getName().equals(capabilities[j].getName()) && searchedCapability[k].getNamespace().equals(capabilities[j].getNamespace()) && (searchedCapability[k].getRange() == null || searchedCapability[k].getRange().isIncluded(capabilities[j].getVersion()))) {
                            valid = true;
                            break;
                        }
                        ++j;
                    }
                    if (valid && (!fragmentsOnly || candidate.isFragment())) {
                        candidates.add(candidate);
                    }
                    ++k;
                }
                ++i;
            }
            pool = candidates.toArray(new IInstallableUnit[candidates.size()]);
        }
        return pool;
    }

    private RequiredCapability[] rewrite(RequiredCapability[] requiredCapabilities) {
        if (this.recommendations == null) {
            return requiredCapabilities;
        }
        RequiredCapability[] result = new RequiredCapability[requiredCapabilities.length];
        int i = 0;
        while (i < requiredCapabilities.length) {
            result[i] = this.getRecommendation(requiredCapabilities[i]);
            if (result[i] == null) {
                result[i] = requiredCapabilities[i];
            }
            ++i;
        }
        return result;
    }

    private RequiredCapability getRecommendation(RequiredCapability match) {
        Recommendation foundRecommendation = this.recommendations.findRecommendation(match);
        return foundRecommendation != null ? foundRecommendation.newValue() : match;
    }
}

