/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.engine;

import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.engine.EngineActivator;
import org.eclipse.equinox.internal.provisional.p2.core.IServiceUI;
import org.eclipse.equinox.internal.provisional.p2.engine.Messages;
import org.eclipse.osgi.service.security.TrustEngine;
import org.eclipse.osgi.signedcontent.SignedContent;
import org.eclipse.osgi.signedcontent.SignedContentFactory;
import org.eclipse.osgi.signedcontent.SignerInfo;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class CertificateChecker {
    private ArrayList artifacts = new ArrayList();
    private ServiceTracker trustEngineTracker;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public CertificateChecker() {
        BundleContext bundleContext = EngineActivator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.service.security.TrustEngine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.trustEngineTracker = new ServiceTracker(bundleContext, clazz.getName(), null);
        this.trustEngineTracker.open();
    }

    public IStatus start() {
        return this.checkCertificates();
    }

    private IStatus checkCertificates() {
        BundleContext bundleContext = EngineActivator.getContext();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.osgi.signedcontent.SignedContentFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SignedContentFactory verifierFactory = (SignedContentFactory)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName());
        BundleContext bundleContext2 = EngineActivator.getContext();
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.equinox.internal.provisional.p2.core.IServiceUI");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IServiceUI serviceUI = (IServiceUI)ServiceHelper.getService((BundleContext)bundleContext2, (String)clazz2.getName());
        SignedContent content = null;
        SignerInfo[] signerInfo = null;
        ArrayList<Certificate> untrusted = new ArrayList<Certificate>();
        ArrayList<Certificate[]> untrustedChain = new ArrayList<Certificate[]>();
        IStatus status = Status.OK_STATUS;
        if (this.artifacts.size() == 0 || serviceUI == null) {
            return status;
        }
        Iterator artifact = this.artifacts.iterator();
        TrustEngine trustEngine = (TrustEngine)this.trustEngineTracker.getService();
        while (artifact.hasNext()) {
            try {
                content = verifierFactory.getSignedContent((File)artifact.next());
                if (!content.isSigned()) continue;
                signerInfo = content.getSignerInfos();
            }
            catch (GeneralSecurityException e) {
                return new Status(4, "org.eclipse.equinox.p2.engine", Messages.CertificateChecker_SignedContentError, (Throwable)e);
            }
            catch (IOException e) {
                return new Status(4, "org.eclipse.equinox.p2.engine", Messages.CertificateChecker_SignedContentIOError, (Throwable)e);
            }
            int i = 0;
            while (i < signerInfo.length) {
                Certificate[] certificateChain = signerInfo[i].getCertificateChain();
                try {
                    Certificate trustAnchor = trustEngine.findTrustAnchor(certificateChain);
                    if (trustAnchor == null && !untrusted.contains(certificateChain[0])) {
                        untrusted.add(certificateChain[0]);
                        untrustedChain.add(certificateChain);
                    }
                }
                catch (IOException e) {
                    return new Status(4, "org.eclipse.equinox.p2.engine", Messages.CertificateChecker_KeystoreConnectionError, (Throwable)e);
                }
                ++i;
            }
        }
        if (untrusted.size() > 0) {
            Certificate[][] certificates = new Certificate[untrustedChain.size()][];
            int i = 0;
            while (i < untrustedChain.size()) {
                certificates[i] = (Certificate[])untrustedChain.get(i);
                ++i;
            }
            Certificate[] trustedCertificates = serviceUI.showCertificates(certificates);
            if (trustedCertificates == null) {
                return new Status(4, "org.eclipse.equinox.p2.engine", Messages.CertificateChecker_CertificateRejected);
            }
            int i2 = 0;
            while (i2 < trustedCertificates.length) {
                untrusted.remove(trustedCertificates[i2]);
                ++i2;
            }
            if (untrusted.size() > 0) {
                return new Status(4, "org.eclipse.equinox.p2.engine", Messages.CertificateChecker_CertificateRejected);
            }
            i2 = 0;
            while (i2 < trustedCertificates.length) {
                try {
                    trustEngine.addTrustAnchor(trustedCertificates[i2], trustedCertificates[i2].toString());
                }
                catch (IOException e) {
                    return new Status(1, "org.eclipse.equinox.p2.engine", Messages.CertificateChecker_KeystoreConnectionError, (Throwable)e);
                }
                catch (GeneralSecurityException e) {
                    return new Status(1, "org.eclipse.equinox.p2.engine", Messages.CertificateChecker_CertificateError, (Throwable)e);
                }
                ++i2;
            }
        }
        return status;
    }

    public void add(File toAdd) {
        this.artifacts.add(toAdd);
    }

    public void add(Object[] toAdd) {
        int i = 0;
        while (i < toAdd.length) {
            if (toAdd[i] instanceof File) {
                this.add((File)toAdd[i]);
            }
            ++i;
        }
    }
}

