/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.frameworkadmin;

import org.eclipse.core.runtime.Path;

public class BundleInfo {
    public static final int NO_LEVEL = -1;
    public static final int NO_BUNDLEID = -1;
    private String symbolicName = null;
    private String version = null;
    private String location;
    private long bundleId = -1L;
    private boolean markedAsStarted = false;
    private int startLevel = -1;
    private boolean resolved = false;
    private String manifest;

    public BundleInfo() {
    }

    public BundleInfo(String location) {
        if (location != null) {
            this.location = location.trim();
        }
    }

    public BundleInfo(String location, boolean started) {
        if (location != null) {
            this.location = location.trim();
        }
        this.markedAsStarted = started;
    }

    public BundleInfo(String location, int startLevel) {
        if (location != null) {
            this.location = location.trim();
        }
        this.startLevel = startLevel;
    }

    public BundleInfo(String location, int startLevel, boolean started) {
        if (location != null) {
            this.location = location.trim();
        }
        this.startLevel = startLevel;
        this.markedAsStarted = started;
    }

    public BundleInfo(String location, int startLevel, boolean started, long bundleId) {
        if (location != null) {
            this.location = location.trim();
        }
        this.startLevel = startLevel;
        this.markedAsStarted = started;
        this.bundleId = bundleId;
    }

    public BundleInfo(String symbolic, String version, String location, int startLevel, boolean started) {
        this.symbolicName = symbolic;
        this.version = version;
        if (location != null) {
            this.location = location.trim();
        }
        this.markedAsStarted = started;
        this.startLevel = startLevel;
    }

    public boolean equals(Object toCompare) {
        if (toCompare instanceof BundleInfo) {
            BundleInfo info = (BundleInfo)toCompare;
            if (info.symbolicName != null && info.version != null && this.symbolicName != null && this.version != null) {
                if (info.symbolicName.equals(this.symbolicName) && info.version.equals(this.version) && (info.location == null || this.location == null || new Path(info.location).toFile().equals(new Path(this.location).toFile()))) {
                    return true;
                }
            } else {
                return info.location == null || this.location == null ? false : new Path(info.location).toFile().equals(new Path(this.location).toFile());
            }
        }
        return false;
    }

    public long getBundleId() {
        return this.bundleId;
    }

    public String getLocation() {
        return this.location;
    }

    public String getManifest() {
        return this.manifest;
    }

    public int getStartLevel() {
        return this.startLevel;
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public String getVersion() {
        return this.version;
    }

    public int hashCode() {
        int result = this.symbolicName == null ? 0 : this.symbolicName.hashCode();
        result += this.version == null ? 0 : this.version.hashCode();
        return result += this.location == null ? 0 : new Path(this.location).toFile().hashCode();
    }

    public boolean isMarkedAsStarted() {
        return this.markedAsStarted;
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public void setBundleId(long bundleId) {
        this.bundleId = bundleId;
    }

    public void setLocation(String location) {
        this.location = location != null ? location.trim() : null;
    }

    public void setManifest(String manifest) {
        this.manifest = manifest;
    }

    public void setMarkedAsStarted(boolean markedAsStarted) {
        this.markedAsStarted = markedAsStarted;
    }

    public void setResolved(boolean resolved) {
        this.resolved = resolved;
    }

    public void setStartLevel(int level) {
        this.startLevel = level;
    }

    public void setSymbolicName(String symbolicName) {
        this.symbolicName = symbolicName;
    }

    public void setVersion(String value) {
        this.version = value;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("BundleInfo(");
        if (this.symbolicName != null) {
            buffer.append(this.symbolicName);
        }
        buffer.append(", ");
        if (this.version != null) {
            buffer.append(this.version);
        }
        buffer.append(", ");
        buffer.append("location=");
        buffer.append(this.location);
        buffer.append(", startLevel=");
        buffer.append(this.startLevel);
        buffer.append(", toBeStarted=");
        buffer.append(this.markedAsStarted);
        buffer.append(", resolved=");
        buffer.append(this.resolved);
        buffer.append(", id=");
        buffer.append(this.bundleId);
        buffer.append(',').append(this.manifest == null ? "no manifest" : "manifest available");
        buffer.append(')');
        return buffer.toString();
    }
}

